/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceFile;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceDirectorySet;
import com.android.build.gradle.internal.api.DefaultAndroidSourceFile;
import com.android.builder.model.SourceProvider;
import groovy.lang.Closure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultAndroidSourceSet
implements AndroidSourceSet,
SourceProvider {
    private final String name;
    private final boolean publishPackage;
    private final AndroidSourceDirectorySet javaSource;
    private final AndroidSourceDirectorySet javaResources;
    private final AndroidSourceFile manifest;
    private final AndroidSourceDirectorySet assets;
    private final AndroidSourceDirectorySet res;
    private final AndroidSourceDirectorySet aidl;
    private final AndroidSourceDirectorySet renderscript;
    private final AndroidSourceDirectorySet jni;
    private final AndroidSourceDirectorySet jniLibs;
    private final AndroidSourceDirectorySet shaders;
    private final String displayName;

    public DefaultAndroidSourceSet(String name, Project project, boolean publishPackage) {
        this.name = name;
        this.publishPackage = publishPackage;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        String javaSrcDisplayName = String.format("%s Java source", this.displayName);
        this.javaSource = new DefaultAndroidSourceDirectorySet(javaSrcDisplayName, project);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        String javaResourcesDisplayName = String.format("%s Java resources", this.displayName);
        this.javaResources = new DefaultAndroidSourceDirectorySet(javaResourcesDisplayName, project);
        this.javaResources.getFilter().exclude(new String[]{"**/*.java"});
        String manifestDisplayName = String.format("%s manifest", this.displayName);
        this.manifest = new DefaultAndroidSourceFile(manifestDisplayName, project);
        String assetsDisplayName = String.format("%s assets", this.displayName);
        this.assets = new DefaultAndroidSourceDirectorySet(assetsDisplayName, project);
        String resourcesDisplayName = String.format("%s resources", this.displayName);
        this.res = new DefaultAndroidSourceDirectorySet(resourcesDisplayName, project);
        String aidlDisplayName = String.format("%s aidl", this.displayName);
        this.aidl = new DefaultAndroidSourceDirectorySet(aidlDisplayName, project);
        String renderscriptDisplayName = String.format("%s renderscript", this.displayName);
        this.renderscript = new DefaultAndroidSourceDirectorySet(renderscriptDisplayName, project);
        String jniDisplayName = String.format("%s jni", this.displayName);
        this.jni = new DefaultAndroidSourceDirectorySet(jniDisplayName, project);
        String libsDisplayName = String.format("%s jniLibs", this.displayName);
        this.jniLibs = new DefaultAndroidSourceDirectorySet(libsDisplayName, project);
        String shaderDisplayName = String.format("%s shaders", this.displayName);
        this.shaders = new DefaultAndroidSourceDirectorySet(shaderDisplayName, project);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("source set %s", this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getApiConfigurationName() {
        if (this.name.equals("main")) {
            return "api";
        }
        return String.format("%sApi", this.name);
    }

    @Override
    public String getCompileOnlyConfigurationName() {
        if (this.name.equals("main")) {
            return "compileOnly";
        }
        return String.format("%sCompileOnly", this.name);
    }

    @Override
    public String getImplementationConfigurationName() {
        if (this.name.equals("main")) {
            return "implementation";
        }
        return String.format("%sImplementation", this.name);
    }

    @Override
    public String getRuntimeOnlyConfigurationName() {
        if (this.name.equals("main")) {
            return "runtimeOnly";
        }
        return String.format("%sRuntimeOnly", this.name);
    }

    @Override
    public String getCompileConfigurationName() {
        if (this.name.equals("main")) {
            return "compile";
        }
        return String.format("%sCompile", this.name);
    }

    @Override
    public String getPackageConfigurationName() {
        if (this.publishPackage) {
            if (this.name.equals("main")) {
                return "publish";
            }
            return String.format("%sPublish", this.name);
        }
        if (this.name.equals("main")) {
            return "apk";
        }
        return String.format("%sApk", this.name);
    }

    @Override
    public String getProvidedConfigurationName() {
        if (this.name.equals("main")) {
            return "provided";
        }
        return String.format("%sProvided", this.name);
    }

    @Override
    public String getWearAppConfigurationName() {
        if (this.name.equals("main")) {
            return "wearApp";
        }
        return String.format("%sWearApp", this.name);
    }

    @Override
    public String getAnnotationProcessorConfigurationName() {
        if (this.name.equals("main")) {
            return "annotationProcessor";
        }
        return String.format("%sAnnotationProcessor", this.name);
    }

    @Override
    public String getJackPluginConfigurationName() {
        throw new RuntimeException("AndroidSourceSet.getJackPluginConfigurationName() is not supported anymore.");
    }

    @Override
    public AndroidSourceFile getManifest() {
        return this.manifest;
    }

    @Override
    public AndroidSourceSet manifest(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getManifest());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getRes() {
        return this.res;
    }

    @Override
    public AndroidSourceSet res(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRes());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getAssets() {
        return this.assets;
    }

    @Override
    public AndroidSourceSet assets(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAssets());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getAidl() {
        return this.aidl;
    }

    @Override
    public AndroidSourceSet aidl(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getAidl());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getRenderscript() {
        return this.renderscript;
    }

    @Override
    public AndroidSourceSet renderscript(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getRenderscript());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getJni() {
        return this.jni;
    }

    @Override
    public AndroidSourceSet jni(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJni());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getJniLibs() {
        return this.jniLibs;
    }

    @Override
    public AndroidSourceSet jniLibs(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJniLibs());
        return this;
    }

    @Override
    public AndroidSourceSet shaders(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getShaders());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getShaders() {
        return this.shaders;
    }

    @Override
    public AndroidSourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    public AndroidSourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    @Override
    public AndroidSourceDirectorySet getResources() {
        return this.javaResources;
    }

    @Override
    public AndroidSourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    @Override
    public AndroidSourceSet setRoot(String path) {
        this.javaSource.setSrcDirs(Collections.singletonList(path + "/java"));
        this.javaResources.setSrcDirs(Collections.singletonList(path + "/resources"));
        this.res.setSrcDirs(Collections.singletonList(path + "/" + "res"));
        this.assets.setSrcDirs(Collections.singletonList(path + "/" + "assets"));
        this.manifest.srcFile(path + "/" + "AndroidManifest.xml");
        this.aidl.setSrcDirs(Collections.singletonList(path + "/aidl"));
        this.renderscript.setSrcDirs(Collections.singletonList(path + "/rs"));
        this.jni.setSrcDirs(Collections.singletonList(path + "/jni"));
        this.jniLibs.setSrcDirs(Collections.singletonList(path + "/jniLibs"));
        this.shaders.setSrcDirs(Collections.singletonList(path + "/shaders"));
        return this;
    }

    public Set<File> getJavaDirectories() {
        return this.getJava().getSrcDirs();
    }

    public Set<File> getResourcesDirectories() {
        return this.getResources().getSrcDirs();
    }

    public File getManifestFile() {
        return this.getManifest().getSrcFile();
    }

    public Set<File> getAidlDirectories() {
        return this.getAidl().getSrcDirs();
    }

    public Set<File> getRenderscriptDirectories() {
        return this.getRenderscript().getSrcDirs();
    }

    public Set<File> getCDirectories() {
        return this.getJni().getSrcDirs();
    }

    public Set<File> getCppDirectories() {
        return this.getJni().getSrcDirs();
    }

    public Set<File> getResDirectories() {
        return this.getRes().getSrcDirs();
    }

    public Set<File> getAssetsDirectories() {
        return this.getAssets().getSrcDirs();
    }

    public Collection<File> getJniLibsDirectories() {
        return this.getJniLibs().getSrcDirs();
    }

    public Collection<File> getShadersDirectories() {
        return this.getShaders().getSrcDirs();
    }
}

