/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.builder.model.BaseConfig;
import com.android.builder.model.ClassField;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

abstract class BaseConfigImpl
implements BaseConfig,
Serializable {
    private final String mApplicationIdSuffix;
    private final String mVersionNameSuffix;
    private final Map<String, Object> mManifestPlaceholders;
    private final Map<String, ClassField> mBuildConfigFields;
    private final Map<String, ClassField> mResValues;
    private final Boolean mMultiDexEnabled;
    private final File mMultiDexKeepFile;
    private final File mMultiDexKeepProguard;
    private final List<File> mJarJarRuleFiles;

    protected BaseConfigImpl(BaseConfig baseConfig) {
        this.mApplicationIdSuffix = baseConfig.getApplicationIdSuffix();
        this.mVersionNameSuffix = baseConfig.getVersionNameSuffix();
        this.mManifestPlaceholders = ImmutableMap.copyOf((Map)baseConfig.getManifestPlaceholders());
        this.mBuildConfigFields = ImmutableMap.copyOf((Map)baseConfig.getBuildConfigFields());
        this.mResValues = ImmutableMap.copyOf((Map)baseConfig.getResValues());
        this.mMultiDexEnabled = baseConfig.getMultiDexEnabled();
        this.mMultiDexKeepFile = baseConfig.getMultiDexKeepFile();
        this.mMultiDexKeepProguard = baseConfig.getMultiDexKeepProguard();
        this.mJarJarRuleFiles = ImmutableList.copyOf((Collection)baseConfig.getJarJarRuleFiles());
    }

    public String getApplicationIdSuffix() {
        return this.mApplicationIdSuffix;
    }

    public String getVersionNameSuffix() {
        return this.mVersionNameSuffix;
    }

    public Map<String, ClassField> getBuildConfigFields() {
        return this.mBuildConfigFields;
    }

    public Map<String, ClassField> getResValues() {
        return this.mResValues;
    }

    public List<File> getProguardFiles() {
        return Collections.emptyList();
    }

    public List<File> getConsumerProguardFiles() {
        return Collections.emptyList();
    }

    public Collection<File> getTestProguardFiles() {
        return Collections.emptyList();
    }

    public Map<String, Object> getManifestPlaceholders() {
        return this.mManifestPlaceholders;
    }

    public Boolean getMultiDexEnabled() {
        return this.mMultiDexEnabled;
    }

    public File getMultiDexKeepFile() {
        return this.mMultiDexKeepFile;
    }

    public File getMultiDexKeepProguard() {
        return this.mMultiDexKeepProguard;
    }

    public List<File> getJarJarRuleFiles() {
        if (this.mJarJarRuleFiles == null) {
            return ImmutableList.of();
        }
        return this.mJarJarRuleFiles;
    }

    public String toString() {
        return "BaseConfigImpl{applicationIdSuffix='" + this.mApplicationIdSuffix + '\'' + ", versionNameSuffix='" + this.mVersionNameSuffix + '\'' + ", mManifestPlaceholders=" + this.mManifestPlaceholders + ", mBuildConfigFields=" + this.mBuildConfigFields + ", mResValues=" + this.mResValues + ", mMultiDexEnabled=" + this.mMultiDexEnabled + ", mJarJarRuleFiles=" + this.mJarJarRuleFiles + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseConfigImpl that = (BaseConfigImpl)o;
        return Objects.equals(this.mApplicationIdSuffix, that.mApplicationIdSuffix) && Objects.equals(this.mVersionNameSuffix, that.mVersionNameSuffix) && Objects.equals(this.mManifestPlaceholders, that.mManifestPlaceholders) && Objects.equals(this.mBuildConfigFields, that.mBuildConfigFields) && Objects.equals(this.mResValues, that.mResValues) && Objects.equals(this.mMultiDexEnabled, that.mMultiDexEnabled) && Objects.equals(this.mMultiDexKeepFile, that.mMultiDexKeepFile) && Objects.equals(this.mMultiDexKeepProguard, that.mMultiDexKeepProguard) && Objects.equals(this.mJarJarRuleFiles, that.mJarJarRuleFiles);
    }

    public int hashCode() {
        return Objects.hash(this.mApplicationIdSuffix, this.mVersionNameSuffix, this.mManifestPlaceholders, this.mBuildConfigFields, this.mResValues, this.mMultiDexEnabled, this.mMultiDexKeepFile, this.mMultiDexKeepProguard, this.mJarJarRuleFiles);
    }
}

