/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsonStreamingParser;
import com.android.build.gradle.internal.ide.NativeAndroidProjectImpl;
import com.android.build.gradle.internal.ide.NativeArtifactImpl;
import com.android.build.gradle.internal.ide.NativeFileImpl;
import com.android.build.gradle.internal.ide.NativeSettingsImpl;
import com.android.build.gradle.internal.ide.NativeToolchainImpl;
import com.android.build.gradle.ndk.internal.NativeCompilerArgsUtil;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.Version;
import com.android.utils.StringHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

class NativeAndroidProjectBuilder {
    private final String projectName;
    private final Set<File> buildFiles = Sets.newHashSet();
    private final Map<String, String> extensions = Maps.newHashMap();
    private final List<NativeArtifact> artifacts = Lists.newArrayList();
    private final List<NativeToolchain> toolChains = Lists.newArrayList();
    private final Map<List<String>, NativeSettings> settingsMap = Maps.newHashMap();
    private final Set<String> buildSystems = Sets.newHashSet();
    int settingIndex = 0;

    NativeAndroidProjectBuilder(String projectName) {
        this.projectName = projectName;
    }

    void addBuildSystem(String buildSystem) {
        this.buildSystems.add(buildSystem);
    }

    void addJson(JsonReader reader, String variantName) throws IOException {
        try (JsonStreamingParser parser = new JsonStreamingParser(reader, this, variantName);){
            parser.parse();
        }
    }

    NativeAndroidProject buildOrNull() {
        if (this.buildFiles.isEmpty()) {
            return null;
        }
        return new NativeAndroidProjectImpl(Version.ANDROID_GRADLE_PLUGIN_VERSION, this.projectName, this.buildFiles, this.artifacts, this.toolChains, (Collection<NativeSettings>)ImmutableList.copyOf(this.settingsMap.values()), this.extensions, this.buildSystems, Version.BUILDER_MODEL_API_VERSION);
    }

    private static class JsonStreamingParser
    extends AndroidBuildGradleJsonStreamingParser {
        private final NativeAndroidProjectBuilder builder;
        private final String variantName;
        private String currentToolchain = null;
        private String currentCExecutable = null;
        private String currentCppExecutable = null;
        private String currentLibraryName = null;
        private String currentLibraryToolchain = null;
        private String currentLibraryOutput = null;
        private String currentLibraryAbi = null;
        private String currentLibraryGroupName = null;
        private String currentLibraryArtifactName = null;
        private List<File> currentLibraryRuntimeFiles = null;
        private List<NativeFile> currentLibrarySourceFiles = null;
        private String currentLibraryFileSettingsName = null;
        private String currentLibraryFilePath = null;
        private String currentLibraryFileWorkingDirectory = null;

        JsonStreamingParser(JsonReader reader, NativeAndroidProjectBuilder builder, String variantName) {
            super(reader);
            this.variantName = variantName;
            this.builder = builder;
        }

        static NativeAndroidProjectBuilder createAccumulator(String projectName) {
            return new NativeAndroidProjectBuilder(projectName);
        }

        private static List<String> convertFlagFormat(String flags) {
            return NativeCompilerArgsUtil.transform(StringHelper.tokenizeString((String)flags));
        }

        @Override
        public void visitBuildFile(String buildFile) {
            this.builder.buildFiles.add(new File(buildFile));
        }

        @Override
        public void beginLibrary(String libraryName) {
            this.currentLibraryName = libraryName;
            this.currentLibraryRuntimeFiles = Lists.newArrayList();
            this.currentLibrarySourceFiles = Lists.newArrayList();
        }

        @Override
        public void endLibrary() {
            Preconditions.checkNotNull((Object)this.currentLibraryName);
            Preconditions.checkNotNull((Object)this.currentLibraryToolchain);
            Preconditions.checkNotNull(this.currentLibrarySourceFiles);
            Preconditions.checkNotNull((Object)this.currentLibraryOutput);
            Preconditions.checkNotNull(this.currentLibraryRuntimeFiles);
            Preconditions.checkNotNull((Object)this.currentLibraryAbi);
            Preconditions.checkNotNull((Object)this.currentLibraryArtifactName);
            this.builder.artifacts.add(new NativeArtifactImpl(this.currentLibraryName, this.currentLibraryToolchain, this.variantName, "", (Collection<NativeFolder>)ImmutableList.of(), this.currentLibrarySourceFiles, (Collection<File>)ImmutableList.of(), this.newFileOrNull(this.currentLibraryOutput), this.currentLibraryRuntimeFiles, this.currentLibraryAbi, this.currentLibraryArtifactName));
            this.currentLibraryName = null;
            this.currentLibraryToolchain = null;
            this.currentLibraryOutput = null;
            this.currentLibraryAbi = null;
            this.currentLibraryGroupName = null;
            this.currentLibraryArtifactName = null;
            this.currentLibraryRuntimeFiles = null;
            this.currentLibrarySourceFiles = null;
        }

        @Override
        public void beginToolchain(String toolchain) {
            this.currentToolchain = toolchain;
        }

        @Override
        public void endToolchain() {
            Preconditions.checkNotNull((Object)this.currentToolchain);
            this.builder.toolChains.add(new NativeToolchainImpl(this.currentToolchain, this.newFileOrNull(this.currentCExecutable), this.newFileOrNull(this.currentCppExecutable)));
            this.currentToolchain = null;
            this.currentCExecutable = null;
            this.currentCppExecutable = null;
        }

        private File newFileOrNull(String filename) {
            if (filename == null) {
                return null;
            }
            return new File(filename);
        }

        @Override
        public void visitLibraryAbi(String abi) {
            this.currentLibraryAbi = abi;
        }

        @Override
        public void visitLibraryArtifactName(String artifact) {
            this.currentLibraryArtifactName = artifact;
        }

        @Override
        public void visitLibraryOutput(String output) {
            this.currentLibraryOutput = output;
        }

        @Override
        public void visitLibraryToolchain(String toolchain) {
            this.currentLibraryToolchain = toolchain;
        }

        @Override
        public void visitToolchainCCompilerExecutable(String executable) {
            this.currentCExecutable = executable;
        }

        @Override
        public void visitToolchainCppCompilerExecutable(String executable) {
            this.currentCppExecutable = executable;
        }

        @Override
        public void visitLibraryGroupName(String groupName) {
            this.currentLibraryGroupName = groupName;
        }

        @Override
        public void visitLibraryFileFlags(String flags) {
            this.currentLibraryFileSettingsName = this.getSettingsName(JsonStreamingParser.convertFlagFormat(flags));
        }

        @Override
        public void visitLibraryFileSrc(String src) {
            this.currentLibraryFilePath = src;
        }

        @Override
        public void visitLibraryFileWorkingDirectory(String workingDirectory) {
            this.currentLibraryFileWorkingDirectory = workingDirectory;
        }

        @Override
        public void visitCFileExtensions(String extension) {
            this.builder.extensions.put(extension, "c");
        }

        @Override
        public void visitCppFileExtensions(String extension) {
            this.builder.extensions.put(extension, "c++");
        }

        @Override
        public void visitLibraryRuntimeFile(String runtimeFile) {
            Preconditions.checkNotNull(this.currentLibraryRuntimeFiles);
            this.currentLibraryRuntimeFiles.add(new File(runtimeFile));
        }

        @Override
        public void endLibraryFile() {
            Preconditions.checkNotNull(this.currentLibrarySourceFiles);
            Preconditions.checkNotNull((Object)this.currentLibraryFileSettingsName);
            Preconditions.checkNotNull((Object)this.currentLibraryFilePath);
            this.currentLibrarySourceFiles.add(new NativeFileImpl(new File(this.currentLibraryFilePath), this.currentLibraryFileSettingsName, this.newFileOrNull(this.currentLibraryFileWorkingDirectory)));
            this.currentLibraryFilePath = null;
            this.currentLibraryFileSettingsName = null;
            this.currentLibraryFileWorkingDirectory = null;
        }

        private String getSettingsName(List<String> flags) {
            ImmutableList flagsCopy = ImmutableList.copyOf(flags);
            NativeSettings setting = (NativeSettings)this.builder.settingsMap.get(flags);
            if (setting == null) {
                setting = new NativeSettingsImpl("setting" + this.builder.settingIndex, (List<String>)flagsCopy);
                this.builder.settingsMap.put(flagsCopy, setting);
                ++this.builder.settingIndex;
            }
            return setting.getName();
        }
    }
}

