/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.FeatureVariantFactory;
import com.android.build.gradle.internal.variant.LibraryVariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.internal.reflect.Instantiator;

public class MultiTypeVariantFactory
extends BaseVariantFactory {
    private final Map<VariantType, BaseVariantFactory> delegates;

    public MultiTypeVariantFactory(GlobalScope globalScope, AndroidBuilder androidBuilder, Instantiator instantiator, AndroidConfig extension) {
        super(globalScope, androidBuilder, instantiator, extension);
        this.delegates = ImmutableMap.of((Object)VariantType.FEATURE, (Object)new FeatureVariantFactory(globalScope, androidBuilder, instantiator, extension), (Object)VariantType.LIBRARY, (Object)new LibraryVariantFactory(globalScope, androidBuilder, instantiator, extension));
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        return this.delegates.get(variantConfiguration.getType()).createVariantData(variantConfiguration, taskManager, recorder);
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return this.delegates.get(variantData.getType()).getVariantImplementationClass(variantData);
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        return ImmutableList.of((Object)VariantType.FEATURE, (Object)VariantType.LIBRARY);
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
        for (BaseVariantFactory variantFactory : this.delegates.values()) {
            variantFactory.validateModel(model);
        }
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

