/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.gradle.internal.CombinedInput;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;

public class LintOptions
implements com.android.builder.model.LintOptions,
Serializable {
    private static final long serialVersionUID = 1L;
    private Set<String> disable = Sets.newHashSet();
    private Set<String> enable = Sets.newHashSet();
    private Set<String> check = Sets.newHashSet();
    private boolean abortOnError = true;
    private boolean absolutePaths = true;
    private boolean noLines;
    private boolean quiet;
    private boolean checkAllWarnings;
    private boolean ignoreWarnings;
    private boolean warningsAsErrors;
    private boolean showAll;
    private boolean checkReleaseBuilds = true;
    private boolean explainIssues = true;
    private boolean checkTestSources;
    private boolean checkGeneratedSources;
    private boolean checkDependencies;
    private File lintConfig;
    private boolean textReport;
    private File textOutput;
    private boolean htmlReport = true;
    private File htmlOutput;
    private boolean xmlReport = true;
    private File xmlOutput;
    private Map<String, Integer> severities = Maps.newHashMap();
    private File baselineFile;

    @Inject
    public LintOptions() {
    }

    public LintOptions(Set<String> disable, Set<String> enable, Set<String> check, File lintConfig, boolean textReport, File textOutput, boolean htmlReport, File htmlOutput, boolean xmlReport, File xmlOutput, boolean abortOnError, boolean absolutePaths, boolean noLines, boolean quiet, boolean checkAllWarnings, boolean ignoreWarnings, boolean warningsAsErrors, boolean showAll, boolean explainIssues, boolean checkReleaseBuilds, boolean checkTestSources, boolean checkGeneratedSources, boolean checkDependencies, File baselineFile, Map<String, Integer> severityOverrides) {
        this.disable = disable;
        this.enable = enable;
        this.check = check;
        this.lintConfig = lintConfig;
        this.textReport = textReport;
        this.textOutput = textOutput;
        this.htmlReport = htmlReport;
        this.htmlOutput = htmlOutput;
        this.xmlReport = xmlReport;
        this.xmlOutput = xmlOutput;
        this.abortOnError = abortOnError;
        this.absolutePaths = absolutePaths;
        this.noLines = noLines;
        this.quiet = quiet;
        this.checkAllWarnings = checkAllWarnings;
        this.ignoreWarnings = ignoreWarnings;
        this.warningsAsErrors = warningsAsErrors;
        this.showAll = showAll;
        this.explainIssues = explainIssues;
        this.checkReleaseBuilds = checkReleaseBuilds;
        this.checkTestSources = checkTestSources;
        this.checkGeneratedSources = checkGeneratedSources;
        this.checkDependencies = checkDependencies;
        this.baselineFile = baselineFile;
        if (severityOverrides != null) {
            for (Map.Entry<String, Integer> entry : severityOverrides.entrySet()) {
                this.severities.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static com.android.builder.model.LintOptions create(com.android.builder.model.LintOptions source) {
        return new LintOptions(source.getDisable(), source.getEnable(), source.getCheck(), source.getLintConfig(), source.getTextReport(), source.getTextOutput(), source.getHtmlReport(), source.getHtmlOutput(), source.getXmlReport(), source.getXmlOutput(), source.isAbortOnError(), source.isAbsolutePaths(), source.isNoLines(), source.isQuiet(), source.isCheckAllWarnings(), source.isIgnoreWarnings(), source.isWarningsAsErrors(), source.isShowAll(), source.isExplainIssues(), source.isCheckReleaseBuilds(), source.isCheckTestSources(), source.isCheckGeneratedSources(), source.isCheckDependencies(), source.getBaselineFile(), source.getSeverityOverrides());
    }

    @Input
    public Set<String> getDisable() {
        return this.disable;
    }

    public void setDisable(Set<String> ids) {
        this.disable.addAll(ids);
    }

    @Input
    public Set<String> getEnable() {
        return this.enable;
    }

    public void setEnable(Set<String> ids) {
        this.enable.addAll(ids);
    }

    @Optional
    @Input
    public Set<String> getCheck() {
        return this.check;
    }

    public void setCheck(Set<String> ids) {
        this.check.addAll(ids);
    }

    @Input
    public boolean isAbortOnError() {
        return this.abortOnError;
    }

    public void setAbortOnError(boolean abortOnError) {
        this.abortOnError = abortOnError;
    }

    @Input
    public boolean isAbsolutePaths() {
        return this.absolutePaths;
    }

    public void setAbsolutePaths(boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
    }

    @Input
    public boolean isNoLines() {
        return this.noLines;
    }

    public void setNoLines(boolean noLines) {
        this.noLines = noLines;
    }

    @Input
    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Input
    public boolean isCheckAllWarnings() {
        return this.checkAllWarnings;
    }

    public void setCheckAllWarnings(boolean warnAll) {
        this.checkAllWarnings = warnAll;
    }

    @Input
    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean noWarnings) {
        this.ignoreWarnings = noWarnings;
    }

    @Input
    public boolean isWarningsAsErrors() {
        return this.warningsAsErrors;
    }

    public void setWarningsAsErrors(boolean allErrors) {
        this.warningsAsErrors = allErrors;
    }

    public boolean isCheckTestSources() {
        return this.checkTestSources;
    }

    public void setCheckTestSources(boolean checkTestSources) {
        this.checkTestSources = checkTestSources;
    }

    public boolean isCheckGeneratedSources() {
        return this.checkGeneratedSources;
    }

    public void setCheckGeneratedSources(boolean checkGeneratedSources) {
        this.checkGeneratedSources = checkGeneratedSources;
    }

    @Input
    public boolean isCheckDependencies() {
        return this.checkDependencies;
    }

    public void setCheckDependencies(boolean checkDependencies) {
        this.checkDependencies = checkDependencies;
    }

    @Input
    public boolean isExplainIssues() {
        return this.explainIssues;
    }

    public void setExplainIssues(boolean explainIssues) {
        this.explainIssues = explainIssues;
    }

    @Input
    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    @Input
    public boolean isCheckReleaseBuilds() {
        return this.checkReleaseBuilds;
    }

    public void setCheckReleaseBuilds(boolean checkReleaseBuilds) {
        this.checkReleaseBuilds = checkReleaseBuilds;
    }

    @Optional
    @InputFile
    public File getLintConfig() {
        return this.lintConfig;
    }

    @Input
    public boolean getTextReport() {
        return this.textReport;
    }

    public void setTextReport(boolean textReport) {
        this.textReport = textReport;
    }

    public void setHtmlReport(boolean htmlReport) {
        this.htmlReport = htmlReport;
    }

    public void setHtmlOutput(File htmlOutput) {
        this.htmlOutput = htmlOutput;
    }

    public void setXmlReport(boolean xmlReport) {
        this.xmlReport = xmlReport;
    }

    public void setXmlOutput(File xmlOutput) {
        if (xmlOutput.getName().equals("lint.xml")) {
            throw new GradleException("Don't set the xmlOutput file to \"lint.xml\"; that's a reserved filename used for for lint configuration files, not reports.");
        }
        this.xmlOutput = xmlOutput;
    }

    @Optional
    @Input
    public File getTextOutput() {
        return this.textOutput;
    }

    @Input
    public boolean getHtmlReport() {
        return this.htmlReport;
    }

    @Optional
    @OutputFile
    public File getHtmlOutput() {
        return this.htmlOutput;
    }

    @Input
    public boolean getXmlReport() {
        return this.xmlReport;
    }

    @Optional
    @OutputFile
    public File getXmlOutput() {
        return this.xmlOutput;
    }

    public void setLintConfig(File lintConfig) {
        this.lintConfig = lintConfig;
    }

    public File getBaselineFile() {
        return this.baselineFile;
    }

    public void setBaselineFile(File baselineFile) {
        this.baselineFile = baselineFile;
    }

    public void baseline(String baseline) {
        File file = new File(baseline);
        if (!file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        this.baselineFile = file;
    }

    public void baseline(File baselineFile) {
        this.baselineFile = baselineFile;
    }

    public Map<String, Integer> getSeverityOverrides() {
        if (this.severities == null || this.severities.isEmpty()) {
            return null;
        }
        return this.severities;
    }

    public void check(String id) {
        this.check.add(id);
    }

    public void check(String ... ids) {
        for (String id : ids) {
            this.check(id);
        }
    }

    public void enable(String id) {
        this.enable.add(id);
        this.severities.put(id, 6);
    }

    public void enable(String ... ids) {
        for (String id : ids) {
            this.enable(id);
        }
    }

    public void disable(String id) {
        this.disable.add(id);
        this.severities.put(id, 5);
    }

    public void disable(String ... ids) {
        for (String id : ids) {
            this.disable(id);
        }
    }

    public void textOutput(String textOutput) {
        this.textOutput = new File(textOutput);
    }

    public void textOutput(File textOutput) {
        this.textOutput = textOutput;
    }

    public void fatal(String id) {
        this.severities.put(id, 1);
    }

    public void fatal(String ... ids) {
        for (String id : ids) {
            this.fatal(id);
        }
    }

    public void error(String id) {
        this.severities.put(id, 2);
    }

    public void error(String ... ids) {
        for (String id : ids) {
            this.error(id);
        }
    }

    public void warning(String id) {
        this.severities.put(id, 3);
    }

    public void warning(String ... ids) {
        for (String id : ids) {
            this.warning(id);
        }
    }

    public void ignore(String id) {
        this.severities.put(id, 5);
    }

    public void ignore(String ... ids) {
        for (String id : ids) {
            this.ignore(id);
        }
    }

    public void informational(String id) {
        this.severities.put(id, 4);
    }

    public void informational(String ... ids) {
        for (String id : ids) {
            this.informational(id);
        }
    }

    @Input
    public String getCombinedInput() {
        return new CombinedInput().add("htmlOutput", this.getHtmlOutput()).add("xmlOutput", this.getXmlOutput()).toString();
    }
}

