/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.builder.model.SigningConfig;
import com.android.builder.utils.SynchronizedFile;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.ExecutionException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

public class ValidateSigningTask
extends AndroidBuilderTask {
    private SigningConfig signingConfig;

    public void setSigningConfig(SigningConfig signingConfig) {
        this.signingConfig = (SigningConfig)Preconditions.checkNotNull((Object)signingConfig);
    }

    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    @Input
    @Optional
    public String getStoreLocation() {
        File f = this.signingConfig.getStoreFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    @TaskAction
    public void validate() throws ExecutionException, AndroidLocation.AndroidLocationException {
        File storeFile = this.signingConfig.getStoreFile();
        if (storeFile == null) {
            throw new IllegalArgumentException("Keystore file not set for signing config " + this.signingConfig.getName());
        }
        if (FileUtils.isSameFile((File)new File(KeystoreHelper.defaultDebugKeystoreLocation()), (File)storeFile)) {
            Preconditions.checkState((boolean)FileUtils.parentDirExists((File)storeFile), (Object)("Parent directory of " + storeFile.getAbsolutePath() + " does not exist"));
            SynchronizedFile synchronizedStoreFile = SynchronizedFile.getInstanceWithMultiProcessLocking((File)storeFile);
            synchronizedStoreFile.createIfAbsent(sameStoreFile -> {
                Preconditions.checkState((boolean)this.signingConfig.isSigningReady(), (Object)"Debug signing config not ready.");
                File storeDirectory = storeFile.getParentFile();
                if (!storeDirectory.canWrite()) {
                    String message = "Unable to create debug keystore in \"" + storeDirectory.getAbsolutePath() + "\" because it is not writable.";
                    throw new BuildException(message, null);
                }
                this.getLogger().info("Creating default debug keystore at {}", (Object)storeFile.getAbsolutePath());
                if (!KeystoreHelper.createDebugStore((String)this.signingConfig.getStoreType(), (File)this.signingConfig.getStoreFile(), (String)this.signingConfig.getStorePassword(), (String)this.signingConfig.getKeyPassword(), (String)this.signingConfig.getKeyAlias(), (ILogger)this.getILogger())) {
                    throw new BuildException("Unable to recreate missing debug keystore.", null);
                }
            });
        } else if (!storeFile.exists()) {
            throw new IllegalArgumentException(String.format("Keystore file %s not found for signing config '%s'.", storeFile.getAbsolutePath(), this.signingConfig.getName()));
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<ValidateSigningTask> {
        private PackagingScope mPackagingScope;

        public ConfigAction(PackagingScope packagingScope) {
            this.mPackagingScope = packagingScope;
        }

        @Override
        public String getName() {
            return this.mPackagingScope.getTaskName("validateSigning");
        }

        @Override
        public Class<ValidateSigningTask> getType() {
            return ValidateSigningTask.class;
        }

        @Override
        public void execute(ValidateSigningTask task) {
            task.setAndroidBuilder(this.mPackagingScope.getAndroidBuilder());
            task.setVariantName(this.mPackagingScope.getFullVariantName());
            CoreSigningConfig signingConfig = this.mPackagingScope.getSigningConfig();
            Preconditions.checkState((signingConfig != null ? 1 : 0) != 0, (String)"No signing config configured for variant %s.", (Object)this.mPackagingScope.getFullVariantName());
            task.setSigningConfig(signingConfig);
        }
    }
}

