/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import android.databinding.tool.util.Preconditions;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.ExtendedContentType;
import com.android.build.gradle.internal.transforms.DexMergerTransformCallable;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessOutput;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0010\u0010\u001c\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0\u001dH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/build/gradle/internal/transforms/ExternalLibsMergerTransform;", "Lcom/android/build/api/transform/Transform;", "dexingType", "Lcom/android/builder/dexing/DexingType;", "dexMergerTool", "Lcom/android/builder/dexing/DexMergerTool;", "minSdkVersion", "", "isDebuggable", "", "messageReceiver", "Lcom/android/ide/common/blame/MessageReceiver;", "callableFactory", "Lcom/android/build/gradle/internal/transforms/DexMergerTransformCallable$Factory;", "(Lcom/android/builder/dexing/DexingType;Lcom/android/builder/dexing/DexMergerTool;IZLcom/android/ide/common/blame/MessageReceiver;Lcom/android/build/gradle/internal/transforms/DexMergerTransformCallable$Factory;)V", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "kotlin.jvm.PlatformType", "logger", "Lcom/android/build/gradle/internal/LoggerWrapper;", "getInputTypes", "", "Lcom/android/build/api/transform/QualifiedContent$ContentType;", "getName", "", "getParameterInputs", "", "", "getScopes", "", "Lcom/android/build/api/transform/QualifiedContent$Scope;", "isIncremental", "transform", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "gradle-core_main"})
public final class ExternalLibsMergerTransform
extends Transform {
    private final LoggerWrapper logger;
    private final ForkJoinPool forkJoinPool;
    private final DexingType dexingType;
    private final DexMergerTool dexMergerTool;
    private final int minSdkVersion;
    private final boolean isDebuggable;
    private final MessageReceiver messageReceiver;
    private final DexMergerTransformCallable.Factory callableFactory;

    @NotNull
    public String getName() {
        return "externalLibsDexMerger";
    }

    @NotNull
    public Set<QualifiedContent.ContentType> getInputTypes() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)((Object)ExtendedContentType.DEX_ARCHIVE));
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of(ExtendedContentType.DEX_ARCHIVE)");
        return (Set)immutableSet;
    }

    @NotNull
    public Set<? super QualifiedContent.Scope> getScopes() {
        ImmutableSet immutableSet = ImmutableSet.of((Object)QualifiedContent.Scope.EXTERNAL_LIBRARIES);
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableSet, (String)"ImmutableSet.of(Qualifie\u2026Scope.EXTERNAL_LIBRARIES)");
        return (Set)immutableSet;
    }

    @NotNull
    public Map<String, Object> getParameterInputs() {
        ImmutableMap immutableMap = ImmutableMap.builder().put((Object)"dexing-type", (Object)this.dexingType.name()).put((Object)"dex-merger-tool", (Object)this.dexMergerTool.name()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.builder<Str\u2026\n                .build()");
        return (Map)immutableMap;
    }

    public boolean isIncremental() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformInvocation transformInvocation) {
        Object object;
        JarInput it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        TransformInput it2;
        Iterable $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)transformInvocation, (String)"transformInvocation");
        Iterable $receiver$iv2 = transformInvocation.getInputs();
        Iterable iterable = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            it2 = (TransformInput)element$iv$iv;
            Iterable list$iv$iv = it2.getJarInputs();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List flattenInputs = (List)destination$iv$iv;
        if (transformInvocation.isIncremental()) {
            $receiver$iv2 = flattenInputs;
            $receiver$iv$iv2 = $receiver$iv2;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv2) {
                it2 = (JarInput)element$iv$iv;
                if (!(Intrinsics.areEqual((Object)it2.getStatus(), (Object)Status.NOTCHANGED) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            if (((List)destination$iv$iv).isEmpty()) {
                return;
            }
        }
        Preconditions.check((transformInvocation.getOutputProvider() != null ? 1 : 0) != 0, (String)"No OutputProvider for ExternalLibsMergerTransform", (Object[])new Object[0]);
        $receiver$iv$iv2 = flattenInputs;
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (JarInput)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it.getStatus(), (Object)Status.REMOVED) ^ true)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (JarInput)item$iv$iv;
            Collection collection = destination$iv$iv2;
            Path path = it.getFile().toPath();
            collection.add(path);
        }
        List jarInputList = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, (ILogger)this.logger), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), (ILogger)this.logger), new MessageReceiver[]{this.messageReceiver});
        TransformOutputProvider transformOutputProvider = transformInvocation.getOutputProvider();
        if (transformOutputProvider == null) {
            Intrinsics.throwNpe();
        }
        File outputDir = transformOutputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
        FileUtils.cleanOutputDir((File)outputDir);
        if (jarInputList.isEmpty()) {
            return;
        }
        Closeable closeable = (Closeable)outputHandler.createOutput();
        boolean bl = false;
        try {
            ProcessOutput processOutputHandler = (ProcessOutput)closeable;
            DexMergerTransformCallable callable = this.callableFactory.create(this.dexingType, processOutputHandler, outputDir, jarInputList, null, this.forkJoinPool, this.dexMergerTool, this.minSdkVersion, this.isDebuggable);
            Void void_ = callable.call();
            object = closeable;
        }
        catch (Exception exception) {
            try {
                bl = true;
                try {
                    Object object2 = closeable;
                    if (object2 != null) {
                        object2.close();
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw (Throwable)exception;
            }
            catch (Throwable throwable) {
                if (!bl) {
                    Object object3 = closeable;
                    if (object3 != null) {
                        object3.close();
                    }
                }
                throw throwable;
            }
        }
        if (object != null) {
            object.close();
        }
    }

    public ExternalLibsMergerTransform(@NotNull DexingType dexingType, @NotNull DexMergerTool dexMergerTool, int minSdkVersion, boolean isDebuggable, @NotNull MessageReceiver messageReceiver, @NotNull DexMergerTransformCallable.Factory callableFactory) {
        Intrinsics.checkParameterIsNotNull((Object)dexingType, (String)"dexingType");
        Intrinsics.checkParameterIsNotNull((Object)dexMergerTool, (String)"dexMergerTool");
        Intrinsics.checkParameterIsNotNull((Object)messageReceiver, (String)"messageReceiver");
        Intrinsics.checkParameterIsNotNull((Object)callableFactory, (String)"callableFactory");
        this.dexingType = dexingType;
        this.dexMergerTool = dexMergerTool;
        this.minSdkVersion = minSdkVersion;
        this.isDebuggable = isDebuggable;
        this.messageReceiver = messageReceiver;
        this.callableFactory = callableFactory;
        this.logger = LoggerWrapper.getLogger(ExternalLibsMergerTransform.class);
        this.forkJoinPool = ForkJoinPool.commonPool();
    }
}

