/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.NamedDomainObjectContainer;

public class ApplicationVariantFactory
extends BaseVariantFactory
implements VariantFactory {
    public ApplicationVariantFactory(GlobalScope globalScope, AndroidBuilder androidBuilder, AndroidConfig extension) {
        super(globalScope, androidBuilder, extension);
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        ApplicationVariantData variant = new ApplicationVariantData(this.globalScope, this.extension, variantConfiguration, taskManager, recorder);
        variant.calculateFilters(this.extension.getSplits());
        Set<String> densities = variant.getFilters(VariantOutput.FilterType.DENSITY);
        Set<String> abis = variant.getFilters(VariantOutput.FilterType.ABI);
        if (!densities.isEmpty()) {
            variant.setCompatibleScreens(this.extension.getSplits().getDensity().getCompatibleScreens());
        }
        OutputScope outputScope = variant.getOutputScope();
        OutputFactory outputFactory = variant.getOutputFactory();
        if (outputScope.getMultiOutputPolicy() == MultiOutputPolicy.MULTI_APK) {
            if (abis.isEmpty()) {
                if (densities.isEmpty()) {
                    outputFactory.addMainApk();
                } else {
                    outputFactory.addUniversalApk();
                }
            } else {
                if (this.extension.getSplits().getAbi().isEnable() && this.extension.getSplits().getAbi().isUniversalApk()) {
                    outputFactory.addUniversalApk();
                }
                abis.forEach(abi -> outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi))));
            }
            for (String density : densities) {
                if (!abis.isEmpty()) {
                    for (String abi2 : abis) {
                        outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi2), (Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
                    }
                    continue;
                }
                outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
            }
        } else {
            outputFactory.addMainApk();
        }
        return variant;
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return ApplicationVariantImpl.class;
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        return ImmutableList.of((Object)VariantType.DEFAULT);
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

