/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.Option;

public enum LongOption implements Option<Long>
{
    DEPRECATED_NDK_COMPILE_LEASE("android.deprecatedNdkCompileLease");

    private final String propertyName;

    private LongOption(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public final String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public final Long getDefaultValue() {
        return null;
    }

    @Override
    public final Long parse(Object value) {
        if (value instanceof CharSequence) {
            try {
                return Long.parseLong(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new IllegalArgumentException("Cannot parse project property " + this.getPropertyName() + "='" + value + "' of type '" + value.getClass() + "' as long.");
    }
}

