/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.BuildOutputs;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.FeatureVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.ManifestProvider;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;

@CacheableTask
public class MergeManifests
extends ManifestProcessorTask {
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<Integer> maxSdkVersion;
    private VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration;
    private ArtifactCollection manifests;
    private ArtifactCollection featureManifests;
    private FileCollection microApkManifest;
    private FileCollection compatibleScreensManifest;
    private FileCollection packageManifest;
    private List<ManifestMerger2.Invoker.Feature> optionalFeatures;
    private OutputScope outputScope;
    private Set<String> supportedAbis;
    private String buildTargetAbi;
    private String buildTargetDensity;
    private String featureName;

    @Override
    protected void doFullTaskAction() throws IOException {
        Collection<BuildOutput> compatibleScreenManifests = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.COMPATIBLE_SCREEN_MANIFEST, this.compatibleScreensManifest);
        String packageOverride = this.packageManifest != null && !this.packageManifest.isEmpty() ? ApplicationId.load(this.packageManifest.getSingleFile()).getApplicationId() : this.getPackageOverride();
        List<ApkData> splitsToGenerate = LinkApplicationAndroidResourcesTask.getApksToGenerate(this.outputScope, this.supportedAbis, this.buildTargetAbi, this.buildTargetDensity);
        for (ApkData apkData : splitsToGenerate) {
            BuildOutput compatibleScreenManifestForSplit = OutputScope.getOutput(compatibleScreenManifests, (TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.COMPATIBLE_SCREEN_MANIFEST, (ApkInfo)apkData);
            File manifestOutputFile = FileUtils.join((File)this.getManifestOutputDirectory(), (String[])new String[]{apkData.getDirName(), "AndroidManifest.xml"});
            File instantRunManifestOutputFile = FileUtils.join((File)this.getInstantRunManifestOutputDirectory(), (String[])new String[]{apkData.getDirName(), "AndroidManifest.xml"});
            MergingReport mergingReport = this.getBuilder().mergeManifestsForApplication(this.getMainManifest(), this.getManifestOverlays(), this.computeFullProviderList(compatibleScreenManifestForSplit), this.getFeatureName(), packageOverride, apkData.getVersionCode(), apkData.getVersionName(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), manifestOutputFile.getAbsolutePath(), null, instantRunManifestOutputFile.getAbsolutePath(), ManifestMerger2.MergeType.APPLICATION, this.variantConfiguration.getManifestPlaceholders(), this.getOptionalFeatures(), this.getReportFile());
            XmlDocument mergedXmlDocument = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
            ImmutableMap properties = mergedXmlDocument != null ? ImmutableMap.of((Object)"packageId", (Object)mergedXmlDocument.getPackageName(), (Object)"split", (Object)mergedXmlDocument.getSplitName(), (Object)"minSdkVersion", (Object)mergedXmlDocument.getMinSdkVersion()) : ImmutableMap.of();
            this.outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, apkData, manifestOutputFile, (Map<String, String>)properties);
            this.outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS, apkData, instantRunManifestOutputFile, (Map<String, String>)properties);
        }
        this.outputScope.save((ImmutableList<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS), this.getManifestOutputDirectory());
        this.outputScope.save((ImmutableList<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.INSTANT_RUN_MERGED_MANIFESTS), this.getInstantRunManifestOutputDirectory());
    }

    @Override
    @Internal
    public File getAaptFriendlyManifestOutputFile() {
        return null;
    }

    @Optional
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getMainManifest() {
        return this.variantConfiguration.getMainManifest();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getManifestOverlays() {
        return this.variantConfiguration.getManifestOverlays();
    }

    @Input
    @Optional
    public String getPackageOverride() {
        return this.variantConfiguration.getIdOverride();
    }

    @Input
    public List<Integer> getVersionCodes() {
        return this.outputScope.getApkDatas().stream().map(ApkData::getVersionCode).collect(Collectors.toList());
    }

    @Input
    @Optional
    public List<String> getVersionNames() {
        return this.outputScope.getApkDatas().stream().map(ApkData::getVersionName).collect(Collectors.toList());
    }

    @Input
    @Optional
    public String getManifestPlaceholders() {
        return MergeManifests.serializeMap(this.variantConfiguration.getManifestPlaceholders());
    }

    private List<ManifestProvider> computeFullProviderList(BuildOutput compatibleScreenManifestForSplit) {
        File microManifest;
        Set artifacts = this.manifests.getArtifacts();
        ArrayList providers = Lists.newArrayListWithCapacity((int)(artifacts.size() + 2));
        for (ResolvedArtifactResult artifact : artifacts) {
            providers.add(new ConfigAction.ManifestProviderImpl(artifact.getFile(), MergeManifests.getArtifactName(artifact)));
        }
        if (this.microApkManifest != null && (microManifest = this.microApkManifest.getSingleFile()).isFile()) {
            providers.add(new ConfigAction.ManifestProviderImpl(microManifest, "Wear App sub-manifest"));
        }
        if (compatibleScreenManifestForSplit != null) {
            providers.add(new ConfigAction.ManifestProviderImpl(compatibleScreenManifestForSplit.getOutputFile(), "Compatible-Screens sub-manifest"));
        }
        if (this.featureManifests != null) {
            Set featureArtifacts = this.featureManifests.getArtifacts();
            for (ResolvedArtifactResult artifact : featureArtifacts) {
                File directory = artifact.getFile();
                Collection<BuildOutput> splitOutputs = BuildOutputs.load((TaskOutputHolder.OutputType)TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, directory);
                if (splitOutputs.isEmpty()) {
                    throw new GradleException("Could not load manifest from " + directory);
                }
                providers.add(new ConfigAction.ManifestProviderImpl(splitOutputs.iterator().next().getOutputFile(), MergeManifests.getArtifactName(artifact)));
            }
        }
        return providers;
    }

    @Internal
    public static String getArtifactName(ResolvedArtifactResult artifact) {
        ComponentIdentifier id = artifact.getId().getComponentIdentifier();
        if (id instanceof ProjectComponentIdentifier) {
            return ((ProjectComponentIdentifier)id).getProjectPath();
        }
        if (id instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier mID = (ModuleComponentIdentifier)id;
            return mID.getGroup() + ":" + mID.getModule() + ":" + mID.getVersion();
        }
        if (id instanceof OpaqueComponentArtifactIdentifier) {
            return id.getDisplayName();
        }
        if (id instanceof ArtifactCollectionWithExtraArtifact.ExtraComponentIdentifier) {
            return id.getDisplayName();
        }
        throw new RuntimeException("Unsupported type of ComponentIdentifier");
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion.get();
    }

    @Internal
    public List<ManifestMerger2.Invoker.Feature> getOptionalFeatures() {
        return this.optionalFeatures;
    }

    @Input
    public List<String> getOptionalFeaturesString() {
        return this.optionalFeatures.stream().map(Enum::toString).collect(Collectors.toList());
    }

    @Internal
    public VariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantConfiguration(VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getManifests() {
        return this.manifests.getArtifactFiles();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getFeatureManifests() {
        if (this.featureManifests == null) {
            return null;
        }
        return this.featureManifests.getArtifactFiles();
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getMicroApkManifest() {
        return this.microApkManifest;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCompatibleScreensManifest() {
        return this.compatibleScreensManifest;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getPackageManifest() {
        return this.packageManifest;
    }

    @Input
    @Optional
    public Set<String> getSupportedAbis() {
        return this.supportedAbis;
    }

    @Input
    @Optional
    public String getBuildTargetAbi() {
        return this.buildTargetAbi;
    }

    @Input
    @Optional
    public String getBuildTargetDensity() {
        return this.buildTargetDensity;
    }

    @Input
    @Optional
    public String getFeatureName() {
        return this.featureName;
    }

    public static class BaseFeatureConfigAction
    extends ConfigAction {
        public BaseFeatureConfigAction(VariantScope scope, List<ManifestMerger2.Invoker.Feature> optionalFeatures) {
            super(scope, optionalFeatures, null);
        }

        @Override
        public void execute(MergeManifests processManifestTask) {
            super.execute(processManifestTask);
            processManifestTask.packageManifest = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_APP_ID_DECLARATION);
            processManifestTask.featureManifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.METADATA_VALUES, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.METADATA_FEATURE_MANIFEST);
        }
    }

    public static class FeatureConfigAction
    extends ConfigAction {
        public FeatureConfigAction(VariantScope scope, List<ManifestMerger2.Invoker.Feature> optionalFeatures) {
            super(scope, optionalFeatures, null);
        }

        @Override
        public void execute(MergeManifests processManifestTask) {
            super.execute(processManifestTask);
            processManifestTask.featureName = ((FeatureVariantData)this.variantScope.getVariantData()).getFeatureName();
            processManifestTask.packageManifest = this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_APPLICATION_ID_DECLARATION);
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeManifests> {
        protected final VariantScope variantScope;
        protected final List<ManifestMerger2.Invoker.Feature> optionalFeatures;
        private final File reportFile;

        public ConfigAction(VariantScope scope, List<ManifestMerger2.Invoker.Feature> optionalFeatures, File reportFile) {
            this.variantScope = scope;
            this.optionalFeatures = optionalFeatures;
            this.reportFile = reportFile;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<MergeManifests> getType() {
            return MergeManifests.class;
        }

        @Override
        public void execute(MergeManifests processManifestTask) {
            BaseVariantData variantData = this.variantScope.getVariantData();
            GradleVariantConfiguration config = variantData.getVariantConfiguration();
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            AndroidBuilder androidBuilder = globalScope.getAndroidBuilder();
            ProjectOptions projectOptions = this.variantScope.getGlobalScope().getProjectOptions();
            processManifestTask.setAndroidBuilder(androidBuilder);
            processManifestTask.setVariantName(config.getFullName());
            processManifestTask.outputScope = variantData.getOutputScope();
            processManifestTask.setVariantConfiguration(config);
            Project project = globalScope.getProject();
            processManifestTask.manifests = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.MANIFEST);
            if (this.variantScope.getMicroApkTask() != null && ((CoreBuildType)config.getBuildType()).isEmbedMicroApp()) {
                processManifestTask.microApkManifest = (FileCollection)project.files(new Object[]{this.variantScope.getMicroApkManifestFile()});
            }
            processManifestTask.compatibleScreensManifest = this.variantScope.getOutput(TaskOutputHolder.TaskOutputType.COMPATIBLE_SCREEN_MANIFEST);
            processManifestTask.minSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion minSdk = config.getMergedFlavor().getMinSdkVersion();
                return minSdk == null ? null : minSdk.getApiString();
            });
            processManifestTask.targetSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion targetSdk = config.getMergedFlavor().getTargetSdkVersion();
                return targetSdk == null ? null : targetSdk.getApiString();
            });
            processManifestTask.maxSdkVersion = TaskInputHelper.memoize(() -> ((ProductFlavor)config.getMergedFlavor()).getMaxSdkVersion());
            processManifestTask.setManifestOutputDirectory(this.variantScope.getManifestOutputDirectory());
            processManifestTask.setInstantRunManifestOutputDirectory(this.variantScope.getInstantRunManifestOutputDirectory());
            processManifestTask.setReportFile(this.reportFile);
            processManifestTask.optionalFeatures = this.optionalFeatures;
            processManifestTask.supportedAbis = variantData.getVariantConfiguration().getSupportedAbis();
            processManifestTask.buildTargetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) || this.variantScope.getGlobalScope().getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
            processManifestTask.buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
            this.variantScope.getVariantData().addTask(TaskContainer.TaskKind.PROCESS_MANIFEST, (Task)processManifestTask);
        }

        public static class ManifestProviderImpl
        implements ManifestProvider {
            private final File manifest;
            private final String name;

            public ManifestProviderImpl(File manifest, String name) {
                this.manifest = manifest;
                this.name = name;
            }

            public File getManifest() {
                return this.manifest;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

