/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.utils.FileCache;
import com.android.prefs.AndroidLocation;
import java.io.File;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.Project;

public final class BuildCacheUtils {
    public static final String BUILD_CACHE_TROUBLESHOOTING_MESSAGE = "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html.";

    public static FileCache createBuildCacheIfEnabled(Project project, ProjectOptions projectOptions) {
        return BuildCacheUtils.createBuildCacheIfEnabled(arg_0 -> ((Project)project.getRootProject()).file(arg_0), projectOptions);
    }

    static FileCache createBuildCacheIfEnabled(Function<Object, File> rootProjectFile, ProjectOptions projectOptions) {
        Supplier<File> defaultBuildCacheDirSupplier = () -> {
            try {
                return new File(AndroidLocation.getFolder(), "build-cache");
            }
            catch (AndroidLocation.AndroidLocationException e) {
                throw new RuntimeException(e);
            }
        };
        return BuildCacheUtils.doCreateBuildCacheIfEnabled(rootProjectFile, projectOptions, defaultBuildCacheDirSupplier);
    }

    static FileCache doCreateBuildCacheIfEnabled(Function<Object, File> rootProjectFile, ProjectOptions projectOptions, Supplier<File> defaultBuildCacheDirSupplier) {
        if (projectOptions.get(BooleanOption.ENABLE_BUILD_CACHE)) {
            String buildCacheDirOverride = projectOptions.get(StringOption.BUILD_CACHE_DIR);
            return FileCache.getInstanceWithMultiProcessLocking((File)(buildCacheDirOverride != null ? rootProjectFile.apply(buildCacheDirOverride) : defaultBuildCacheDirSupplier.get()));
        }
        return null;
    }
}

