/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.builder.model.AndroidArtifactOutput;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

final class AndroidArtifactOutputImpl
implements AndroidArtifactOutput,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BuildOutput buildOutput;
    private final BuildOutput manifestOutput;
    private final Collection<BuildOutput> splitApksOutputs;

    public AndroidArtifactOutputImpl(BuildOutput buildOutput, BuildOutput manifestOutput) {
        this(buildOutput, manifestOutput, (List<BuildOutput>)ImmutableList.of());
    }

    public AndroidArtifactOutputImpl(BuildOutput mainApk, BuildOutput manifestOutput, List<BuildOutput> splitApksOutputs) {
        this.buildOutput = mainApk;
        this.manifestOutput = manifestOutput;
        this.splitApksOutputs = splitApksOutputs;
    }

    public File getOutputFile() {
        return this.getMainOutputFile().getOutputFile();
    }

    public OutputFile getMainOutputFile() {
        return this.buildOutput;
    }

    public Collection<OutputFile> getOutputs() {
        ImmutableList.Builder outputFileBuilder = ImmutableList.builder();
        outputFileBuilder.add((Object)this.buildOutput);
        this.splitApksOutputs.forEach(arg_0 -> ((ImmutableList.Builder)outputFileBuilder).add(arg_0));
        return outputFileBuilder.build();
    }

    public String getAssembleTaskName() {
        throw new RuntimeException("Deprecated.");
    }

    public String getOutputType() {
        return this.buildOutput.getOutputType();
    }

    public Collection<String> getFilterTypes() {
        return this.buildOutput.getFilterTypes();
    }

    public String getFilter(String filterType) {
        return this.buildOutput.getFilter(filterType);
    }

    public Collection<FilterData> getFilters() {
        return this.buildOutput.getFilters();
    }

    public File getGeneratedManifest() {
        return this.manifestOutput.getOutputFile();
    }

    public int getVersionCode() {
        return this.buildOutput.getApkInfo().getVersionCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidArtifactOutputImpl that = (AndroidArtifactOutputImpl)o;
        return Objects.equals(this.buildOutput, that.buildOutput) && Objects.equals(this.manifestOutput, that.manifestOutput) && Objects.equals(this.splitApksOutputs, that.splitApksOutputs);
    }

    public int hashCode() {
        return Objects.hash(this.splitApksOutputs, this.manifestOutput, this.buildOutput);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("output", (Object)this.buildOutput).add("manifest", (Object)this.manifestOutput).add("pure splits", this.splitApksOutputs).toString();
    }
}

