/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.ProductFlavor;
import com.android.ide.common.build.ApkInfo;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.tools.ant.BuildException;
import org.gradle.api.Task;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public class ProcessManifest
extends ManifestProcessorTask {
    private Supplier<String> minSdkVersion;
    private Supplier<String> targetSdkVersion;
    private Supplier<Integer> maxSdkVersion;
    private VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration;
    private OutputScope outputScope;
    private File manifestOutputFile;

    @Override
    protected void doFullTaskAction() {
        File aaptFriendlyManifestOutputFile = this.getAaptFriendlyManifestOutputFile();
        MergingReport mergingReport = this.getBuilder().mergeManifestsForApplication(this.getMainManifest(), this.getManifestOverlays(), Collections.emptyList(), this.getNavigationFiles(), null, this.getPackageOverride(), this.getVersionCode(), this.getVersionName(), this.getMinSdkVersion(), this.getTargetSdkVersion(), this.getMaxSdkVersion(), this.manifestOutputFile.getAbsolutePath(), aaptFriendlyManifestOutputFile.getAbsolutePath(), null, ManifestMerger2.MergeType.LIBRARY, this.variantConfiguration.getManifestPlaceholders(), Collections.emptyList(), this.getReportFile());
        XmlDocument mergedXmlDocument = mergingReport.getMergedXmlDocument(MergingReport.MergedManifestKind.MERGED);
        ImmutableMap properties = mergedXmlDocument != null ? ImmutableMap.of((Object)"packageId", (Object)mergedXmlDocument.getPackageName(), (Object)"split", (Object)mergedXmlDocument.getSplitName()) : ImmutableMap.of();
        this.outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, (ApkInfo)this.outputScope.getMainSplit(), this.manifestOutputFile, (Map<String, String>)properties);
        this.outputScope.addOutputForSplit(TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS, (ApkInfo)this.outputScope.getMainSplit(), aaptFriendlyManifestOutputFile, (Map<String, String>)properties);
        try {
            this.outputScope.save(TaskOutputHolder.TaskOutputType.MERGED_MANIFESTS, this.getManifestOutputDirectory());
            this.outputScope.save(TaskOutputHolder.TaskOutputType.AAPT_FRIENDLY_MERGED_MANIFESTS, this.getAaptFriendlyManifestOutputDirectory());
        }
        catch (IOException e) {
            throw new BuildException("Exception while saving build metadata : ", (Throwable)e);
        }
    }

    @Override
    @Internal
    public File getAaptFriendlyManifestOutputFile() {
        Preconditions.checkNotNull((Object)this.outputScope.getMainSplit());
        return FileUtils.join((File)this.getAaptFriendlyManifestOutputDirectory(), (String[])new String[]{this.outputScope.getMainSplit().getDirName(), "AndroidManifest.xml"});
    }

    @Input
    @Optional
    public String getMinSdkVersion() {
        return this.minSdkVersion.get();
    }

    @Input
    @Optional
    public String getTargetSdkVersion() {
        return this.targetSdkVersion.get();
    }

    @Input
    @Optional
    public Integer getMaxSdkVersion() {
        return this.maxSdkVersion.get();
    }

    @Internal
    public VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantConfiguration(VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> variantConfiguration) {
        this.variantConfiguration = variantConfiguration;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getMainManifest() {
        return this.variantConfiguration.getMainManifest();
    }

    @Input
    @Optional
    public String getPackageOverride() {
        return this.variantConfiguration.getApplicationId();
    }

    @Input
    public int getVersionCode() {
        return this.variantConfiguration.getVersionCode();
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.variantConfiguration.getVersionName();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getManifestOverlays() {
        return this.variantConfiguration.getManifestOverlays();
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public List<File> getNavigationFiles() {
        return this.variantConfiguration.getNavigationFiles();
    }

    @Input
    @Optional
    public String getManifestPlaceholders() {
        return ProcessManifest.serializeMap(this.variantConfiguration.getManifestPlaceholders());
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessManifest> {
        private final VariantScope scope;
        private final File libraryProcessedManifest;
        private final File reportFile;

        public ConfigAction(VariantScope scope, File libraryProcessedManifest, File reportFile) {
            this.scope = scope;
            this.libraryProcessedManifest = libraryProcessedManifest;
            this.reportFile = reportFile;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Manifest");
        }

        @Override
        public Class<ProcessManifest> getType() {
            return ProcessManifest.class;
        }

        @Override
        public void execute(ProcessManifest processManifest) {
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            AndroidBuilder androidBuilder = this.scope.getGlobalScope().getAndroidBuilder();
            processManifest.setAndroidBuilder(androidBuilder);
            processManifest.setVariantName(config.getFullName());
            processManifest.manifestOutputFile = this.libraryProcessedManifest;
            processManifest.variantConfiguration = config;
            ProductFlavor mergedFlavor = config.getMergedFlavor();
            processManifest.minSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion minSdkVersion1 = mergedFlavor.getMinSdkVersion();
                if (minSdkVersion1 == null) {
                    return null;
                }
                return minSdkVersion1.getApiString();
            });
            processManifest.targetSdkVersion = TaskInputHelper.memoize(() -> {
                ApiVersion targetSdkVersion = mergedFlavor.getTargetSdkVersion();
                if (targetSdkVersion == null) {
                    return null;
                }
                return targetSdkVersion.getApiString();
            });
            processManifest.maxSdkVersion = TaskInputHelper.memoize(() -> ((ProductFlavor)mergedFlavor).getMaxSdkVersion());
            processManifest.setManifestOutputDirectory(this.scope.getManifestOutputDirectory());
            processManifest.setAaptFriendlyManifestOutputDirectory(this.scope.getAaptFriendlyManifestOutputDirectory());
            processManifest.outputScope = this.scope.getOutputScope();
            processManifest.setReportFile(this.reportFile);
            this.scope.getVariantData().addTask(TaskContainer.TaskKind.PROCESS_MANIFEST, (Task)processManifest);
        }
    }
}

