/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ide;

import com.android.build.FilterData;
import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.ide.AaptOptionsImpl;
import com.android.build.gradle.internal.ide.AndroidArtifactImpl;
import com.android.build.gradle.internal.ide.BuildOutputsSupplier;
import com.android.build.gradle.internal.ide.BuildTypeContainerImpl;
import com.android.build.gradle.internal.ide.DefaultAndroidProject;
import com.android.build.gradle.internal.ide.DefaultInstantAppProjectBuildOutput;
import com.android.build.gradle.internal.ide.DefaultInstantAppVariantBuildOutput;
import com.android.build.gradle.internal.ide.EarlySyncBuildOutput;
import com.android.build.gradle.internal.ide.InstantRunImpl;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.ide.ProductFlavorImpl;
import com.android.build.gradle.internal.ide.VariantImpl;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.InstantAppOutputScope;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TaskContainer;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SyncIssue;
import com.android.builder.model.Version;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class InstantAppModelBuilder
implements ToolingModelBuilder {
    private int modelLevel = 0;
    private final AndroidConfig config;
    private final ExtraModelInfo extraModelInfo;
    private final VariantManager variantManager;
    private final int generation;
    private boolean modelWithFullDependency = false;
    private Set<SyncIssue> syncIssues = Sets.newLinkedHashSet();

    public InstantAppModelBuilder(VariantManager variantManager, AndroidConfig config, ExtraModelInfo extraModelInfo, int generation) {
        this.config = config;
        this.extraModelInfo = extraModelInfo;
        this.variantManager = variantManager;
        this.generation = generation;
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName()) || modelName.equals(InstantAppProjectBuildOutput.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        if (modelName.equals(AndroidProject.class.getName())) {
            return this.buildAndroidProject(project);
        }
        if (modelName.equals(InstantAppProjectBuildOutput.class.getName())) {
            return this.buildMinimalisticModel();
        }
        return null;
    }

    private Object buildAndroidProject(Project project) {
        ProjectOptions projectOptions = new ProjectOptions(project);
        Integer modelLevelInt = SyncOptions.buildModelOnlyVersion(projectOptions);
        if (modelLevelInt != null) {
            this.modelLevel = modelLevelInt;
        }
        if (this.modelLevel < 3) {
            throw new RuntimeException("This Gradle plugin requires a newer IDE able to request IDE model level 3. For Android Studio this means version 3.0+");
        }
        this.modelWithFullDependency = projectOptions.get(BooleanOption.IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES);
        ProductFlavorContainer defaultConfig2 = ProductFlavorContainerImpl.createProductFlavorContainer(this.variantManager.getDefaultConfig(), this.extraModelInfo.getExtraFlavorSourceProviders(this.variantManager.getDefaultConfig().getProductFlavor().getName()));
        this.syncIssues.addAll((Collection<SyncIssue>)this.extraModelInfo.getSyncIssueHandler().getSyncIssues());
        ArrayList flavorDimensionList = this.config.getFlavorDimensionList() != null ? this.config.getFlavorDimensionList() : Lists.newArrayList();
        ArrayList buildTypes = Lists.newArrayList();
        ArrayList productFlavors = Lists.newArrayList();
        ArrayList variants = Lists.newArrayList();
        for (BuildTypeData buildTypeData : this.variantManager.getBuildTypes().values()) {
            buildTypes.add(BuildTypeContainerImpl.create(buildTypeData, this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeData.getBuildType().getName())));
        }
        for (ProductFlavorData productFlavorData : this.variantManager.getProductFlavors().values()) {
            productFlavors.add(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, this.extraModelInfo.getExtraFlavorSourceProviders(productFlavorData.getProductFlavor().getName())));
        }
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            if (variantScope.getVariantData().getType().isForTesting()) continue;
            variants.add(this.createVariant(variantScope.getVariantData()));
        }
        return new DefaultAndroidProject(project.getName(), defaultConfig2, flavorDimensionList, buildTypes, productFlavors, variants, "android-26", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), AaptOptionsImpl.createDummy(), Collections.emptyList(), this.syncIssues, new CompileOptions(), new LintOptions(), project.getBuildDir(), "", Collections.emptyList(), "", 4, Version.BUILDER_MODEL_API_VERSION, this.generation, false);
    }

    private Object buildMinimalisticModel() {
        ImmutableList.Builder variantsOutput = ImmutableList.builder();
        for (VariantScope variantScope : this.variantManager.getVariantScopes()) {
            InstantAppOutputScope instantAppOutputScope = null;
            try {
                instantAppOutputScope = InstantAppOutputScope.load(variantScope.getApkLocation());
            }
            catch (IOException e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while loading output.json", e);
            }
            if (instantAppOutputScope == null) continue;
            variantsOutput.add((Object)new DefaultInstantAppVariantBuildOutput(variantScope.getFullVariantName(), instantAppOutputScope.getApplicationId(), new BuildOutput(TaskOutputHolder.TaskOutputType.INSTANTAPP_BUNDLE, ApkInfo.of((VariantOutput.OutputType)VariantOutput.OutputType.MAIN, (Collection)ImmutableList.of(), (int)0), instantAppOutputScope.getInstantAppBundle()), (Collection<EarlySyncBuildOutput>)new BuildOutputsSupplier((List<TaskOutputHolder.OutputType>)ImmutableList.of((Object)TaskOutputHolder.TaskOutputType.APK, (Object)TaskOutputHolder.TaskOutputType.ABI_PACKAGED_SPLIT, (Object)TaskOutputHolder.TaskOutputType.DENSITY_OR_LANGUAGE_PACKAGED_SPLIT), instantAppOutputScope.getApkDirectories()).get()));
        }
        return new DefaultInstantAppProjectBuildOutput((ImmutableList<InstantAppVariantBuildOutput>)variantsOutput.build());
    }

    private VariantImpl createVariant(BaseVariantData variantData) {
        VariantScope variantScope = variantData.getScope();
        ImmutableMap<String, String> buildMapping = ModelBuilder.computeBuildMapping(variantScope.getGlobalScope().getProject().getGradle());
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        Pair<Dependencies, DependencyGraphs> dependencies = ModelBuilder.getDependencies(variantScope, buildMapping, this.extraModelInfo, this.syncIssues, this.modelLevel, this.modelWithFullDependency);
        Task assembleTask = variantData.getTaskByKind(TaskContainer.TaskKind.ASSEMBLE);
        File outputLocation = variantScope.getApkLocation();
        String baseName = variantScope.getGlobalScope().getProjectBaseName() + "-" + variantConfiguration.getBaseName();
        AndroidArtifactImpl mainArtifact = new AndroidArtifactImpl("_main_", baseName, assembleTask == null ? variantScope.getTaskName("assemble") : assembleTask.getName(), false, null, "unused", variantScope.getTaskName("dummy"), variantScope.getTaskName("dummy"), Collections.emptyList(), Collections.emptyList(), new File(""), Collections.emptySet(), new File(""), (Dependencies)dependencies.getFirst(), (DependencyGraphs)dependencies.getSecond(), Collections.emptyList(), null, null, null, Collections.emptyList(), variantConfiguration.getMergedBuildConfigFields(), variantConfiguration.getMergedResValues(), new InstantRunImpl(BuildInfoWriterTask.ConfigAction.getBuildInfoFile(variantScope), variantConfiguration.getInstantRunSupportStatus()), () -> ImmutableList.of((Object)new EarlySyncBuildOutput(TaskOutputHolder.TaskOutputType.INSTANTAPP_BUNDLE, VariantOutput.OutputType.MAIN, (Collection<? extends FilterData>)ImmutableList.of(), -1, new File(outputLocation, baseName + ".zip"))), new BuildOutputsSupplier((List<TaskOutputHolder.OutputType>)ImmutableList.of(), (List<File>)ImmutableList.of()), null, null);
        return new VariantImpl(variantConfiguration.getFullName(), variantConfiguration.getBaseName(), ((CoreBuildType)variantConfiguration.getBuildType()).getName(), variantData.getVariantConfiguration().getProductFlavors().stream().map(ProductFlavor::getName).collect(Collectors.toList()), new ProductFlavorImpl(variantConfiguration.getMergedFlavor()), mainArtifact, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }
}

