/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.ClassLookupException;
import com.android.build.gradle.shrinker.DependencyRemoverVisitor;
import com.android.build.gradle.shrinker.IncrementalRunVisitor;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.parser.BytecodeVersion;
import com.android.build.gradle.shrinker.tracing.NoOpTracer;
import com.android.ide.common.internal.WaitableExecutor;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;

public class IncrementalShrinker<T>
extends AbstractShrinker<T> {
    public IncrementalShrinker(WaitableExecutor executor, ShrinkerGraph<T> graph, ShrinkerLogger shrinkerLogger, BytecodeVersion bytecodeVersion) {
        super(graph, executor, shrinkerLogger, bytecodeVersion);
    }

    public void incrementalRun(Iterable<TransformInput> inputs, TransformOutputProvider output) throws IOException, IncrementalRunImpossibleException {
        Set modifiedClasses = Sets.newConcurrentHashSet();
        Set unresolvedReferences = Sets.newConcurrentHashSet();
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<T, State<T>> oldState = this.saveState();
        IncrementalShrinker.logTime("save state", stopwatch);
        this.clearCounters();
        IncrementalShrinker.logTime("clear counters", stopwatch);
        this.processInputs(inputs, modifiedClasses, unresolvedReferences);
        IncrementalShrinker.logTime("process inputs", stopwatch);
        this.finishGraph(unresolvedReferences);
        IncrementalShrinker.logTime("finish graph", stopwatch);
        this.setCounters(AbstractShrinker.CounterSet.SHRINK, new NoOpTracer());
        IncrementalShrinker.logTime("set counters", stopwatch);
        Changes<T> changes = this.calculateChanges(inputs, output, oldState, modifiedClasses);
        IncrementalShrinker.logTime("choose classes", stopwatch);
        this.updateClassFiles(changes.classesToWrite, changes.classFilesToDelete, inputs, output);
        IncrementalShrinker.logTime("update class files", stopwatch);
        this.mGraph.saveState();
        IncrementalShrinker.logTime("save state", stopwatch);
    }

    private Changes<T> calculateChanges(Iterable<TransformInput> inputs, TransformOutputProvider output, Map<T, State<T>> oldStates, Set<T> modifiedClasses) {
        Set classesToWrite = Sets.newConcurrentHashSet();
        Set classFilesToDelete = Sets.newConcurrentHashSet();
        for (Object klass : this.mGraph.getReachableClasses(AbstractShrinker.CounterSet.SHRINK)) {
            if (!oldStates.containsKey(klass)) {
                classesToWrite.add(klass);
            } else {
                try {
                    State<T> oldState = oldStates.get(klass);
                    Set<String> newMembers = this.mGraph.getReachableMembersLocalNames(klass, AbstractShrinker.CounterSet.SHRINK);
                    Set newInterfaces = this.getReachableImplementedInterfaces(klass);
                    Set newTypesFromSignatures = this.getReachableTypesFromSignatures(klass);
                    if (modifiedClasses.contains(klass) || !newMembers.equals(oldState.members) || !newTypesFromSignatures.equals(oldState.typesFromGenericSignatures) || !newInterfaces.equals(oldState.interfaces)) {
                        classesToWrite.add(klass);
                    }
                }
                catch (ClassLookupException e) {
                    throw new AssertionError("Reachable class not found in graph.", e);
                }
            }
            oldStates.remove(klass);
        }
        for (Object klass : oldStates.keySet()) {
            File sourceFile = this.mGraph.getSourceFile(klass);
            Preconditions.checkState((sourceFile != null ? 1 : 0) != 0, (Object)"One of the inputs has no source file.");
            Optional<File> outputFile = this.chooseOutputFile(klass, sourceFile, inputs, output);
            if (!outputFile.isPresent()) {
                throw new IllegalStateException("Can't determine path of " + this.mGraph.getClassName(klass));
            }
            classFilesToDelete.add(outputFile.get());
        }
        return new Changes(classesToWrite, classFilesToDelete);
    }

    private Set<T> getReachableImplementedInterfaces(T klass) throws ClassLookupException {
        return Stream.of(this.mGraph.getInterfaces(klass)).filter(iface -> this.mGraph.isReachable(iface, AbstractShrinker.CounterSet.SHRINK)).collect(Collectors.toSet());
    }

    private Set<T> getReachableTypesFromSignatures(T klass) throws ClassLookupException {
        return this.mGraph.getTypesFromGenericSignatures(klass).stream().filter(typeFromSignature -> this.mGraph.isReachable(typeFromSignature, AbstractShrinker.CounterSet.SHRINK)).collect(Collectors.toSet());
    }

    private Map<T, State<T>> saveState() {
        HashMap oldState = new HashMap();
        for (Object klass : this.mGraph.getReachableClasses(AbstractShrinker.CounterSet.SHRINK)) {
            try {
                Set<String> reachableMembers = this.mGraph.getReachableMembersLocalNames(klass, AbstractShrinker.CounterSet.SHRINK);
                Set typesFromGenericSignatures = this.getReachableTypesFromSignatures(klass);
                Set interfaces = this.getReachableImplementedInterfaces(klass);
                oldState.put(klass, new State(reachableMembers, interfaces, typesFromGenericSignatures));
            }
            catch (ClassLookupException e) {
                throw new AssertionError("Reachable class not found in graph.", e);
            }
        }
        return oldState;
    }

    private void clearCounters() {
        this.mGraph.clearCounters(this.mExecutor);
        this.waitForAllTasks();
    }

    private void finishGraph(Iterable<PostProcessingData.UnresolvedReference<T>> unresolvedReferences) {
        this.resolveReferences(unresolvedReferences);
        this.waitForAllTasks();
    }

    private void processInputs(Iterable<TransformInput> inputs, Collection<T> modifiedClasses, Collection<PostProcessingData.UnresolvedReference<T>> unresolvedReferences) throws IncrementalRunImpossibleException {
        for (TransformInput input : inputs) {
            for (JarInput jarInput : input.getJarInputs()) {
                switch (jarInput.getStatus()) {
                    case ADDED: 
                    case REMOVED: 
                    case CHANGED: {
                        throw new IncrementalRunImpossibleException(String.format("Input jar %s has been %s.", jarInput.getFile(), jarInput.getStatus().name().toLowerCase()));
                    }
                }
            }
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                for (Map.Entry changedFile : directoryInput.getChangedFiles().entrySet()) {
                    this.mExecutor.execute(() -> {
                        switch ((Status)changedFile.getValue()) {
                            case ADDED: {
                                throw new IncrementalRunImpossibleException(String.format("File %s added.", changedFile.getKey()));
                            }
                            case REMOVED: {
                                throw new IncrementalRunImpossibleException(String.format("File %s removed.", changedFile.getKey()));
                            }
                            case CHANGED: {
                                this.processChangedClassFile((File)changedFile.getKey(), unresolvedReferences, modifiedClasses);
                                break;
                            }
                        }
                        return null;
                    });
                }
            }
        }
        this.waitForAllTasks();
    }

    private void processChangedClassFile(File file, Collection<PostProcessingData.UnresolvedReference<T>> unresolvedReferences, Collection<T> modifiedClasses) throws IncrementalRunImpossibleException {
        try {
            ClassReader classReader = new ClassReader(Files.toByteArray((File)file));
            IncrementalRunVisitor<T> visitor = new IncrementalRunVisitor<T>(this.mGraph, modifiedClasses, unresolvedReferences);
            DependencyRemoverVisitor remover = new DependencyRemoverVisitor(this.mGraph, visitor);
            classReader.accept(remover, 0);
        }
        catch (IncrementalRunImpossibleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process " + file.getAbsolutePath(), e);
        }
    }

    @Override
    protected void waitForAllTasks() {
        try {
            super.waitForAllTasks();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IncrementalRunImpossibleException) {
                throw (IncrementalRunImpossibleException)e.getCause();
            }
            throw e;
        }
    }

    private static final class Changes<T> {
        final Set<T> classesToWrite;
        final Set<File> classFilesToDelete;

        private Changes(Set<T> classesToWrite, Set<File> classFilesToDelete) {
            this.classesToWrite = classesToWrite;
            this.classFilesToDelete = classFilesToDelete;
        }
    }

    private static final class State<T> {
        final ImmutableSet<String> members;
        final ImmutableSet<T> interfaces;
        final ImmutableSet<T> typesFromGenericSignatures;

        public State(Iterable<String> members, Iterable<T> interfaces, Iterable<T> typesFromGenericSignatures) {
            this.members = ImmutableSet.copyOf(members);
            this.interfaces = ImmutableSet.copyOf(interfaces);
            this.typesFromGenericSignatures = ImmutableSet.copyOf(typesFromGenericSignatures);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return Objects.equal(this.members, state.members) && Objects.equal(this.interfaces, state.interfaces) && Objects.equal(this.typesFromGenericSignatures, state.typesFromGenericSignatures);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.members, this.interfaces, this.typesFromGenericSignatures});
        }
    }

    public static class IncrementalRunImpossibleException
    extends RuntimeException {
        IncrementalRunImpossibleException(String message) {
            super(message);
        }

        IncrementalRunImpossibleException(Throwable cause) {
            super("Failed to load incremental state.", cause);
        }
    }
}

