/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.sdk.TargetInfo;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import org.gradle.api.tasks.Internal;

public abstract class AndroidBuilderTask
extends AndroidVariantTask {
    private AndroidBuilder androidBuilder;
    private ILogger iLogger;

    @Internal(value="No influence on output, this is to give access to the build to other classes")
    protected AndroidBuilder getBuilder() {
        Preconditions.checkState((this.androidBuilder != null ? 1 : 0) != 0, (String)"androidBuilder required for task '%s'.", (Object)this.getName());
        return this.androidBuilder;
    }

    @Internal
    protected ILogger getILogger() {
        if (this.iLogger == null) {
            this.iLogger = new LoggerWrapper(this.getLogger());
        }
        return this.iLogger;
    }

    @Internal(value="No influence on output, this is to give access to the build tools")
    protected BuildToolInfo getBuildTools() {
        TargetInfo targetInfo = this.getBuilder().getTargetInfo();
        Preconditions.checkState((targetInfo != null ? 1 : 0) != 0, (String)"androidBuilder.targetInfo required for task '%s'.", (Object)this.getName());
        return targetInfo.getBuildTools();
    }

    public void setAndroidBuilder(AndroidBuilder androidBuilder) {
        this.androidBuilder = androidBuilder;
    }
}

