/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import java.io.File;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class DataBindingExportBuildInfoTask
extends DefaultTask {
    private LayoutXmlProcessor xmlProcessor;
    private File sdkDir;
    private File xmlOutFolder;
    private File exportClassListTo;
    private File dataBindingClassOutput;
    private Supplier<FileCollection> compilerClasspath;
    private Supplier<Collection<ConfigurableFileTree>> compilerSources;
    private FileCollection mergedResources;

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getMergedResources() {
        return this.mergedResources;
    }

    @TaskAction
    public void exportInfo(IncrementalTaskInputs inputs) {
        this.xmlProcessor.writeEmptyInfoClass();
        Scope.assertNoError();
    }

    public LayoutXmlProcessor getXmlProcessor() {
        return this.xmlProcessor;
    }

    public void setXmlProcessor(LayoutXmlProcessor xmlProcessor) {
        this.xmlProcessor = xmlProcessor;
    }

    @Classpath
    public FileCollection getCompilerClasspath() {
        return this.compilerClasspath.get();
    }

    @InputFiles
    public Iterable<ConfigurableFileTree> getCompilerSources() {
        return this.compilerSources.get();
    }

    @Input
    public File getSdkDir() {
        return this.sdkDir;
    }

    public void setSdkDir(File sdkDir) {
        this.sdkDir = sdkDir;
    }

    @InputDirectory
    public File getXmlOutFolder() {
        return this.xmlOutFolder;
    }

    public void setXmlOutFolder(File xmlOutFolder) {
        this.xmlOutFolder = xmlOutFolder;
    }

    @Input
    @Optional
    public File getExportClassListTo() {
        return this.exportClassListTo;
    }

    public void setExportClassListTo(File exportClassListTo) {
        this.exportClassListTo = exportClassListTo;
    }

    @OutputDirectory
    public File getOutput() {
        return this.dataBindingClassOutput;
    }

    public void setDataBindingClassOutput(File dataBindingClassOutput) {
        this.dataBindingClassOutput = dataBindingClassOutput;
    }

    public static class ConfigAction
    implements TaskConfigAction<DataBindingExportBuildInfoTask> {
        private final VariantScope variantScope;
        private final TaskManager.MergeType mergeType;

        public ConfigAction(VariantScope variantScope, TaskManager.MergeType mergeType) {
            this.variantScope = variantScope;
            this.mergeType = mergeType;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("dataBindingExportBuildInfo");
        }

        @Override
        public Class<DataBindingExportBuildInfoTask> getType() {
            return DataBindingExportBuildInfoTask.class;
        }

        @Override
        public void execute(DataBindingExportBuildInfoTask task) {
            BaseVariantData variantData = this.variantScope.getVariantData();
            task.setXmlProcessor(variantData.getLayoutXmlProcessor());
            task.setSdkDir(this.variantScope.getGlobalScope().getSdkHandler().getSdkFolder());
            task.setXmlOutFolder(this.variantScope.getLayoutInfoOutputForDataBinding());
            task.compilerClasspath = () -> this.variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
            task.compilerSources = () -> variantData.getJavaSources().stream().filter(input -> !this.variantScope.getClassOutputForDataBinding().equals(input.getDir())).collect(Collectors.toList());
            task.mergedResources = this.variantScope.getOutput(this.mergeType.getOutputType());
            task.setExportClassListTo(variantData.getType().isExportDataBindingClassList() ? this.variantScope.getGeneratedClassListOutputFileForDataBinding() : null);
            task.setDataBindingClassOutput(this.variantScope.getClassOutputForDataBinding());
        }
    }
}

