/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.packaging;

import com.android.apkzlib.zfile.ApkCreatorFactory;
import com.android.apkzlib.zfile.ApkZFileCreatorFactory;
import com.android.apkzlib.zip.Compressor;
import com.android.apkzlib.zip.ZFileOptions;
import com.android.apkzlib.zip.compress.BestAndDefaultDeflateExecutorCompressor;
import com.android.apkzlib.zip.compress.DeflateExecutionCompressor;
import com.android.build.gradle.AndroidGradleOptions;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Project;

public final class ApkCreatorFactories {
    private static final long BACKGROUND_THREAD_DISCARD_TIME_MS = 100L;
    private static final int MAXIMUM_COMPRESSION_THREADS = 2;

    private ApkCreatorFactories() {
    }

    public static ApkCreatorFactory fromProjectProperties(Project project, boolean debuggableBuild) {
        boolean keepTimestamps = AndroidGradleOptions.keepTimestampsInApk(project);
        ZFileOptions options = new ZFileOptions();
        options.setNoTimestamps(!keepTimestamps);
        options.setCoverEmptySpaceUsingExtraField(true);
        ThreadPoolExecutor compressionExecutor = new ThreadPoolExecutor(0, 2, 100L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        if (debuggableBuild) {
            options.setCompressor((Compressor)new DeflateExecutionCompressor((Executor)compressionExecutor, options.getTracker(), 1));
        } else {
            options.setCompressor((Compressor)new BestAndDefaultDeflateExecutorCompressor((Executor)compressionExecutor, options.getTracker(), 1.0));
            options.setAutoSortFiles(true);
        }
        return new ApkZFileCreatorFactory(options);
    }
}

