/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.builder.core.DesugarProcessBuilder;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class ExtractTryWithResourcesSupportJar
extends AndroidVariantTask {
    public static final String TASK_NAME = "extractTryWithResourcesSupportJar";
    private ConfigurableFileCollection outputLocation;

    @TaskAction
    public void run() throws IOException {
        try (InputStream in = DesugarProcessBuilder.class.getClassLoader().getResourceAsStream("libthrowable_extension.jar");){
            FileUtils.cleanOutputDir((File)this.outputLocation.getSingleFile().getParentFile());
            Files.copy(in, this.outputLocation.getSingleFile().toPath(), new CopyOption[0]);
        }
    }

    @OutputFile
    public File getOutputLocation() {
        return this.outputLocation.getSingleFile();
    }

    public static class ConfigAction
    implements TaskConfigAction<ExtractTryWithResourcesSupportJar> {
        private final ConfigurableFileCollection outputLocation;
        private final String taskName;
        private final String variantName;

        public ConfigAction(ConfigurableFileCollection outputLocation, String taskName, String variantName) {
            this.outputLocation = outputLocation;
            this.taskName = taskName;
            this.variantName = variantName;
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<ExtractTryWithResourcesSupportJar> getType() {
            return ExtractTryWithResourcesSupportJar.class;
        }

        @Override
        public void execute(ExtractTryWithResourcesSupportJar task) {
            task.outputLocation = this.outputLocation;
            task.setVariantName(this.variantName);
        }
    }
}

