/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.utils.ILogger;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.gradle.api.logging.Logger;

public class DataBindingMergeGenClassLogTransform
extends Transform {
    private final ILogger logger;
    private final File outFolder;

    public DataBindingMergeGenClassLogTransform(Logger logger, File outFolder) {
        this.logger = new LoggerWrapper(logger);
        this.outFolder = outFolder;
    }

    public String getName() {
        return "dataBindingMergeGenClasses";
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return Collections.singleton(this.outFolder);
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        Collection inputs = transformInvocation.getReferencedInputs();
        if (transformInvocation.isIncremental()) {
            this.incrementalUpdate(inputs);
        } else {
            this.fullCopy(inputs);
        }
    }

    private void incrementalUpdate(Collection<TransformInput> inputs) {
        inputs.forEach(input -> input.getDirectoryInputs().forEach(directoryInput -> directoryInput.getChangedFiles().forEach(this::processFileInput)));
    }

    private void processFileInput(File file, Status status) {
        if (DataBindingMergeGenClassLogTransform.isClassListFile(file.getName())) {
            switch (status) {
                case NOTCHANGED: {
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    try {
                        FileUtils.copyFile((File)file, (File)new File(this.outFolder, file.getName()));
                        break;
                    }
                    catch (IOException e) {
                        this.logger.error((Throwable)e, "Cannot copy data binding artifacts from dependency.", new Object[0]);
                        throw new UncheckedIOException(e);
                    }
                }
                case REMOVED: {
                    try {
                        File outFile = new File(this.outFolder, file.getName());
                        if (!outFile.exists()) break;
                        FileUtils.forceDelete((File)outFile);
                        break;
                    }
                    catch (IOException e) {
                        this.logger.error((Throwable)e, "error while trying to delete removed data binding artifact from dependency.", new Object[0]);
                        throw new UncheckedIOException(e);
                    }
                }
            }
        }
    }

    private void fullCopy(Collection<TransformInput> inputs) throws IOException {
        com.android.utils.FileUtils.cleanOutputDir((File)this.outFolder);
        for (TransformInput input : inputs) {
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                File dataBindingDir = dirInput.getFile();
                if (!dataBindingDir.exists()) continue;
                this.copyBindingClassNames(dataBindingDir);
            }
        }
    }

    private void copyBindingClassNames(File dataBindingDir) throws IOException {
        Collection files = FileUtils.listFiles((File)dataBindingDir, (IOFileFilter)new IOFileFilter(){

            public boolean accept(File file) {
                return DataBindingMergeGenClassLogTransform.isClassListFile(file.getName());
            }

            public boolean accept(File dir, String name) {
                return DataBindingMergeGenClassLogTransform.isClassListFile(name);
            }
        }, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File listFile : files) {
            FileUtils.copyFile((File)listFile, (File)new File(this.outFolder, listFile.getName()));
        }
    }

    private static boolean isClassListFile(String listFile) {
        return listFile.endsWith("-binding_classes.json");
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.DATA_BINDING_BASE_CLASS_LOG_ARTIFACT;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.SUB_PROJECTS, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.EXTERNAL_LIBRARIES});
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public boolean isIncremental() {
        return true;
    }
}

