/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.options.LongOption;
import com.android.build.gradle.options.ProjectOptions;
import java.time.Instant;

public final class NdkLease {
    public static final long DEPRECATED_NDK_COMPILE_LEASE_DAYS = 60L;
    public static final long DEPRECATED_NDK_COMPILE_LEASE_MILLIS = 5184000000L;

    private NdkLease() {
    }

    public static long getFreshDeprecatedNdkCompileLease() {
        return Instant.now().toEpochMilli();
    }

    public static boolean isDeprecatedNdkCompileLeaseExpired(ProjectOptions options) {
        Long leaseDate = options.get(LongOption.DEPRECATED_NDK_COMPILE_LEASE);
        if (leaseDate == null) {
            return true;
        }
        long freshLease = NdkLease.getFreshDeprecatedNdkCompileLease();
        if (freshLease - leaseDate > 5184000000L) {
            return true;
        }
        return leaseDate > freshLease;
    }
}

