/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.api.JavaCompileOptions;
import com.android.build.gradle.internal.core.MergedExternalNativeBuildOptions;
import com.android.build.gradle.internal.core.MergedJavaCompileOptions;
import com.android.build.gradle.internal.core.MergedNdkConfig;
import com.android.build.gradle.internal.core.VariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreExternalNativeBuildOptions;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.CoreSigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.options.DeploymentDevice;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.ManifestAttributeSupplier;
import com.android.builder.core.VariantType;
import com.android.builder.model.OptionalCompilationStep;
import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

public class GradleVariantConfiguration
extends VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> {
    private final ProjectOptions projectOptions;
    private final MergedNdkConfig mergedNdkConfig = new MergedNdkConfig();
    private final MergedExternalNativeBuildOptions mergedExternalNativeBuildOptions = new MergedExternalNativeBuildOptions();
    private final MergedJavaCompileOptions mergedJavaCompileOptions = new MergedJavaCompileOptions();

    GradleVariantConfiguration(ProjectOptions projectOptions, VariantConfiguration<CoreBuildType, CoreProductFlavor, CoreProductFlavor> testedConfig, CoreProductFlavor defaultConfig2, SourceProvider defaultSourceProvider, ManifestAttributeSupplier mainManifestAttributeSupplier, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, CoreSigningConfig signingConfigOverride) {
        super(defaultConfig2, defaultSourceProvider, mainManifestAttributeSupplier, buildType, buildTypeSourceProvider, type, testedConfig, signingConfigOverride);
        this.mergeOptions();
        this.projectOptions = projectOptions;
    }

    public GradleVariantConfiguration getMyTestConfig(SourceProvider defaultSourceProvider, ManifestAttributeSupplier mainManifestAttributeSupplier, SourceProvider buildTypeSourceProvider, VariantType type) {
        return new GradleVariantConfiguration(this.projectOptions, this, (CoreProductFlavor)this.getDefaultConfig(), defaultSourceProvider, mainManifestAttributeSupplier, (CoreBuildType)this.getBuildType(), buildTypeSourceProvider, type, this.getSigningConfig());
    }

    public AndroidVersion getMinSdkVersionWithTargetDeviceApi() {
        Integer targetApiLevel = this.projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API);
        if (targetApiLevel != null && this.isMultiDexEnabled() && ((CoreBuildType)this.getBuildType()).isDebuggable()) {
            int minVersion = this.getTargetSdkVersion().getApiLevel() > 1 ? Integer.min(this.getTargetSdkVersion().getApiLevel(), targetApiLevel) : targetApiLevel;
            return new AndroidVersion(minVersion);
        }
        return super.getMinSdkVersion();
    }

    public static Builder getBuilderForExtension(AndroidConfig extension) {
        if (extension instanceof TestAndroidConfig) {
            return new TestModuleConfigurationBuilder();
        }
        return new VariantConfigurationBuilder();
    }

    private void mergeOptions() {
        this.computeMergedOptions(this.mergedJavaCompileOptions, CoreProductFlavor::getJavaCompileOptions, CoreBuildType::getJavaCompileOptions, MergedJavaCompileOptions::reset, MergedJavaCompileOptions::append);
        this.computeMergedOptions(this.mergedNdkConfig, CoreProductFlavor::getNdkConfig, CoreBuildType::getNdkConfig, MergedNdkConfig::reset, MergedNdkConfig::append);
        this.computeMergedOptions(this.mergedExternalNativeBuildOptions, CoreProductFlavor::getExternalNativeBuildOptions, CoreBuildType::getExternalNativeBuildOptions, MergedExternalNativeBuildOptions::reset, MergedExternalNativeBuildOptions::append);
    }

    @Override
    public VariantConfiguration addProductFlavor(CoreProductFlavor productFlavor, SourceProvider sourceProvider, String dimensionName) {
        Preconditions.checkNotNull((Object)productFlavor);
        Preconditions.checkNotNull((Object)sourceProvider);
        Preconditions.checkNotNull((Object)dimensionName);
        super.addProductFlavor(productFlavor, sourceProvider, dimensionName);
        this.mergeOptions();
        return this;
    }

    public boolean isInstantRunBuild(GlobalScope globalScope) {
        return this.getIncrementalMode(globalScope) == IncrementalMode.FULL;
    }

    protected IncrementalMode getIncrementalMode(GlobalScope globalScope) {
        if (this.isInstantRunSupported() && GradleVariantConfiguration.targetDeviceSupportsInstantRun(this, globalScope.getProjectOptions()) && globalScope.isActive(OptionalCompilationStep.INSTANT_DEV)) {
            return IncrementalMode.FULL;
        }
        return IncrementalMode.NONE;
    }

    private static boolean targetDeviceSupportsInstantRun(GradleVariantConfiguration config, ProjectOptions projectOptions) {
        if (config.isLegacyMultiDexMode()) {
            return DeploymentDevice.getDeploymentDeviceAndroidVersion(projectOptions).getFeatureLevel() >= AndroidVersion.ART_RUNTIME.getFeatureLevel();
        }
        return true;
    }

    public CoreNdkOptions getNdkConfig() {
        return this.mergedNdkConfig;
    }

    public CoreExternalNativeBuildOptions getExternalNativeBuildOptions() {
        return this.mergedExternalNativeBuildOptions;
    }

    public Set<String> getSupportedAbis() {
        return this.mergedNdkConfig.getAbiFilters();
    }

    @Override
    public CoreSigningConfig getSigningConfig() {
        return (CoreSigningConfig)super.getSigningConfig();
    }

    private <CoreOptionT, MergedOptionT> void computeMergedOptions(MergedOptionT option, Function<CoreProductFlavor, CoreOptionT> productFlavorOptionGetter, Function<CoreBuildType, CoreOptionT> buildTypeOptionGetter, Consumer<MergedOptionT> reset, BiConsumer<MergedOptionT, CoreOptionT> append) {
        reset.accept(option);
        CoreOptionT defaultOption = productFlavorOptionGetter.apply((CoreProductFlavor)this.getDefaultConfig());
        if (defaultOption != null) {
            append.accept(option, defaultOption);
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            CoreOptionT flavorOption = productFlavorOptionGetter.apply((CoreProductFlavor)flavors.get(i));
            if (flavorOption == null) continue;
            append.accept(option, flavorOption);
        }
        CoreOptionT buildTypeOption = buildTypeOptionGetter.apply((CoreBuildType)this.getBuildType());
        if (buildTypeOption != null) {
            append.accept(option, buildTypeOption);
        }
    }

    public JavaCompileOptions getJavaCompileOptions() {
        return this.mergedJavaCompileOptions;
    }

    public boolean isInstantRunSupported() {
        return this.getInstantRunSupportStatus() == 0;
    }

    public int getInstantRunSupportStatus() {
        if (!((CoreBuildType)this.getBuildType()).isDebuggable()) {
            return 1;
        }
        if (this.getType().isForTesting()) {
            return 2;
        }
        return 0;
    }

    public List<String> getDefautGlslcArgs() {
        HashMap optionMap = Maps.newHashMap();
        for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getGlslcArgs()) {
            optionMap.put(GradleVariantConfiguration.getKey(option), option);
        }
        List flavors = this.getProductFlavors();
        for (int i = flavors.size() - 1; i >= 0; --i) {
            for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
        }
        for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getGlslcArgs()) {
            optionMap.put(GradleVariantConfiguration.getKey(option), option);
        }
        return Lists.newArrayList(optionMap.values());
    }

    public Map<String, List<String>> getScopedGlslcArgs() {
        HashMap scopedArgs = Maps.newHashMap();
        Set<String> keys = this.getScopedGlslcKeys();
        for (String key : keys) {
            HashMap optionMap = Maps.newHashMap();
            for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            for (String option : ((CoreProductFlavor)this.getDefaultConfig()).getShaders().getScopedGlslcArgs().get((Object)key)) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            List flavors = this.getProductFlavors();
            for (int i = flavors.size() - 1; i >= 0; --i) {
                for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getGlslcArgs()) {
                    optionMap.put(GradleVariantConfiguration.getKey(option), option);
                }
                for (String option : ((CoreProductFlavor)flavors.get(i)).getShaders().getScopedGlslcArgs().get((Object)key)) {
                    optionMap.put(GradleVariantConfiguration.getKey(option), option);
                }
            }
            for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getGlslcArgs()) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            for (String option : ((CoreBuildType)this.getBuildType()).getShaders().getScopedGlslcArgs().get((Object)key)) {
                optionMap.put(GradleVariantConfiguration.getKey(option), option);
            }
            scopedArgs.put(key, ImmutableList.copyOf(optionMap.values()));
        }
        return scopedArgs;
    }

    private Set<String> getScopedGlslcKeys() {
        HashSet keys = Sets.newHashSet();
        keys.addAll(((CoreProductFlavor)this.getDefaultConfig()).getShaders().getScopedGlslcArgs().keySet());
        for (CoreProductFlavor flavor : this.getProductFlavors()) {
            keys.addAll(flavor.getShaders().getScopedGlslcArgs().keySet());
        }
        keys.addAll(((CoreBuildType)this.getBuildType()).getShaders().getScopedGlslcArgs().keySet());
        return keys;
    }

    private static String getKey(String fullOption) {
        int pos = fullOption.lastIndexOf(61);
        if (pos == -1) {
            return fullOption;
        }
        return fullOption.substring(0, pos);
    }

    @Override
    public String getVersionName() {
        String override = this.projectOptions.get(StringOption.IDE_VERSION_NAME_OVERRIDE);
        if (override != null) {
            return override;
        }
        return super.getVersionName();
    }

    @Override
    public int getVersionCode() {
        Integer override = this.projectOptions.get(IntegerOption.IDE_VERSION_CODE_OVERRIDE);
        if (override != null) {
            return override;
        }
        return super.getVersionCode();
    }

    protected static enum IncrementalMode {
        NONE,
        FULL;

    }

    private static class TestModuleConfigurationBuilder
    implements Builder {
        private TestModuleConfigurationBuilder() {
        }

        @Override
        public GradleVariantConfiguration create(ProjectOptions projectOptions, CoreProductFlavor defaultConfig2, SourceProvider defaultSourceProvider, ManifestAttributeSupplier mainManifestAttributeSupplier, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, CoreSigningConfig signingConfigOverride) {
            return new GradleVariantConfiguration(projectOptions, null, defaultConfig2, defaultSourceProvider, mainManifestAttributeSupplier, buildType, buildTypeSourceProvider, type, signingConfigOverride){

                @Override
                public String getApplicationId() {
                    String applicationId = this.getMergedFlavor().getTestApplicationId();
                    if (Strings.isNullOrEmpty((String)applicationId)) {
                        applicationId = super.getApplicationId();
                    }
                    return applicationId;
                }

                @Override
                public String getOriginalApplicationId() {
                    return this.getApplicationId();
                }

                @Override
                public String getTestApplicationId() {
                    return this.getApplicationId();
                }

                @Override
                public GradleVariantConfiguration getMyTestConfig(SourceProvider defaultSourceProvider, ManifestAttributeSupplier mainManifestAttributeSupplier, SourceProvider buildTypeSourceProvider, VariantType type) {
                    throw new UnsupportedOperationException("Test modules have no test variants.");
                }

                @Override
                public boolean isInstantRunBuild(GlobalScope globalScope) {
                    return false;
                }
            };
        }
    }

    private static class VariantConfigurationBuilder
    implements Builder {
        private VariantConfigurationBuilder() {
        }

        @Override
        public GradleVariantConfiguration create(ProjectOptions projectOptions, CoreProductFlavor defaultConfig2, SourceProvider defaultSourceProvider, ManifestAttributeSupplier mainManifestAttributeSupplier, CoreBuildType buildType, SourceProvider buildTypeSourceProvider, VariantType type, CoreSigningConfig signingConfigOverride) {
            return new GradleVariantConfiguration(projectOptions, null, defaultConfig2, defaultSourceProvider, mainManifestAttributeSupplier, buildType, buildTypeSourceProvider, type, signingConfigOverride);
        }
    }

    public static interface Builder {
        public GradleVariantConfiguration create(ProjectOptions var1, CoreProductFlavor var2, SourceProvider var3, ManifestAttributeSupplier var4, CoreBuildType var5, SourceProvider var6, VariantType var7, CoreSigningConfig var8);
    }
}

