/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.errors;

import com.android.build.gradle.internal.errors.MessageReceiverImpl$WhenMappings;
import com.android.build.gradle.internal.errors.MessageReceiverImplKt;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.SyncOptions;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageJsonSerializer;
import com.android.ide.common.blame.MessageReceiver;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/errors/MessageReceiverImpl;", "Lcom/android/ide/common/blame/MessageReceiver;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "logger", "Lorg/gradle/api/logging/Logger;", "(Lcom/android/build/gradle/options/ProjectOptions;Lorg/gradle/api/logging/Logger;)V", "errorFormatMode", "Lcom/android/build/gradle/options/SyncOptions$ErrorFormatMode;", "kotlin.jvm.PlatformType", "mGson", "Lcom/google/gson/Gson;", "machineReadableMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "receiveMessage", "", "gradle-core"})
public final class MessageReceiverImpl
implements MessageReceiver {
    private final SyncOptions.ErrorFormatMode errorFormatMode;
    private final Gson mGson;
    private final Logger logger;

    public void receiveMessage(@NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Message.Kind kind = message.getKind();
        if (kind != null) {
            switch (MessageReceiverImpl$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    if (Intrinsics.areEqual((Object)((Object)this.errorFormatMode), (Object)((Object)SyncOptions.ErrorFormatMode.MACHINE_PARSABLE))) {
                        this.logger.error(this.machineReadableMessage(message));
                        break;
                    }
                    this.logger.error(MessageReceiverImplKt.access$humanReadableMessage(message));
                    break;
                }
                case 2: {
                    if (Intrinsics.areEqual((Object)((Object)this.errorFormatMode), (Object)((Object)SyncOptions.ErrorFormatMode.MACHINE_PARSABLE))) {
                        this.logger.warn(this.machineReadableMessage(message));
                        break;
                    }
                    this.logger.warn(MessageReceiverImplKt.access$humanReadableMessage(message));
                    break;
                }
                case 3: {
                    this.logger.info(MessageReceiverImplKt.access$humanReadableMessage(message));
                    break;
                }
                case 4: {
                    this.logger.trace(MessageReceiverImplKt.access$humanReadableMessage(message));
                    break;
                }
                case 5: {
                    this.logger.warn(MessageReceiverImplKt.access$humanReadableMessage(message));
                    break;
                }
                case 6: {
                    this.logger.warn(MessageReceiverImplKt.access$humanReadableMessage(message));
                }
            }
        }
    }

    private final String machineReadableMessage(Message message) {
        StringBuilder stringBuilder = new StringBuilder().append("AGPBI: ");
        Gson gson = this.mGson;
        if (gson == null) {
            Intrinsics.throwNpe();
        }
        return stringBuilder.append(gson.toJson((Object)message)).toString();
    }

    public MessageReceiverImpl(@NotNull ProjectOptions projectOptions, @NotNull Logger logger) {
        Gson gson;
        Intrinsics.checkParameterIsNotNull((Object)projectOptions, (String)"projectOptions");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.errorFormatMode = SyncOptions.getErrorFormatMode(projectOptions);
        if (Intrinsics.areEqual((Object)((Object)this.errorFormatMode), (Object)((Object)SyncOptions.ErrorFormatMode.MACHINE_PARSABLE))) {
            GsonBuilder gsonBuilder = new GsonBuilder();
            MessageJsonSerializer.registerTypeAdapters((GsonBuilder)gsonBuilder);
            gson = gsonBuilder.create();
        } else {
            gson = null;
        }
        this.mGson = gson;
    }
}

