/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.dsl.AndroidSourceSetFactory;
import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.internal.variant2.DeprecatedConfigurationAction;
import com.android.builder.errors.EvalIssueReporter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\b\b\u0002\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0005H\u0002J\u001a\u0010!\u001a\u00020\u00182\u0012\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130#J\u0018\u0010$\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000fH\u0002J \u0010&\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000fH\u0002J\u001a\u0010(\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000f2\b\b\u0002\u0010 \u001a\u00020\u0005H\u0007J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u000fR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lcom/android/build/gradle/internal/dependency/SourceSetManager;", "", "project", "Lorg/gradle/api/Project;", "publishPackage", "", "deprecationReporter", "Lcom/android/build/gradle/internal/errors/DeprecationReporter;", "issueReporter", "Lcom/android/builder/errors/EvalIssueReporter;", "(Lorg/gradle/api/Project;ZLcom/android/build/gradle/internal/errors/DeprecationReporter;Lcom/android/builder/errors/EvalIssueReporter;)V", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "configuredSourceSets", "", "", "logger", "Lorg/gradle/api/logging/Logger;", "sourceSetsContainer", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getSourceSetsContainer", "()Lorg/gradle/api/NamedDomainObjectContainer;", "checkForUnconfiguredSourceSets", "", "createConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "name", "description", "canBeResolved", "createConfigurationsForSourceSet", "sourceSet", "isForTesting", "executeAction", "action", "Lorg/gradle/api/Action;", "getConfigDesc", "sourceSetName", "getDeprecatedConfigDesc", "replacement", "setUpSourceSet", "setUpTestSourceSet", "gradle-core"})
public final class SourceSetManager {
    @NotNull
    private final NamedDomainObjectContainer<AndroidSourceSet> sourceSetsContainer;
    private final ConfigurationContainer configurations;
    private final Logger logger;
    private final Set<String> configuredSourceSets;
    private final boolean publishPackage;
    private final DeprecationReporter deprecationReporter;
    private final EvalIssueReporter issueReporter;

    @NotNull
    public final NamedDomainObjectContainer<AndroidSourceSet> getSourceSetsContainer() {
        return this.sourceSetsContainer;
    }

    @NotNull
    public final AndroidSourceSet setUpTestSourceSet(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.setUpSourceSet(name, true);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name, boolean isForTesting) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        AndroidSourceSet sourceSet = (AndroidSourceSet)this.sourceSetsContainer.maybeCreate(name);
        if (!this.configuredSourceSets.contains(name)) {
            AndroidSourceSet androidSourceSet = sourceSet;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
            this.createConfigurationsForSourceSet(androidSourceSet, isForTesting);
            this.configuredSourceSets.add(name);
        }
        AndroidSourceSet androidSourceSet = sourceSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
        return androidSourceSet;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ AndroidSourceSet setUpSourceSet$default(SourceSetManager sourceSetManager, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return sourceSetManager.setUpSourceSet(string, bl);
    }

    @JvmOverloads
    @NotNull
    public final AndroidSourceSet setUpSourceSet(@NotNull String name) {
        return SourceSetManager.setUpSourceSet$default(this, name, false, 2, null);
    }

    private final void createConfigurationsForSourceSet(AndroidSourceSet sourceSet, boolean isForTesting) {
        String apiName;
        String providedName;
        String apkName;
        String packageConfigDescription;
        String compileName;
        String implementationName = sourceSet.getImplementationConfigurationName();
        String runtimeOnlyName = sourceSet.getRuntimeOnlyConfigurationName();
        String compileOnlyName = sourceSet.getCompileOnlyConfigurationName();
        String string = compileName = sourceSet.getCompileConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compileName");
        String string2 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sourceSet.name");
        String string3 = implementationName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"implementationName");
        Configuration compile = this.createConfiguration(string, this.getDeprecatedConfigDesc("Compile", string2, string3), Intrinsics.areEqual((Object)"compile", (Object)compileName) || Intrinsics.areEqual((Object)"testCompile", (Object)compileName));
        compile.getAllDependencies().whenObjectAdded((Action)new DeprecatedConfigurationAction(implementationName, compileName, this.deprecationReporter, DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        if (this.publishPackage) {
            String string4 = sourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sourceSet.name");
            String string5 = runtimeOnlyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"runtimeOnlyName");
            packageConfigDescription = this.getDeprecatedConfigDesc("Publish", string4, string5);
        } else {
            String string6 = sourceSet.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sourceSet.name");
            String string7 = runtimeOnlyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"runtimeOnlyName");
            packageConfigDescription = this.getDeprecatedConfigDesc("Apk", string6, string7);
        }
        String string8 = apkName = sourceSet.getPackageConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"apkName");
        Configuration apk = SourceSetManager.createConfiguration$default(this, string8, packageConfigDescription, false, 4, null);
        apk.getAllDependencies().whenObjectAdded((Action)new DeprecatedConfigurationAction(runtimeOnlyName, apkName, this.deprecationReporter, DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String string9 = providedName = sourceSet.getProvidedConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"providedName");
        String string10 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"sourceSet.name");
        String string11 = compileOnlyName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string11, (String)"compileOnlyName");
        Configuration provided = SourceSetManager.createConfiguration$default(this, string9, this.getDeprecatedConfigDesc("Provided", string10, string11), false, 4, null);
        provided.getAllDependencies().whenObjectAdded((Action)new DeprecatedConfigurationAction(compileOnlyName, providedName, this.deprecationReporter, DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        String string12 = apiName = sourceSet.getApiConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"apiName");
        String string13 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"sourceSet.name");
        Configuration api = SourceSetManager.createConfiguration$default(this, string12, this.getConfigDesc("API", string13), false, 4, null);
        api.extendsFrom(new Configuration[]{compile});
        if (isForTesting) {
            api.getAllDependencies().whenObjectAdded((Action)new DeprecatedConfigurationAction(implementationName, apiName, this.deprecationReporter, DeprecationReporter.DeprecationTarget.CONFIG_NAME));
        }
        String string14 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"sourceSet.name");
        Configuration implementation = SourceSetManager.createConfiguration$default(this, implementationName, this.getConfigDesc("Implementation only", string14), false, 4, null);
        implementation.extendsFrom(new Configuration[]{api});
        String string15 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"sourceSet.name");
        Configuration runtimeOnly = SourceSetManager.createConfiguration$default(this, runtimeOnlyName, this.getConfigDesc("Runtime only", string15), false, 4, null);
        runtimeOnly.extendsFrom(new Configuration[]{apk});
        String string16 = sourceSet.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string16, (String)"sourceSet.name");
        Configuration compileOnly = SourceSetManager.createConfiguration$default(this, compileOnlyName, this.getConfigDesc("Compile only", string16), false, 4, null);
        compileOnly.extendsFrom(new Configuration[]{provided});
        String string17 = sourceSet.getWearAppConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string17, (String)"sourceSet.wearAppConfigurationName");
        Configuration wearConfig = SourceSetManager.createConfiguration$default(this, string17, "Link to a wear app to embed for object '" + sourceSet.getName() + "'.", false, 4, null);
        String string18 = sourceSet.getAnnotationProcessorConfigurationName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"sourceSet.annotationProcessorConfigurationName");
        SourceSetManager.createConfiguration$default(this, string18, "Classpath for the annotation processor for '" + sourceSet.getName() + "'.", false, 4, null);
    }

    private final Configuration createConfiguration(String name, String description, boolean canBeResolved) {
        Configuration configuration;
        this.logger.info("Creating configuration {}", (Object)name);
        Configuration configuration2 = configuration = (Configuration)this.configurations.maybeCreate(name);
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
        configuration2.setVisible(false);
        configuration.setDescription(description);
        configuration.setCanBeConsumed(false);
        configuration.setCanBeResolved(canBeResolved);
        return configuration;
    }

    static /* bridge */ /* synthetic */ Configuration createConfiguration$default(SourceSetManager sourceSetManager, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sourceSetManager.createConfiguration(string, string2, bl);
    }

    private final String getConfigDesc(String name, String sourceSetName) {
        return "" + name + " dependencies for '" + sourceSetName + "' sources.";
    }

    private final String getDeprecatedConfigDesc(String name, String sourceSetName, String replacement) {
        return "" + name + " dependencies for '" + sourceSetName + "' sources " + "(deprecated: use '" + replacement + "' instead).";
    }

    public final void checkForUnconfiguredSourceSets() {
        Iterable $receiver$iv = (Iterable)this.sourceSetsContainer;
        for (Object element$iv : $receiver$iv) {
            AndroidSourceSet sourceSet;
            AndroidSourceSet androidSourceSet = sourceSet = (AndroidSourceSet)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)androidSourceSet, (String)"sourceSet");
            if (this.configuredSourceSets.contains(androidSourceSet.getName())) continue;
            String message = "The SourceSet '" + sourceSet.getName() + "' is not recognized " + "by the Android Gradle Plugin. Perhaps you misspelled something?";
            this.issueReporter.reportError(EvalIssueReporter.Type.GENERIC, message);
        }
    }

    public final void executeAction(@NotNull Action<NamedDomainObjectContainer<AndroidSourceSet>> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        action2.execute(this.sourceSetsContainer);
    }

    public SourceSetManager(@NotNull Project project, boolean publishPackage, @NotNull DeprecationReporter deprecationReporter, @NotNull EvalIssueReporter issueReporter) {
        Set set;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)deprecationReporter, (String)"deprecationReporter");
        Intrinsics.checkParameterIsNotNull((Object)issueReporter, (String)"issueReporter");
        this.publishPackage = publishPackage;
        this.deprecationReporter = deprecationReporter;
        this.issueReporter = issueReporter;
        NamedDomainObjectContainer namedDomainObjectContainer = project.container(AndroidSourceSet.class, (NamedDomainObjectFactory)new AndroidSourceSetFactory(project.getObjects(), project, this.publishPackage));
        Intrinsics.checkExpressionValueIsNotNull((Object)namedDomainObjectContainer, (String)"project.container(\n     \u2026project, publishPackage))");
        this.sourceSetsContainer = namedDomainObjectContainer;
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.configurations");
        this.configurations = configurationContainer;
        Logger logger = Logging.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(this.javaClass)");
        this.logger = logger;
        SourceSetManager sourceSetManager = this;
        sourceSetManager.configuredSourceSets = set = (Set)new LinkedHashSet();
    }
}

