/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlNativeToolSpecification;
import com.android.build.gradle.internal.ndk.StlSpecification;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultStlNativeToolSpecification
implements StlNativeToolSpecification {
    private NdkInfo ndkInfo;
    private Stl stl;
    private StlSpecification stlLibSpec;

    public DefaultStlNativeToolSpecification(NdkInfo ndkInfo, StlSpecification stlLibSpec, Stl stl) {
        this.ndkInfo = ndkInfo;
        this.stl = stl;
        this.stlLibSpec = stlLibSpec;
    }

    @Override
    public Iterable<String> getCFlags() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<String> getCppFlags() {
        ArrayList cppFlags = Lists.newArrayList();
        if (this.stl.getName().equals("c++")) {
            cppFlags.add("-std=c++11");
        }
        for (File include : this.getIncludes()) {
            cppFlags.add("-I" + include);
        }
        return cppFlags;
    }

    @Override
    public Iterable<String> getLdFlags() {
        ArrayList flags = Lists.newArrayList();
        this.getSharedLibs().stream().forEach(lib -> DefaultStlNativeToolSpecification.addLib(flags, lib));
        this.getStaticLibs().stream().forEach(lib -> DefaultStlNativeToolSpecification.addLib(flags, lib));
        return flags;
    }

    private static void addLib(List<String> flags, File lib) {
        flags.add("-L" + lib.getParent());
        flags.add("-l" + lib.getName().substring(3, lib.getName().lastIndexOf(46)));
    }

    @Override
    public List<File> getIncludes() {
        return this.convertToFiles(this.stlLibSpec.getIncludes());
    }

    @Override
    public List<File> getStaticLibs() {
        return this.convertToFiles(this.stlLibSpec.getStaticLibs());
    }

    @Override
    public List<File> getSharedLibs() {
        return this.convertToFiles(this.stlLibSpec.getSharedLibs());
    }

    private List<File> convertToFiles(Collection<String> paths) {
        return paths.stream().map(path -> new File(this.ndkInfo.getRootDirectory(), (String)path)).collect(Collectors.toList());
    }
}

