/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.internal.scope.MissingTaskOutputException;
import com.android.build.gradle.internal.scope.TaskOutputAlreadyRegisteredException;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

public abstract class TaskOutputHolderImpl
implements TaskOutputHolder {
    private static final int OUTPUT_TYPE_SIZE = TaskOutputHolder.TaskOutputType.values().length + TaskOutputHolder.AnchorOutputType.values().length;
    private final Map<TaskOutputHolder.OutputType, FileCollection> outputMap = Maps.newHashMapWithExpectedSize((int)OUTPUT_TYPE_SIZE);

    protected abstract Project getProject();

    @Override
    public FileCollection getOutput(TaskOutputHolder.OutputType outputType) throws MissingTaskOutputException {
        FileCollection fileCollection = this.outputMap.get(outputType);
        if (fileCollection == null) {
            throw new MissingTaskOutputException(outputType);
        }
        return fileCollection;
    }

    @Override
    public boolean hasOutput(TaskOutputHolder.OutputType outputType) {
        return this.outputMap.containsKey(outputType);
    }

    @Override
    public ConfigurableFileCollection addTaskOutput(TaskOutputHolder.TaskOutputType outputType, Object file, String taskName) throws TaskOutputAlreadyRegisteredException {
        if (this.outputMap.containsKey(outputType)) {
            throw new TaskOutputAlreadyRegisteredException(outputType);
        }
        ConfigurableFileCollection collection = this.createCollection(file, taskName);
        this.outputMap.put(outputType, (FileCollection)collection);
        return collection;
    }

    @Override
    public ConfigurableFileCollection createAnchorOutput(TaskOutputHolder.AnchorOutputType outputType) throws TaskOutputAlreadyRegisteredException {
        if (this.outputMap.containsKey(outputType)) {
            throw new TaskOutputAlreadyRegisteredException(outputType);
        }
        ConfigurableFileCollection fileCollection = this.getProject().files(new Object[0]);
        this.outputMap.put(outputType, (FileCollection)fileCollection);
        return fileCollection;
    }

    @Override
    public void addToAnchorOutput(TaskOutputHolder.AnchorOutputType outputType, File file, String taskName) {
        this.addToAnchorOutput(outputType, (FileCollection)this.createCollection(file, taskName));
    }

    @Override
    public void addToAnchorOutput(TaskOutputHolder.AnchorOutputType outputType, FileCollection fileCollection) {
        FileCollection anchorCollection = this.outputMap.get(outputType);
        if (anchorCollection == null) {
            throw new IllegalStateException("No Anchor output created for type: " + outputType);
        }
        if (!(anchorCollection instanceof ConfigurableFileCollection)) {
            throw new IllegalStateException("Anchor File collection for type '" + outputType + "' is not a ConfigurableFileCollection.");
        }
        ((ConfigurableFileCollection)anchorCollection).from(new Object[]{fileCollection});
    }

    protected ConfigurableFileCollection createCollection(Object file, String taskName) {
        ConfigurableFileCollection collection = this.getProject().files(new Object[]{file});
        if (taskName != null) {
            collection.builtBy(new Object[]{taskName});
        }
        return collection;
    }
}

