/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.ShrinkerGraph;
import java.io.File;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassStructureVisitor<T>
extends ClassVisitor {
    private final File mClassFile;
    private final ShrinkerGraph<T> mGraph;
    private T mClass;

    public ClassStructureVisitor(ShrinkerGraph<T> graph, File classFile, ClassVisitor cv) {
        super(327680, cv);
        this.mClassFile = classFile;
        this.mGraph = graph;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.mClass = this.mGraph.addClass(name, superName, interfaces, access, this.mClassFile);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        final T method = this.mGraph.addMember(this.mClass, name, desc, access);
        MethodVisitor superVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitor(327680, superVisitor){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                ClassStructureVisitor.this.mGraph.addAnnotation(method, Type.getType((String)desc).getInternalName());
                return super.visitAnnotation(desc, visible);
            }
        };
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        final T field = this.mGraph.addMember(this.mClass, name, desc, access);
        FieldVisitor superVisitor = super.visitField(access, name, desc, signature, value);
        return new FieldVisitor(327680, superVisitor){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                ClassStructureVisitor.this.mGraph.addAnnotation(field, Type.getType((String)desc).getInternalName());
                return super.visitAnnotation(desc, visible);
            }
        };
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.mGraph.addAnnotation(this.mClass, Type.getType((String)desc).getInternalName());
        return super.visitAnnotation(desc, visible);
    }
}

