/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dependency;

import com.android.build.gradle.internal.dependency.FilteredArtifactCollection;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTaskKt;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0017H\u0096\u0002J\u0016\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u000f0\u000f0\u0019H\u0016R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/gradle/internal/dependency/FilteredArtifactCollection;", "Lorg/gradle/api/artifacts/ArtifactCollection;", "project", "Lorg/gradle/api/Project;", "mainArtifact", "excludeDirectoryFiles", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/Project;Lorg/gradle/api/artifacts/ArtifactCollection;Lorg/gradle/api/file/FileCollection;)V", "fileCollection", "filterResolver", "Lcom/android/build/gradle/internal/dependency/FilteredArtifactCollection$FilterResolver;", "forEach", "", "action", "Ljava/util/function/Consumer;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "getArtifactFiles", "getArtifacts", "", "getFailures", "", "", "iterator", "", "spliterator", "Ljava/util/Spliterator;", "kotlin.jvm.PlatformType", "FilterResolver", "gradle-core"})
public final class FilteredArtifactCollection
implements ArtifactCollection {
    private final FileCollection fileCollection;
    private final FilterResolver filterResolver;

    @NotNull
    public FileCollection getArtifactFiles() {
        return this.fileCollection;
    }

    @NotNull
    public Set<ResolvedArtifactResult> getArtifacts() {
        return this.filterResolver.getArtifactResults();
    }

    @NotNull
    public Collection<Throwable> getFailures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)this.filterResolver.getMainArtifacts().getFailures());
        ImmutableList immutableList = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
        return (Collection)immutableList;
    }

    @NotNull
    public Iterator<ResolvedArtifactResult> iterator() {
        Iterator<ResolvedArtifactResult> iterator = this.getArtifacts().iterator();
        if (iterator == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableIterator<org.gradle.api.artifacts.result.ResolvedArtifactResult>");
        }
        return TypeIntrinsics.asMutableIterator(iterator);
    }

    @NotNull
    public Spliterator<ResolvedArtifactResult> spliterator() {
        return this.getArtifacts().spliterator();
    }

    public void forEach(@NotNull Consumer<? super ResolvedArtifactResult> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        this.getArtifacts().forEach(action2);
    }

    public FilteredArtifactCollection(@NotNull Project project, @NotNull ArtifactCollection mainArtifact, @NotNull FileCollection excludeDirectoryFiles) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)mainArtifact, (String)"mainArtifact");
        Intrinsics.checkParameterIsNotNull((Object)excludeDirectoryFiles, (String)"excludeDirectoryFiles");
        this.filterResolver = new FilterResolver(mainArtifact, excludeDirectoryFiles);
        ConfigurableFileCollection configurableFileCollection = project.files(new Object[]{TaskInputHelper.bypassFileCallable(this.filterResolver)});
        Object[] objectArray = new Object[1];
        FileCollection fileCollection = mainArtifact.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"mainArtifact.artifactFiles");
        objectArray[0] = fileCollection.getBuildDependencies();
        ConfigurableFileCollection configurableFileCollection2 = configurableFileCollection.builtBy(objectArray).builtBy(new Object[]{excludeDirectoryFiles.getBuildDependencies()});
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection2, (String)"project.files(TaskInputH\u2026yFiles.buildDependencies)");
        this.fileCollection = (FileCollection)configurableFileCollection2;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0017J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/dependency/FilteredArtifactCollection$FilterResolver;", "Ljava/util/function/Supplier;", "", "Ljava/io/File;", "mainArtifacts", "Lorg/gradle/api/artifacts/ArtifactCollection;", "directoryArtifacts", "Lorg/gradle/api/file/FileCollection;", "(Lorg/gradle/api/artifacts/ArtifactCollection;Lorg/gradle/api/file/FileCollection;)V", "artifactResults", "", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "files", "getMainArtifacts", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "computeCollection", "", "computeFilteredArtifacts", "", "", "get", "getArtifactResults", "gradle-core"})
    private static final class FilterResolver
    implements Supplier<Collection<? extends File>> {
        private Set<ResolvedArtifactResult> artifactResults;
        private Collection<? extends File> files;
        @NotNull
        private final ArtifactCollection mainArtifacts;
        private final FileCollection directoryArtifacts;

        @NotNull
        public final Set<ResolvedArtifactResult> getArtifactResults() {
            this.computeCollection();
            Set<ResolvedArtifactResult> set = this.artifactResults;
            if (set == null) {
                Intrinsics.throwNpe();
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<File> get() throws Exception {
            this.computeCollection();
            Collection<File> collection = this.files;
            if (collection == null) {
                Intrinsics.throwNpe();
            }
            return collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void computeCollection() {
            FilterResolver filterResolver = this;
            synchronized (filterResolver) {
                if (this.artifactResults == null) {
                    Set<String> filteredArtifacts = this.computeFilteredArtifacts();
                    if (filteredArtifacts.isEmpty()) {
                        this.artifactResults = this.mainArtifacts.getArtifacts();
                        FileCollection fileCollection = this.mainArtifacts.getArtifactFiles();
                        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"mainArtifacts.artifactFiles");
                        this.files = fileCollection.getFiles();
                    } else {
                        LinkedHashSet results = Sets.newLinkedHashSet();
                        ImmutableList.Builder builder = ImmutableList.builder();
                        Iterator iterator = this.mainArtifacts.getArtifacts().iterator();
                        while (iterator.hasNext()) {
                            ResolvedArtifactResult artifactResult;
                            ResolvedArtifactResult resolvedArtifactResult = artifactResult = (ResolvedArtifactResult)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifactResult");
                            if (filteredArtifacts.contains(FeatureSplitTransitiveDepsWriterTaskKt.compIdToString(resolvedArtifactResult))) continue;
                            results.add(artifactResult);
                            builder.add((Object)artifactResult.getFile());
                        }
                        this.artifactResults = results;
                        this.files = (Collection)builder.build();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private final Set<String> computeFilteredArtifacts() {
            Set<String> set = this.directoryArtifacts.getFiles().stream().map(computeFilteredArtifacts.1.INSTANCE).flatMap(computeFilteredArtifacts.2.INSTANCE).collect(Collectors.toSet());
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"directoryArtifacts\n     \u2026llectors.toSet<String>())");
            return set;
        }

        @NotNull
        public final ArtifactCollection getMainArtifacts() {
            return this.mainArtifacts;
        }

        public FilterResolver(@NotNull ArtifactCollection mainArtifacts, @NotNull FileCollection directoryArtifacts) {
            Intrinsics.checkParameterIsNotNull((Object)mainArtifacts, (String)"mainArtifacts");
            Intrinsics.checkParameterIsNotNull((Object)directoryArtifacts, (String)"directoryArtifacts");
            this.mainArtifacts = mainArtifacts;
            this.directoryArtifacts = directoryArtifacts;
        }
    }
}

