/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.process;

import com.android.build.gradle.internal.process.GradleProcessResult;
import com.android.build.gradle.internal.process.OutputHandlerFailedGradleProcessResult;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.JavaProcessInfo;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaExecSpec;

public class GradleJavaProcessExecutor
implements JavaProcessExecutor {
    private final Project project;

    public GradleJavaProcessExecutor(Project project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult execute(JavaProcessInfo javaProcessInfo, ProcessOutputHandler processOutputHandler2) {
        ExecResult result;
        this.project.getLogger().info("Executing java process: ", (Object)javaProcessInfo.toString());
        ProcessOutput output = processOutputHandler2.createOutput();
        try {
            result = this.project.javaexec((Action)new ExecAction(javaProcessInfo, output));
        }
        finally {
            try {
                output.close();
            }
            catch (IOException e) {
                this.project.getLogger().warn("Exception while closing sub process streams", (Throwable)e);
            }
        }
        try {
            processOutputHandler2.handleOutput(output);
        }
        catch (ProcessException e) {
            return new OutputHandlerFailedGradleProcessResult(e);
        }
        return new GradleProcessResult(result, (ProcessInfo)javaProcessInfo);
    }

    private static class ExecAction
    implements Action<JavaExecSpec> {
        private final JavaProcessInfo javaProcessInfo;
        private final ProcessOutput processOutput;

        private ExecAction(JavaProcessInfo javaProcessInfo, ProcessOutput processOutput) {
            this.javaProcessInfo = javaProcessInfo;
            this.processOutput = processOutput;
        }

        public void execute(JavaExecSpec javaExecSpec) {
            javaExecSpec.classpath(new Object[]{new File(this.javaProcessInfo.getClasspath())});
            javaExecSpec.setMain(this.javaProcessInfo.getMainClass());
            javaExecSpec.args((Iterable)this.javaProcessInfo.getArgs());
            javaExecSpec.jvmArgs((Iterable)this.javaProcessInfo.getJvmArgs());
            javaExecSpec.environment(this.javaProcessInfo.getEnvironment());
            javaExecSpec.setStandardOutput(this.processOutput.getStandardOutput());
            javaExecSpec.setErrorOutput(this.processOutput.getErrorOutput());
            javaExecSpec.systemProperty("java.awt.headless", (Object)"true");
            javaExecSpec.setIgnoreExitValue(true);
        }
    }
}

