/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.shrinker.AbstractShrinker;
import com.android.build.gradle.shrinker.ClassLookupException;
import com.android.build.gradle.shrinker.ClassStructureVisitor;
import com.android.build.gradle.shrinker.DependencyFinderVisitor;
import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.KeepRules;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.android.build.gradle.shrinker.ShrinkerLogger;
import com.android.build.gradle.shrinker.TypeHierarchyTraverser;
import com.android.build.gradle.shrinker.parser.BytecodeVersion;
import com.android.build.gradle.shrinker.tracing.NoOpTracer;
import com.android.build.gradle.shrinker.tracing.RealTracer;
import com.android.build.gradle.shrinker.tracing.Trace;
import com.android.build.gradle.shrinker.tracing.Tracer;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.base.Stopwatch;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class FullRunShrinker<T>
extends AbstractShrinker<T> {
    static final String SHRINKER_FAKE_MARKER = "$shrinker_fake";
    private final Set<File> mPlatformJars;

    public FullRunShrinker(WaitableExecutor executor, ShrinkerGraph<T> graph, Set<File> platformJars, ShrinkerLogger shrinkerLogger, BytecodeVersion bytecodeVersion) {
        super(graph, executor, shrinkerLogger, bytecodeVersion);
        this.mPlatformJars = platformJars;
    }

    public Result run(Collection<TransformInput> inputs, Collection<TransformInput> referencedClasses, TransformOutputProvider output, ImmutableMap<AbstractShrinker.CounterSet, KeepRules> keepRules, KeepRules whyAreYouKeepingRules, boolean saveState) throws IOException {
        output.deleteAll();
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.buildGraph(inputs, referencedClasses);
        FullRunShrinker.logTime("Build graph", stopwatch);
        Tracer<T> tracer = this.setCounters(keepRules, whyAreYouKeepingRules);
        FullRunShrinker.logTime("Set counters", stopwatch);
        this.writeOutput(inputs, output);
        FullRunShrinker.logTime("Write output", stopwatch);
        if (saveState) {
            this.mGraph.saveState();
            FullRunShrinker.logTime("Saving state", stopwatch);
        }
        return new Result(this.mGraph, tracer.getRecordedTraces());
    }

    private void buildGraph(Iterable<TransformInput> programInputs, Iterable<TransformInput> libraryInputs) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        PostProcessingData postProcessingData = new PostProcessingData();
        this.readPlatformJars();
        for (TransformInput input : libraryInputs) {
            for (File directory : FullRunShrinker.getAllDirectories(input)) {
                for (File classFile : FullRunShrinker.getClassFiles(directory)) {
                    this.mExecutor.execute(() -> {
                        this.processLibraryClass(Files.toByteArray((File)classFile));
                        return null;
                    });
                }
            }
            for (File jarFile : FullRunShrinker.getAllJars(input)) {
                this.processJarFile(jarFile, this::processLibraryClass);
            }
        }
        for (TransformInput input : programInputs) {
            for (File directory : FullRunShrinker.getAllDirectories(input)) {
                for (File classFile : FullRunShrinker.getClassFiles(directory)) {
                    this.mExecutor.execute(() -> {
                        this.processProgramClassFile(Files.toByteArray((File)classFile), classFile, postProcessingData);
                        return null;
                    });
                }
            }
            for (File jarFile : FullRunShrinker.getAllJars(input)) {
                this.processJarFile(jarFile, bytes -> this.processProgramClassFile(bytes, jarFile, postProcessingData));
            }
        }
        this.waitForAllTasks();
        FullRunShrinker.logTime("Read input", stopwatch);
        this.handleOverrides(postProcessingData.getVirtualMethods());
        this.handleMultipleInheritance(postProcessingData.getMultipleInheritance());
        this.handleInterfaceInheritance((T)postProcessingData.getInterfaceInheritance());
        this.resolveReferences(postProcessingData.getUnresolvedReferences());
        this.waitForAllTasks();
        FullRunShrinker.logTime("Finish graph", stopwatch);
        this.mGraph.checkDependencies(this.mShrinkerLogger);
    }

    private void handleInterfaceInheritance(Set<T> interfaceInheritance) {
        for (T klass : interfaceInheritance) {
            this.mExecutor.execute(() -> {
                this.handleInterfaceInheritance(klass);
                return null;
            });
        }
    }

    private void handleInterfaceInheritance(T klass) {
        TypeHierarchyTraverser interfaceTraverser = TypeHierarchyTraverser.interfaces(this.mGraph, this.mShrinkerLogger);
        if ((this.mGraph.getModifiers(klass) & 0x200) != 0) {
            Iterable superinterfaces = interfaceTraverser.children(klass);
            for (Object superinterface : superinterfaces) {
                if (this.mGraph.isProgramClass(superinterface)) {
                    this.mGraph.addDependency(superinterface, klass, DependencyType.SUPERINTERFACE_KEPT);
                    continue;
                }
                this.mGraph.addRoots(ImmutableMap.of(klass, (Object)((Object)DependencyType.SUPERINTERFACE_KEPT)), AbstractShrinker.CounterSet.SHRINK);
            }
        }
        FluentIterable implementedInterfaces = interfaceTraverser.preOrderTraversal(klass).skip(1);
        for (Object iface : implementedInterfaces) {
            if (!this.mGraph.isProgramClass(iface)) continue;
            this.mGraph.addDependency(klass, iface, DependencyType.INTERFACE_IMPLEMENTED);
        }
    }

    private static FluentIterable<File> getClassFiles(File dir) {
        return FileUtils.getAllFiles((File)dir).filter(f -> Files.getFileExtension((String)f.getName()).equals("class"));
    }

    private void handleMultipleInheritance(Set<T> multipleInheritance) {
        for (final T klass : multipleInheritance) {
            this.mExecutor.execute((Callable)new Callable<Void>(){
                final Set<T> methods;
                {
                    this.methods = FullRunShrinker.this.mGraph.getMethods(klass);
                }

                @Override
                public Void call() throws Exception {
                    try {
                        Object superclass = FullRunShrinker.this.mGraph.getSuperclass(klass);
                        if (superclass == null || !FullRunShrinker.this.isProgramClass(superclass)) {
                            return null;
                        }
                        FluentIterable interfaces = TypeHierarchyTraverser.interfaces(FullRunShrinker.this.mGraph, FullRunShrinker.this.mShrinkerLogger).preOrderTraversal(klass).skip(1);
                        for (Object iface : interfaces) {
                            for (Object method : FullRunShrinker.this.mGraph.getMethods(iface)) {
                                this.handleMethod(method);
                            }
                        }
                        return null;
                    }
                    catch (ClassLookupException e) {
                        FullRunShrinker.this.mShrinkerLogger.invalidClassReference(FullRunShrinker.this.mGraph.getClassName(klass), e.getClassName());
                        return null;
                    }
                }

                private void handleMethod(T method) {
                    if (this.methods.contains(method)) {
                        return;
                    }
                    FluentIterable superclasses = TypeHierarchyTraverser.superclasses(FullRunShrinker.this.mGraph, FullRunShrinker.this.mShrinkerLogger).preOrderTraversal(klass).skip(1);
                    for (Object current : superclasses) {
                        if (!FullRunShrinker.this.isProgramClass(current)) {
                            return;
                        }
                        Object matchingMethod = FullRunShrinker.this.mGraph.findMatchingMethod(current, method);
                        if (matchingMethod == null) continue;
                        String name = FullRunShrinker.this.mGraph.getMemberName(method) + FullRunShrinker.SHRINKER_FAKE_MARKER;
                        String desc = FullRunShrinker.this.mGraph.getMemberDescriptor(method);
                        Object fakeMethod = FullRunShrinker.this.mGraph.addMember(klass, name, desc, FullRunShrinker.this.mGraph.getModifiers(method));
                        FullRunShrinker.this.mGraph.addDependency(fakeMethod, matchingMethod, DependencyType.REQUIRED_CLASS_STRUCTURE);
                        if (!FullRunShrinker.this.isProgramClass(FullRunShrinker.this.mGraph.getOwnerClass(method))) {
                            FullRunShrinker.this.mGraph.addDependency(klass, fakeMethod, DependencyType.REQUIRED_CLASS_STRUCTURE);
                        } else {
                            FullRunShrinker.this.mGraph.addDependency(klass, fakeMethod, DependencyType.CLASS_IS_KEPT);
                            FullRunShrinker.this.mGraph.addDependency(method, fakeMethod, DependencyType.IF_CLASS_KEPT);
                        }
                        return;
                    }
                }
            });
        }
    }

    private void handleOverrides(Set<T> virtualMethods) {
        for (T method : virtualMethods) {
            this.mExecutor.execute(() -> {
                if (FullRunShrinker.isJavaLangObjectMethod(this.mGraph.getMemberName(method), this.mGraph.getMemberDescriptor(method))) {
                    this.mGraph.addDependency(this.mGraph.getOwnerClass(method), method, DependencyType.REQUIRED_CLASS_STRUCTURE);
                    return null;
                }
                FluentIterable superTypes = TypeHierarchyTraverser.superclassesAndInterfaces(this.mGraph, this.mShrinkerLogger).preOrderTraversal(this.mGraph.getOwnerClass(method)).skip(1);
                for (Object klass : superTypes) {
                    Object superMethod;
                    if (this.mGraph.getClassName(klass).equals("java/lang/Object") || (superMethod = this.mGraph.findMatchingMethod(klass, method)) == null || superMethod.equals(method)) continue;
                    if (!this.isProgramClass(this.mGraph.getOwnerClass(superMethod))) {
                        this.mGraph.addDependency(this.mGraph.getOwnerClass(method), method, DependencyType.REQUIRED_CLASS_STRUCTURE);
                        return null;
                    }
                    this.mGraph.addDependency(this.mGraph.getOwnerClass(method), method, DependencyType.CLASS_IS_KEPT);
                    this.mGraph.addDependency(superMethod, method, DependencyType.IF_CLASS_KEPT);
                }
                return null;
            });
        }
    }

    private static boolean isJavaLangObjectMethod(String name, String descriptor) {
        return name.equals("hashCode") && descriptor.equals("()I") || name.equals("equals") && descriptor.equals("(Ljava/lang/Object;)Z") || name.equals("toString") && descriptor.equals("()Ljava/lang/String;");
    }

    private void processLibraryClass(byte[] source) {
        ClassReader classReader = new ClassReader(source);
        classReader.accept(new ClassStructureVisitor(this.mGraph, null, null), 7);
    }

    private void processProgramClassFile(byte[] bytes, File classFile, final PostProcessingData<T> postProcessingData) {
        ClassNode classNode = new ClassNode(327680);
        DependencyFinderVisitor depsFinder = new DependencyFinderVisitor<T>(this.mGraph, (ClassVisitor)classNode){

            @Override
            protected void handleDependency(T source, T target, DependencyType type) {
                FullRunShrinker.this.mGraph.addDependency(source, target, type);
            }

            @Override
            protected void handleMultipleInheritance(T klass) {
                postProcessingData.getMultipleInheritance().add(klass);
            }

            @Override
            protected void handleVirtualMethod(T method) {
                postProcessingData.getVirtualMethods().add(method);
            }

            @Override
            protected void handleInterfaceInheritance(T klass) {
                postProcessingData.getInterfaceInheritance().add(klass);
            }

            @Override
            protected void handleUnresolvedReference(PostProcessingData.UnresolvedReference<T> reference) {
                postProcessingData.getUnresolvedReferences().add(reference);
            }
        };
        ClassStructureVisitor structureVisitor = new ClassStructureVisitor(this.mGraph, classFile, depsFinder);
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept(structureVisitor, 6);
    }

    private void readPlatformJars() throws IOException {
        for (File platformJar : this.mPlatformJars) {
            this.processJarFile(platformJar, this::processLibraryClass);
        }
    }

    private void processJarFile(File platformJar, ByteCodeConsumer consumer) throws IOException {
        try (JarFile jarFile = new JarFile(platformJar);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                InputStream inputStream = jarFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
                    this.mExecutor.execute(() -> {
                        consumer.process(bytes);
                        return null;
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    private Tracer<T> setCounters(ImmutableMap<AbstractShrinker.CounterSet, KeepRules> allKeepRules, KeepRules whyAreYouKeepingRules) {
        AbstractShrinker.CounterSet counterSet = AbstractShrinker.CounterSet.SHRINK;
        KeepRules keepRules = (KeepRules)allKeepRules.get((Object)counterSet);
        Set whyAreYouKeeping = Sets.newConcurrentHashSet();
        for (Object klass : this.mGraph.getAllProgramClasses()) {
            this.mExecutor.execute(() -> {
                this.mGraph.addRoots(keepRules.getSymbolsToKeep(klass, this.mGraph), counterSet);
                if (whyAreYouKeepingRules != null) {
                    whyAreYouKeeping.addAll(whyAreYouKeepingRules.getSymbolsToKeep(klass, this.mGraph).keySet());
                }
                return null;
            });
        }
        this.waitForAllTasks();
        Tracer tracer = whyAreYouKeepingRules == null ? new NoOpTracer() : new RealTracer(whyAreYouKeeping);
        this.setCounters(counterSet, tracer);
        return tracer;
    }

    private void writeOutput(Collection<TransformInput> inputs, TransformOutputProvider output) throws IOException {
        this.updateClassFiles(this.mGraph.getReachableClasses(AbstractShrinker.CounterSet.SHRINK), Collections.emptyList(), inputs, output);
    }

    private static interface ByteCodeConsumer {
        public void process(byte[] var1);
    }

    public class Result {
        public final ShrinkerGraph<T> graph;
        public final Map<T, Trace<T>> traces;

        public Result(ShrinkerGraph<T> graph, Map<T, Trace<T>> traces) {
            this.graph = graph;
            this.traces = traces;
        }
    }
}

