/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.builder.core.AndroidBuilder;
import com.android.ide.common.process.BuildCommandException;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.FileBackedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class ExternalNativeBuildTaskUtils {
    public static final String CUSTOM_FORK_CMAKE_VERSION = "3.6.0-rc2";

    public static boolean fileIsUpToDate(File source, File derived) throws IOException {
        long derivedTimestamp;
        if (!source.exists()) {
            return false;
        }
        if (!derived.exists()) {
            return false;
        }
        long sourceTimestamp = Files.getLastModifiedTime(source.toPath(), new LinkOption[0]).toMillis();
        return sourceTimestamp <= (derivedTimestamp = Files.getLastModifiedTime(derived.toPath(), new LinkOption[0]).toMillis());
    }

    public static File getJsonMiniConfigFile(File originalJson) {
        return new File(originalJson.getParent(), "android_gradle_build_mini.json");
    }

    static File getOutputFolder(File jsonFolder, String abi) {
        return new File(jsonFolder, abi);
    }

    public static File getOutputJson(File jsonFolder, String abi) {
        return new File(ExternalNativeBuildTaskUtils.getOutputFolder(jsonFolder, abi), "android_gradle_build.json");
    }

    public static File getCompileCommandsJson(File jsonFolder, String abi) {
        return new File(ExternalNativeBuildTaskUtils.getOutputFolder(jsonFolder, abi), "compile_commands.json");
    }

    public static List<File> getOutputJsons(File jsonFolder, Collection<String> abis) {
        ArrayList outputs = Lists.newArrayList();
        for (String abi : abis) {
            outputs.add(ExternalNativeBuildTaskUtils.getOutputJson(jsonFolder, abi));
        }
        return outputs;
    }

    public static boolean shouldRegenerateOutOfDateJsons(ProjectOptions options) {
        return options.get(BooleanOption.IDE_BUILD_MODEL_ONLY) || options.get(BooleanOption.IDE_BUILD_MODEL_ONLY_ADVANCED) || options.get(BooleanOption.IDE_INVOKED_FROM_IDE) || options.get(BooleanOption.IDE_REFRESH_EXTERNAL_NATIVE_MODEL);
    }

    public static boolean isExternalNativeBuildEnabled(CoreExternalNativeBuild config) {
        return config.getNdkBuild().getPath() != null || config.getCmake().getPath() != null;
    }

    public static ExternalNativeBuildProjectPathResolution getProjectPath(CoreExternalNativeBuild config) {
        Map<NativeBuildSystem, File> externalProjectPaths = ExternalNativeBuildTaskUtils.getExternalBuildExplicitPaths(config);
        if (externalProjectPaths.size() > 1) {
            return new ExternalNativeBuildProjectPathResolution(null, null, null, "More than one externalNativeBuild path specified");
        }
        if (externalProjectPaths.isEmpty()) {
            return new ExternalNativeBuildProjectPathResolution(null, null, null, null);
        }
        NativeBuildSystem buildSystem = externalProjectPaths.keySet().iterator().next();
        return new ExternalNativeBuildProjectPathResolution(buildSystem, externalProjectPaths.get((Object)buildSystem), ExternalNativeBuildTaskUtils.getExternalNativeBuildPath(config).get((Object)buildSystem), null);
    }

    private static Map<NativeBuildSystem, File> getExternalBuildExplicitPaths(CoreExternalNativeBuild config) {
        EnumMap<NativeBuildSystem, File> map = new EnumMap<NativeBuildSystem, File>(NativeBuildSystem.class);
        File cmake = config.getCmake().getPath();
        File ndkBuild = config.getNdkBuild().getPath();
        if (cmake != null) {
            map.put(NativeBuildSystem.CMAKE, cmake);
        }
        if (ndkBuild != null) {
            map.put(NativeBuildSystem.NDK_BUILD, ndkBuild);
        }
        return map;
    }

    private static Map<NativeBuildSystem, File> getExternalNativeBuildPath(CoreExternalNativeBuild config) {
        EnumMap<NativeBuildSystem, File> map = new EnumMap<NativeBuildSystem, File>(NativeBuildSystem.class);
        File cmake = config.getCmake().getBuildStagingDirectory();
        File ndkBuild = config.getNdkBuild().getBuildStagingDirectory();
        if (cmake != null) {
            map.put(NativeBuildSystem.CMAKE, cmake);
        }
        if (ndkBuild != null) {
            map.put(NativeBuildSystem.NDK_BUILD, ndkBuild);
        }
        return map;
    }

    public static String executeBuildProcessAndLogError(AndroidBuilder androidBuilder, ProcessInfoBuilder process, boolean logStdioToInfo) throws BuildCommandException, IOException {
        ProgressiveLoggingProcessOutputHandler handler = new ProgressiveLoggingProcessOutputHandler(androidBuilder.getLogger(), logStdioToInfo);
        try {
            androidBuilder.getLogger().verbose(process.toString(), new Object[0]);
            androidBuilder.executeProcess(process.createProcess(), (ProcessOutputHandler)handler).rethrowFailure().assertNormalExitValue();
            return handler.getStandardOutputString();
        }
        catch (ProcessException e) {
            String combinedMessage = String.format("%s\n%s", e.getMessage(), handler.getCombinedOutputString());
            throw new BuildCommandException(combinedMessage);
        }
    }

    public static File findCmakeExecutableFolder(String cmakeVersion, SdkHandler sdkHandler) {
        return ExternalNativeBuildTaskUtils.doFindCmakeExecutableFolder(cmakeVersion, sdkHandler, ExternalNativeBuildTaskUtils.getEnvironmentPathList());
    }

    private static List<File> getEnvironmentPathList() {
        ArrayList<File> fileList = new ArrayList<File>();
        String envPath = System.getenv("PATH");
        ArrayList<String> pathList = new ArrayList<String>();
        if (envPath != null) {
            pathList.addAll(Arrays.asList(envPath.split(System.getProperty("path.separator"))));
        }
        for (String path : pathList) {
            fileList.add(new File(path));
        }
        return fileList;
    }

    static File doFindCmakeExecutableFolder(String cmakeVersion, SdkHandler sdkHandler, List<File> foldersToSearch) {
        if (sdkHandler.getCmakePathInLocalProp() != null) {
            return sdkHandler.getCmakePathInLocalProp();
        }
        if (cmakeVersion != null && !ExternalNativeBuildTaskUtils.isDefaultSdkCmakeVersion(cmakeVersion)) {
            File cmakeFolder = ExternalNativeBuildTaskUtils.getRequiredCmakeFromFolders(Revision.parseRevision((String)cmakeVersion), foldersToSearch);
            return new File(cmakeFolder.getParent());
        }
        return ExternalNativeBuildTaskUtils.getCmakeFolderFromSdkPackage(sdkHandler);
    }

    private static boolean isDefaultSdkCmakeVersion(String cmakeVersion) {
        return cmakeVersion.equals(CUSTOM_FORK_CMAKE_VERSION);
    }

    private static File getRequiredCmakeFromFolders(Revision cmakeVersion, List<File> foldersToSearch) {
        ArrayList<File> foldersWithErrors = new ArrayList<File>();
        for (File cmakeFolder : foldersToSearch) {
            File cmakeBin = SdkConstants.CURRENT_PLATFORM == 2 ? new File(cmakeFolder, "cmake.exe") : new File(cmakeFolder, "cmake");
            if (!cmakeBin.exists()) continue;
            try {
                Revision version = CmakeUtils.getVersion(cmakeFolder);
                if (!cmakeVersion.equals((Object)version)) continue;
                return cmakeFolder;
            }
            catch (IOException e) {
                foldersWithErrors.add(cmakeFolder);
            }
        }
        StringBuilder errorMsg = new StringBuilder(String.format("Unable to find CMake with version: %s within folder: %s\n.", cmakeVersion, foldersToSearch.toString()));
        if (!foldersWithErrors.isEmpty()) {
            errorMsg.append(String.format("Folders have inaccessible/corrupt CMake: %s", ((Object)foldersWithErrors).toString()));
        }
        errorMsg.append("Please make sure the folder with the CMake binary is added to the PATH environment variable.");
        throw new RuntimeException(errorMsg.toString());
    }

    private static File getCmakeFolderFromSdkPackage(SdkHandler sdkHandler) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)sdkHandler.getSdkFolder());
        LocalPackage cmakePackage = sdk.getLatestLocalPackageForPrefix("cmake", null, true, (ProgressIndicator)progress);
        if (cmakePackage != null) {
            return cmakePackage.getLocation();
        }
        sdkHandler.installCMake();
        cmakePackage = sdk.getLatestLocalPackageForPrefix("cmake", null, true, (ProgressIndicator)progress);
        if (cmakePackage != null) {
            return cmakePackage.getLocation();
        }
        return new File(sdkHandler.getSdkFolder(), "cmake");
    }

    private static class ProgressiveLoggingProcessOutputHandler
    implements ProcessOutputHandler {
        private final ILogger logger;
        private final FileBackedOutputStream standardOutput;
        private final FileBackedOutputStream combinedOutput;
        private final ProgressiveLoggingProcessOutput loggingProcessOutput;
        private final boolean logStdioToInfo;

        public ProgressiveLoggingProcessOutputHandler(ILogger logger, boolean logStdioToInfo) {
            this.logger = logger;
            this.logStdioToInfo = logStdioToInfo;
            this.standardOutput = new FileBackedOutputStream(2048);
            this.combinedOutput = new FileBackedOutputStream(2048);
            this.loggingProcessOutput = new ProgressiveLoggingProcessOutput();
        }

        String getStandardOutputString() throws IOException {
            return this.standardOutput.asByteSource().asCharSource(Charsets.UTF_8).read();
        }

        String getCombinedOutputString() throws IOException {
            return this.combinedOutput.asByteSource().asCharSource(Charsets.UTF_8).read();
        }

        public ProcessOutput createOutput() {
            return this.loggingProcessOutput;
        }

        public void handleOutput(ProcessOutput processOutput) throws ProcessException {
        }

        private class ProgressiveLoggingProcessOutput
        implements ProcessOutput {
            private final ProgressiveLoggingOutputStream outputStream;
            private final ProgressiveLoggingOutputStream errorStream;

            ProgressiveLoggingProcessOutput() {
                this.outputStream = new ProgressiveLoggingOutputStream(ProgressiveLoggingProcessOutputHandler.this.logStdioToInfo, ProgressiveLoggingProcessOutputHandler.this.standardOutput);
                this.errorStream = new ProgressiveLoggingOutputStream(true, null);
            }

            public ProgressiveLoggingOutputStream getStandardOutput() {
                return this.outputStream;
            }

            public ProgressiveLoggingOutputStream getErrorOutput() {
                return this.errorStream;
            }

            public void close() throws IOException {
            }

            private class ProgressiveLoggingOutputStream
            extends OutputStream {
                private static final int INITIAL_BUFFER_SIZE = 256;
                private final boolean logToInfo;
                private final FileBackedOutputStream individualOutput;
                byte[] buffer = new byte[256];
                int nextByteIndex = 0;

                ProgressiveLoggingOutputStream(boolean logToInfo, FileBackedOutputStream individualOutput) {
                    this.logToInfo = logToInfo;
                    this.individualOutput = individualOutput;
                }

                @Override
                public void write(int b) throws IOException {
                    ProgressiveLoggingProcessOutputHandler.this.combinedOutput.write(b);
                    if (this.individualOutput != null) {
                        this.individualOutput.write(b);
                    }
                    if (b == 10 || b == 13) {
                        this.printBuffer();
                    } else {
                        this.writeBuffer(b);
                    }
                }

                private void writeBuffer(int b) {
                    if (this.nextByteIndex == this.buffer.length) {
                        this.buffer = Arrays.copyOf(this.buffer, this.buffer.length * 2);
                    }
                    this.buffer[this.nextByteIndex] = (byte)b;
                    ++this.nextByteIndex;
                }

                private void printBuffer() throws UnsupportedEncodingException {
                    if (this.nextByteIndex == 0) {
                        return;
                    }
                    if (this.logToInfo) {
                        String line = new String(this.buffer, 0, this.nextByteIndex, "UTF-8");
                        ProgressiveLoggingProcessOutputHandler.this.logger.info(line, new Object[0]);
                    }
                    this.nextByteIndex = 0;
                }

                @Override
                public void close() throws IOException {
                    this.printBuffer();
                }
            }
        }
    }

    public static class ExternalNativeBuildProjectPathResolution {
        public final String errorText;
        public final NativeBuildSystem buildSystem;
        public final File makeFile;
        public final File externalNativeBuildDir;

        private ExternalNativeBuildProjectPathResolution(NativeBuildSystem buildSystem, File makeFile, File externalNativeBuildDir, String errorText) {
            Preconditions.checkArgument((makeFile == null || buildSystem != null ? 1 : 0) != 0, (Object)"Expected path and buildSystem together, no taskClass");
            Preconditions.checkArgument((makeFile != null || buildSystem == null ? 1 : 0) != 0, (Object)"Expected path and buildSystem together, no path");
            Preconditions.checkArgument((makeFile == null || errorText == null ? 1 : 0) != 0, (Object)"Expected path or error but both existed");
            this.buildSystem = buildSystem;
            this.makeFile = makeFile;
            this.externalNativeBuildDir = externalNativeBuildDir;
            this.errorText = errorText;
        }
    }
}

