/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.SdkConstants;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.external.cmake.CmakeUtils;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.cxx.json.AndroidBuildGradleJsons;
import com.android.build.gradle.internal.cxx.json.NativeBuildConfigValueMini;
import com.android.build.gradle.internal.cxx.json.NativeLibraryValueMini;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreExternalNativeCmakeOptions;
import com.android.build.gradle.internal.dsl.CoreExternalNativeNdkBuildOptions;
import com.android.build.gradle.internal.model.CoreExternalNativeBuild;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.profile.AnalyticsUtil;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.CmakeExternalNativeJsonGeneratorFactory;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.NativeBuildSystem;
import com.android.build.gradle.tasks.NdkBuildExternalNativeJsonGenerator;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.ApiVersion;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.repository.Revision;
import com.android.repository.api.ConsoleProgressIndicator;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.wireless.android.sdk.stats.GradleBuildVariant;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;

public abstract class ExternalNativeJsonGenerator {
    protected final String variantName;
    protected final AndroidBuilder androidBuilder;
    protected final GradleBuildVariant.Builder stats;
    private final NdkHandler ndkHandler;
    private final int minSdkVersion;
    private final Collection<Abi> abis;
    private final File makefile;
    private final File sdkFolder;
    private final File ndkFolder;
    private final File soFolder;
    private final File objFolder;
    private final File jsonFolder;
    private final boolean debuggable;
    private final List<String> buildArguments;
    private final List<String> cFlags;
    private final List<String> cppFlags;
    private final List<File> nativeBuildConfigurationsJsons;

    ExternalNativeJsonGenerator(NdkHandler ndkHandler, int minSdkVersion, String variantName, Collection<Abi> abis, AndroidBuilder androidBuilder, File sdkFolder, File ndkFolder, File soFolder, File objFolder, File jsonFolder, File makefile, boolean debuggable, List<String> buildArguments, List<String> cFlags, List<String> cppFlags, List<File> nativeBuildConfigurationsJsons, GradleBuildVariant.Builder stats) {
        this.ndkHandler = ndkHandler;
        this.minSdkVersion = minSdkVersion;
        this.variantName = variantName;
        this.abis = abis;
        this.androidBuilder = androidBuilder;
        this.sdkFolder = sdkFolder;
        this.ndkFolder = ndkFolder;
        this.soFolder = soFolder;
        this.objFolder = objFolder;
        this.jsonFolder = jsonFolder;
        this.makefile = makefile;
        this.debuggable = debuggable;
        this.buildArguments = buildArguments == null ? Lists.newArrayList() : buildArguments;
        this.cFlags = cFlags == null ? Lists.newArrayList() : cFlags;
        this.cppFlags = cppFlags == null ? Lists.newArrayList() : cppFlags;
        this.nativeBuildConfigurationsJsons = nativeBuildConfigurationsJsons;
        this.stats = stats;
    }

    protected static boolean isWindows() {
        return SdkConstants.CURRENT_PLATFORM == 2;
    }

    private boolean dependentBuildFileChanged(File json) throws IOException {
        if (!json.exists()) {
            return false;
        }
        NativeBuildConfigValueMini config = AndroidBuildGradleJsons.getNativeBuildMiniConfig(json, this.stats);
        if (config.buildFiles != null) {
            for (File buildFile : config.buildFiles) {
                if (ExternalNativeBuildTaskUtils.fileIsUpToDate(buildFile, json)) continue;
                this.diagnostic("noticing that build file '%s' is out of date with respect to %s", buildFile, json);
                return true;
            }
        }
        return false;
    }

    public void build() throws IOException, ProcessException {
        this.buildAndPropagateException(false);
    }

    public void build(boolean forceJsonGeneration) {
        try {
            this.diagnostic("building json with force flag %s", forceJsonGeneration);
            this.buildAndPropagateException(forceJsonGeneration);
        }
        catch (IOException | GradleException e) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, e.getMessage(), this.variantName);
        }
        catch (ProcessException e) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_PROCESS_EXCEPTION, String.format("executing external native build for %s %s", this.getNativeBuildSystem().getName(), this.makefile), e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildAndPropagateException(boolean forceJsonGeneration) throws IOException, ProcessException {
        this.diagnostic("starting JSON generation", new Object[0]);
        Throwable firstException = null;
        for (Abi abi : this.abis) {
            GradleBuildVariant.NativeBuildConfigInfo.Builder variantStats = GradleBuildVariant.NativeBuildConfigInfo.newBuilder();
            variantStats.setAbi(AnalyticsUtil.getAbi(abi.getName()));
            variantStats.setDebuggable(this.debuggable);
            long startTime = System.currentTimeMillis();
            variantStats.setGenerationStartMs(startTime);
            try {
                int abiPlatformVersion = this.ndkHandler.findSuitablePlatformVersion(abi.getName(), this.minSdkVersion);
                this.diagnostic("using platform version %s for ABI %s and min SDK version %s", new Object[]{abiPlatformVersion, abi, this.minSdkVersion});
                File expectedJson = ExternalNativeBuildTaskUtils.getOutputJson(this.getJsonFolder(), abi.getName());
                ProcessInfoBuilder processBuilder = this.getProcessBuilder(abi.getName(), abiPlatformVersion, expectedJson);
                String currentBuildCommand = processBuilder.toString();
                boolean rebuildDueToMissingPreviousCommand = false;
                File commandFile = new File(expectedJson.getParentFile(), String.format("%s_build_command.txt", this.getNativeBuildSystem().getName()));
                boolean rebuildDueToChangeInCommandFile = false;
                if (!commandFile.exists()) {
                    rebuildDueToMissingPreviousCommand = true;
                } else {
                    String previousBuildCommand = new String(Files.readAllBytes(commandFile.toPath()), Charsets.UTF_8);
                    if (!previousBuildCommand.equals(currentBuildCommand)) {
                        rebuildDueToChangeInCommandFile = true;
                    }
                }
                boolean generateDueToMissingJson = !expectedJson.exists();
                boolean dependentBuildFilesHaveChanged = this.dependentBuildFileChanged(expectedJson);
                if (forceJsonGeneration || generateDueToMissingJson || rebuildDueToMissingPreviousCommand || rebuildDueToChangeInCommandFile || dependentBuildFilesHaveChanged) {
                    this.diagnostic("rebuilding JSON %s due to:", expectedJson);
                    boolean isSoftRegenerate = true;
                    if (forceJsonGeneration) {
                        this.diagnostic("- force flag, will remove stale json folder", new Object[0]);
                        isSoftRegenerate = false;
                    }
                    if (generateDueToMissingJson) {
                        this.diagnostic("- expected json %s file is not present, will remove stale json folder", expectedJson);
                        isSoftRegenerate = false;
                    }
                    if (rebuildDueToMissingPreviousCommand) {
                        this.diagnostic("- missing previous command file %s, will remove stale json folder", commandFile);
                        isSoftRegenerate = false;
                    }
                    if (rebuildDueToChangeInCommandFile) {
                        this.diagnostic("- command changed from previous, will remove stale json folder", new Object[0]);
                        isSoftRegenerate = false;
                    }
                    if (dependentBuildFilesHaveChanged) {
                        this.diagnostic("- a dependent build file changed", new Object[0]);
                    }
                    if (this.jsonFolder.exists()) {
                        if (isSoftRegenerate) {
                            this.diagnostic("keeping json folder '%s' but regenerating project", expectedJson.getParentFile());
                        } else {
                            this.diagnostic("removing stale contents from '%s'", expectedJson.getParentFile());
                            FileUtils.deletePath((File)expectedJson.getParentFile());
                        }
                    }
                    if (expectedJson.getParentFile().mkdirs()) {
                        this.diagnostic("created folder '%s'", expectedJson.getParentFile());
                    }
                    this.diagnostic("executing %s %s", this.getNativeBuildSystem().getName(), processBuilder);
                    String buildOutput = this.executeProcess(abi.getName(), abiPlatformVersion, expectedJson);
                    this.diagnostic("done executing %s", this.getNativeBuildSystem().getName());
                    File outputTextFile = new File(expectedJson.getParentFile(), String.format("%s_build_output.txt", this.getNativeBuildSystem().getName()));
                    this.diagnostic("write build output %s", outputTextFile.getAbsolutePath());
                    Files.write(outputTextFile.toPath(), buildOutput.getBytes(Charsets.UTF_8), new OpenOption[0]);
                    this.processBuildOutput(buildOutput, abi.getName(), abiPlatformVersion);
                    if (!expectedJson.exists()) {
                        throw new GradleException(String.format("Expected json generation to create '%s' but it didn't", expectedJson));
                    }
                    this.removeUnexpectedSoFiles(abi, AndroidBuildGradleJsons.getNativeBuildMiniConfig(expectedJson, this.stats));
                    this.diagnostic("write command file %s", commandFile.getAbsolutePath());
                    Files.write(commandFile.toPath(), currentBuildCommand.getBytes(Charsets.UTF_8), new OpenOption[0]);
                    continue;
                }
                this.diagnostic("JSON '%s' was up-to-date", expectedJson);
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.SUCCESS_UP_TO_DATE);
            }
            catch (ProcessException | IOException | GradleException e) {
                variantStats.setOutcome(GradleBuildVariant.NativeBuildConfigInfo.GenerationOutcome.FAILED);
                if (firstException != null) continue;
                firstException = e;
            }
            finally {
                variantStats.setGenerationDurationMs(System.currentTimeMillis() - startTime);
                this.stats.addNativeBuildConfig(variantStats.build());
            }
        }
        if (firstException == null) {
            this.diagnostic("JSON generation completed without problems", new Object[0]);
            return;
        }
        this.diagnostic("JSON generation completed with problems", new Object[0]);
        if (firstException instanceof GradleException) {
            throw (GradleException)firstException;
        }
        if (firstException instanceof IOException) {
            throw (IOException)firstException;
        }
        throw (ProcessException)firstException;
    }

    private void removeUnexpectedSoFiles(Abi abi, NativeBuildConfigValueMini config) throws IOException {
        File expectedOutputFolder = FileUtils.join((File)this.objFolder, (String[])new String[]{abi.getName()});
        if (!expectedOutputFolder.isDirectory()) {
            return;
        }
        ArrayList expectedSoFiles = Lists.newArrayList();
        for (NativeLibraryValueMini library : config.libraries.values()) {
            expectedSoFiles.add(library.output.toPath());
        }
        Files.walk(expectedOutputFolder.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".so")).filter(path -> !expectedSoFiles.contains(path)).forEach(path -> {
            if (path.toFile().delete()) {
                this.diagnostic("deleted unexpected build output %s in incremental regenerate", path);
            }
        });
    }

    abstract void processBuildOutput(String var1, String var2, int var3) throws IOException;

    abstract ProcessInfoBuilder getProcessBuilder(String var1, int var2, File var3);

    abstract String executeProcess(String var1, int var2, File var3) throws ProcessException, IOException;

    public abstract NativeBuildSystem getNativeBuildSystem();

    abstract Map<Abi, File> getStlSharedObjectFiles();

    void diagnostic(String format, Object ... args) {
        this.androidBuilder.getLogger().info("External native generate JSON " + this.variantName + ": " + format, args);
    }

    void warn(String format, Object ... args) {
        this.androidBuilder.getLogger().warning(format, args);
    }

    List<String> getBaseConfigurationErrors() {
        ArrayList messages = Lists.newArrayList();
        if (!this.getNdkFolder().isDirectory()) {
            messages.add(String.format("NDK not configured (%s).\nDownload the NDK from http://developer.android.com/tools/sdk/ndk/.Then add ndk.dir=path/to/ndk in local.properties.\n(On Windows, make sure you escape backslashes, e.g. C:\\\\ndk rather than C:\\ndk)", this.getNdkFolder()));
        }
        return messages;
    }

    public Collection<JsonReader> streamExistingNativeBuildConfigurations() throws FileNotFoundException {
        List<File> files = this.getNativeBuildConfigurationsJsons();
        this.diagnostic("reading %s JSON files", files.size());
        ArrayList result = Lists.newArrayList();
        ArrayList existing = Lists.newArrayList();
        for (File file : files) {
            if (file.exists()) {
                this.diagnostic("reading JSON file %s", file.getAbsolutePath());
                existing.add(file);
                continue;
            }
            this.diagnostic("using fallback JSON for %s", file.getAbsolutePath());
            NativeBuildConfigValueMini fallback = new NativeBuildConfigValueMini();
            fallback.buildFiles = Lists.newArrayList((Object[])new File[]{this.makefile});
            String jsonText = new Gson().toJson((Object)fallback);
            result.add(new JsonReader((Reader)new StringReader(new Gson().toJson((Object)fallback))));
        }
        for (File json : existing) {
            JsonReader reader = new JsonReader((Reader)new FileReader(json));
            result.add(reader);
        }
        return result;
    }

    public String getVariantName() {
        return this.variantName;
    }

    private static List<Abi> filterToAvailableAbis(Collection<Abi> supportedAbis, Collection<String> userRequestedAbis, EvalIssueReporter issueReporter, String variantName) {
        ArrayList requestedButNotAvailable = Lists.newArrayList();
        ArrayList result = Lists.newArrayList();
        for (String abiName : userRequestedAbis) {
            Abi requestedAbi = Abi.getByName(abiName);
            if (requestedAbi == null || !supportedAbis.contains((Object)requestedAbi)) {
                requestedButNotAvailable.add(abiName);
            }
            if (requestedAbi == null) continue;
            result.add(requestedAbi);
        }
        if (!requestedButNotAvailable.isEmpty()) {
            Iterable supportedAbisNames = supportedAbis.stream().map(Abi::getName)::iterator;
            issueReporter.reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, String.format("ABIs [%s] are not supported for platform. Supported ABIs are [%s].", Joiner.on((String)", ").join((Iterable)requestedButNotAvailable), Joiner.on((String)", ").join(supportedAbisNames)), variantName);
        }
        return result;
    }

    private static Collection<String> getUserRequestedAbiFilters(NativeBuildSystem buildSystem, VariantScope variantScope) {
        Set<String> externalNativeAbiFilters = ExternalNativeJsonGenerator.emptySetToNull(ExternalNativeJsonGenerator.getExternalNativeBuildAbiFilters(buildSystem, variantScope.getVariantConfiguration()));
        Set<String> abiFilters = ExternalNativeJsonGenerator.filterAbis(externalNativeAbiFilters, ExternalNativeJsonGenerator.emptySetToNull(variantScope.getVariantConfiguration().getNdkConfig().getAbiFilters()));
        AndroidConfig extension = variantScope.getGlobalScope().getExtension();
        if (extension.getSplits().getAbi().isEnable()) {
            abiFilters = ExternalNativeJsonGenerator.filterAbis(abiFilters, extension.getSplits().getAbiFilters());
        }
        return abiFilters;
    }

    private static Set<String> emptySetToNull(Set<String> abiFilters) {
        if (abiFilters != null && abiFilters.isEmpty()) {
            return null;
        }
        return abiFilters;
    }

    private static Set<String> filterAbis(Set<String> abis, Set<String> filters) {
        if (filters == null) {
            return abis;
        }
        if (abis == null) {
            return filters;
        }
        return Sets.intersection(abis, filters);
    }

    private static Set<String> getExternalNativeBuildAbiFilters(NativeBuildSystem buildSystem, GradleVariantConfiguration variantConfig) {
        switch (buildSystem) {
            case NDK_BUILD: {
                CoreExternalNativeNdkBuildOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeNdkBuildOptions();
                if (options == null) break;
                return (Set)Preconditions.checkNotNull(options.getAbiFilters());
            }
            case CMAKE: {
                CoreExternalNativeCmakeOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeCmakeOptions();
                if (options == null) break;
                return (Set)Preconditions.checkNotNull(options.getAbiFilters());
            }
            default: {
                throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
            }
        }
        return Sets.newHashSet();
    }

    public static ExternalNativeJsonGenerator create(String projectPath, File projectDir, File buildDir, File externalNativeBuildDir, NativeBuildSystem buildSystem, File makefile, AndroidBuilder androidBuilder, SdkHandler sdkHandler, VariantScope scope) {
        Preconditions.checkNotNull((Object)sdkHandler.getSdkFolder(), (Object)"No Android SDK folder found");
        File ndkFolder = sdkHandler.getNdkFolder();
        if (ndkFolder == null || !ndkFolder.isDirectory()) {
            throw new InvalidUserDataException(String.format("NDK not configured. %s\nDownload it with SDK manager.", ndkFolder == null ? "" : ndkFolder));
        }
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        GradleBuildVariant.Builder stats = ProcessProfileWriter.getOrCreateVariant((String)projectPath, (String)scope.getFullVariantName());
        File intermediates = FileUtils.join((File)scope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{buildSystem.getName(), variantData.getVariantConfiguration().getDirName()});
        File soFolder = new File(intermediates, "lib");
        File externalNativeBuildFolder = ExternalNativeJsonGenerator.findExternalNativeBuildFolder(androidBuilder, projectDir, buildSystem, variantData, buildDir, externalNativeBuildDir);
        File objFolder = new File(intermediates, "obj");
        NdkHandler ndkHandler = scope.getGlobalScope().getNdkHandler();
        ApiVersion minSdkVersion = scope.getVariantData().getVariantConfiguration().getMergedFlavor().getMinSdkVersion();
        int minSdkVersionApiLevel = minSdkVersion == null ? 1 : minSdkVersion.getApiLevel();
        Collection userRequestedAbis = ExternalNativeJsonGenerator.getUserRequestedAbiFilters(buildSystem, scope);
        Collection<Abi> validAbis = userRequestedAbis == null ? ndkHandler.getDefaultAbis() : ExternalNativeJsonGenerator.filterToAvailableAbis(ndkHandler.getSupportedAbis(), userRequestedAbis, androidBuilder.getIssueReporter(), variantData.getName());
        ProjectOptions projectOptions = scope.getGlobalScope().getProjectOptions();
        if (projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI)) {
            ExternalNativeJsonGenerator.checkInjectedAbiIsValid(projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI), validAbis, scope.getGlobalScope().getErrorHandler());
        }
        List<File> expectedJsons = ExternalNativeBuildTaskUtils.getOutputJsons(externalNativeBuildFolder, userRequestedAbis == null ? (Collection)ndkHandler.getDefaultAbis().stream().map(Abi::getName).collect(Collectors.toList()) : userRequestedAbis);
        switch (buildSystem) {
            case NDK_BUILD: {
                CoreExternalNativeNdkBuildOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeNdkBuildOptions();
                Preconditions.checkNotNull((Object)options, (Object)"NdkBuild options not found");
                return new NdkBuildExternalNativeJsonGenerator(ndkHandler, minSdkVersionApiLevel, variantData.getName(), validAbis, androidBuilder, projectDir, sdkHandler.getSdkFolder(), sdkHandler.getNdkFolder(), soFolder, objFolder, externalNativeBuildFolder, makefile, ((CoreBuildType)variantConfig.getBuildType()).isDebuggable(), options.getArguments(), options.getcFlags(), options.getCppFlags(), expectedJsons, stats);
            }
            case CMAKE: {
                return ExternalNativeJsonGenerator.createCmakeExternalNativeJsonGenerator(variantData, ndkHandler, sdkHandler, minSdkVersionApiLevel, validAbis, androidBuilder, soFolder, objFolder, externalNativeBuildFolder, makefile, expectedJsons, stats);
            }
        }
        throw new IllegalArgumentException("Unknown ExternalNativeJsonGenerator type");
    }

    private static void checkInjectedAbiIsValid(String targetAbiString, Collection<Abi> validAbis, EvalIssueReporter issueReporter) {
        Abi buildTargetAbi;
        if (targetAbiString != null && (buildTargetAbi = Abi.getByName(targetAbiString)) != null && !validAbis.contains((Object)buildTargetAbi)) {
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, String.format("Cannot build for ABI: %1$s supported ABIs are: %2$s", buildTargetAbi.getName(), validAbis.isEmpty() ? "none" : validAbis.stream().map(Abi::getName).collect(Collectors.joining(", "))));
        }
    }

    private static ExternalNativeJsonGenerator createCmakeExternalNativeJsonGenerator(BaseVariantData variantData, NdkHandler ndkHandler, SdkHandler sdkHandler, int minSdkVersionApiLevel, Collection<Abi> validAbis, AndroidBuilder androidBuilder, File soFolder, File objFolder, File externalNativeBuildFolder, File makefile, List<File> expectedJsons, GradleBuildVariant.Builder stats) {
        GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
        AndroidConfig extension = variantData.getScope().getGlobalScope().getExtension();
        CoreExternalNativeBuild externalNativeBuild = extension.getExternalNativeBuild();
        File cmakeFolder = ExternalNativeBuildTaskUtils.findCmakeExecutableFolder(externalNativeBuild.getCmake().getVersion(), sdkHandler);
        CoreExternalNativeCmakeOptions options = variantConfig.getExternalNativeBuildOptions().getExternalNativeCmakeOptions();
        Preconditions.checkNotNull((Object)options, (Object)"CMake options not found");
        Revision cmakeVersion = null;
        try {
            cmakeVersion = CmakeUtils.getVersion(new File(cmakeFolder, "bin"));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get the CMake version located at: " + new File(cmakeFolder, "bin").getAbsolutePath());
        }
        return CmakeExternalNativeJsonGeneratorFactory.createCmakeStrategy(cmakeVersion, ndkHandler, minSdkVersionApiLevel, variantData.getName(), validAbis, androidBuilder, sdkHandler.getSdkFolder(), sdkHandler.getNdkFolder(), soFolder, objFolder, externalNativeBuildFolder, makefile, cmakeFolder, ((CoreBuildType)variantConfig.getBuildType()).isDebuggable(), options.getArguments(), options.getcFlags(), options.getCppFlags(), expectedJsons, stats);
    }

    private static File findExternalNativeBuildFolder(AndroidBuilder androidBuilder, File projectDir, NativeBuildSystem buildSystem, BaseVariantData variantData, File buildDir, File externalNativeBuildDir) {
        if (externalNativeBuildDir == null) {
            return FileUtils.join((File)projectDir, (String[])new String[]{".externalNativeBuild", buildSystem.getName(), variantData.getName()});
        }
        File externalNativeBuildPath = FileUtils.join((File)externalNativeBuildDir, (String[])new String[]{buildSystem.getName(), variantData.getName()});
        if (FileUtils.isFileInDirectory((File)externalNativeBuildPath, (File)buildDir)) {
            File invalidPath = externalNativeBuildPath;
            externalNativeBuildPath = FileUtils.join((File)projectDir, (String[])new String[]{".externalNativeBuild", buildSystem.getName(), variantData.getName()});
            androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.EXTERNAL_NATIVE_BUILD_CONFIGURATION, String.format(Locale.getDefault(), "The build staging directory you specified ('%s') is a subdirectory of your project's temporary build directory ('%s').Files in this directory do not persist through clean builds.\nEither use the default build staging directory ('%s'),or specify a path outside the temporary build directory.", invalidPath.getAbsolutePath(), buildDir.getAbsolutePath(), externalNativeBuildPath.getAbsolutePath()));
        }
        return externalNativeBuildPath;
    }

    protected static File getSdkCmakeExecutable(File sdkFolder) {
        if (ExternalNativeJsonGenerator.isWindows()) {
            return new File(ExternalNativeJsonGenerator.getSdkCmakeBinFolder(sdkFolder), "cmake.exe");
        }
        return new File(ExternalNativeJsonGenerator.getSdkCmakeBinFolder(sdkFolder), "cmake");
    }

    public void forEachNativeBuildConfiguration(Consumer<JsonReader> callback) throws IOException {
        List<File> files = this.getNativeBuildConfigurationsJsons();
        this.diagnostic("streaming %s JSON files", files.size());
        for (File file : this.getNativeBuildConfigurationsJsons()) {
            if (file.exists()) {
                this.diagnostic("string JSON file %s", file.getAbsolutePath());
                JsonReader reader = new JsonReader((Reader)new FileReader(file));
                Throwable throwable = null;
                try {
                    callback.accept(reader);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                    continue;
                }
            }
            this.diagnostic("streaming fallback JSON for %s", file.getAbsolutePath());
            NativeBuildConfigValueMini fallback = new NativeBuildConfigValueMini();
            fallback.buildFiles = Lists.newArrayList((Object[])new File[]{this.makefile});
            JsonReader reader = new JsonReader((Reader)new StringReader(new Gson().toJson((Object)fallback)));
            Throwable throwable = null;
            try {
                callback.accept(reader);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    @InputFile
    public File getMakefile() {
        return this.makefile;
    }

    @Input
    public File getObjFolder() {
        return this.objFolder;
    }

    public File getJsonFolder() {
        return this.jsonFolder;
    }

    @Input
    public File getNdkFolder() {
        return this.ndkFolder;
    }

    @Input
    public boolean isDebuggable() {
        return this.debuggable;
    }

    @Optional
    @Input
    public List<String> getBuildArguments() {
        return this.buildArguments;
    }

    @Optional
    @Input
    public List<String> getcFlags() {
        return this.cFlags;
    }

    @Optional
    @Input
    public List<String> getCppFlags() {
        return this.cppFlags;
    }

    @OutputFiles
    public List<File> getNativeBuildConfigurationsJsons() {
        return this.nativeBuildConfigurationsJsons;
    }

    @Input
    public File getSoFolder() {
        return this.soFolder;
    }

    @Input
    public File getSdkFolder() {
        return this.sdkFolder;
    }

    protected NdkHandler getNdkHandler() {
        return this.ndkHandler;
    }

    @Input
    Collection<Abi> getAbis() {
        return this.abis;
    }

    protected static File getSdkCmakeBinFolder(File sdkFolder) {
        return new File(ExternalNativeJsonGenerator.getCmakeFolderFromSdkFolder(sdkFolder), "bin");
    }

    protected static File getCmakeFolderFromSdkFolder(File sdkFolder) {
        ConsoleProgressIndicator progress = new ConsoleProgressIndicator();
        AndroidSdkHandler sdk = AndroidSdkHandler.getInstance((File)sdkFolder);
        LocalPackage cmakePackage = sdk.getLatestLocalPackageForPrefix("cmake", null, true, (ProgressIndicator)progress);
        if (cmakePackage != null) {
            return cmakePackage.getLocation();
        }
        return new File(sdkFolder, "cmake");
    }
}

