/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.options;

import com.android.build.gradle.internal.errors.DeprecationReporter;
import com.android.build.gradle.options.Option;

public enum BooleanOption implements Option<Boolean>
{
    ENABLE_AAPT2("android.enableAapt2", true, DeprecationReporter.DeprecationTarget.AAPT),
    ENABLE_BUILD_CACHE("android.enableBuildCache", true),
    ENABLE_PROFILE_JSON("android.enableProfileJson", false),
    ENABLE_SDK_DOWNLOAD("android.builder.sdkDownload", true),
    ENABLE_TEST_SHARDING("android.androidTest.shardBetweenDevices"),
    ENABLE_DEX_ARCHIVE("android.useDexArchive", true),
    ENABLE_INTERMEDIATE_ARTIFACTS_CACHE("android.enableIntermediateArtifactsCache", true),
    ENABLE_EXTRACT_ANNOTATIONS("android.enableExtractAnnotations", true),
    VERSION_CHECK_OVERRIDE_PROPERTY("android.overrideVersionCheck"),
    OVERRIDE_PATH_CHECK_PROPERTY("android.overridePathCheck"),
    ENABLE_DESUGAR("android.enableDesugar", true),
    ENABLE_INCREMENTAL_DESUGARING("android.enableIncrementalDesugaring", true),
    ENABLE_GRADLE_WORKERS("android.enableGradleWorkers", false),
    ENABLE_AAPT2_WORKER_ACTIONS("android.enableAapt2WorkerActions", false),
    ENABLE_CORE_LAMBDA_STUBS("android.enableCoreLambdaStubs", true),
    ENABLE_D8("android.enableD8", true, DeprecationReporter.DeprecationTarget.LEGACY_DEXER),
    ENABLE_D8_DESUGARING("android.enableD8.desugaring", false),
    ENABLE_D8_MAIN_DEX_LIST("android.enableD8MainDexList", true, DeprecationReporter.DeprecationTarget.LEGACY_DEXER),
    ENABLE_DEPRECATED_NDK("android.useDeprecatedNdk"),
    DISABLE_RESOURCE_VALIDATION("android.disableResourceValidation"),
    CONSUME_DEPENDENCIES_AS_SHARED_LIBRARIES("android.consumeDependenciesAsSharedLibraries"),
    BUILD_ONLY_TARGET_ABI("android.buildOnlyTargetAbi", true),
    KEEP_TIMESTAMPS_IN_APK("android.keepTimestampsInApk"),
    ENABLE_NEW_DSL_AND_API("android.enableNewDsl"),
    ENABLE_DATA_BINDING_V2("android.databinding.enableV2", false),
    IDE_INVOKED_FROM_IDE("android.injected.invoked.from.ide"),
    IDE_BUILD_MODEL_ONLY("android.injected.build.model.only"),
    IDE_BUILD_MODEL_ONLY_ADVANCED("android.injected.build.model.only.advanced"),
    IDE_BUILD_MODEL_FEATURE_FULL_DEPENDENCIES("android.injected.build.model.feature.full.dependencies"),
    IDE_REFRESH_EXTERNAL_NATIVE_MODEL("android.injected.refresh.external.native.model"),
    IDE_GENERATE_SOURCES_ONLY("android.injected.generateSourcesOnly"),
    ENABLE_SEPARATE_APK_RESOURCES("android.enableSeparateApkRes", true),
    ENABLE_EXPERIMENTAL_FEATURE_DATABINDING("android.enableExperimentalFeatureDatabinding", false),
    ENABLE_SEPARATE_R_CLASS_COMPILATION("android.enableSeparateRClassCompilation");

    private final String propertyName;
    private final boolean defaultValue;
    private final DeprecationReporter.DeprecationTarget deprecationTarget;

    private BooleanOption(String propertyName) {
        this(propertyName, false);
    }

    private BooleanOption(String propertyName, boolean defaultValue) {
        this(propertyName, defaultValue, null);
    }

    private BooleanOption(String propertyName, boolean defaultValue, DeprecationReporter.DeprecationTarget deprecationTarget) {
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.deprecationTarget = deprecationTarget;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Boolean parse(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof CharSequence) {
            return Boolean.parseBoolean(value.toString());
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        throw new IllegalArgumentException("Cannot parse project property " + this.getPropertyName() + "='" + value + "' of type '" + value.getClass() + "' as boolean.");
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecationTarget != null;
    }

    @Override
    public DeprecationReporter.DeprecationTarget getDeprecationTarget() {
        return this.deprecationTarget;
    }
}

