/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api.artifact;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactImpl;
import com.android.build.gradle.internal.api.dsl.DslScope;
import com.android.builder.errors.EvalIssueReporter;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u0017H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/api/artifact/BuildableArtifactImpl;", "Lcom/android/build/api/artifact/BuildableArtifact;", "fileCollection", "Lorg/gradle/api/file/FileCollection;", "dslScope", "Lcom/android/build/gradle/internal/api/dsl/DslScope;", "(Lorg/gradle/api/file/FileCollection;Lcom/android/build/gradle/internal/api/dsl/DslScope;)V", "getFileCollection$gradle_core", "()Lorg/gradle/api/file/FileCollection;", "setFileCollection$gradle_core", "(Lorg/gradle/api/file/FileCollection;)V", "files", "", "Ljava/io/File;", "getFiles", "()Ljava/util/Set;", "checkResolvable", "", "getBuildDependencies", "Lorg/gradle/api/tasks/TaskDependency;", "isEmpty", "", "iterator", "", "Companion", "gradle-core"})
public final class BuildableArtifactImpl
implements BuildableArtifact {
    @Nullable
    private FileCollection fileCollection;
    private final DslScope dslScope;
    private static final AtomicBoolean resolvable;
    public static final Companion Companion;

    private final void checkResolvable() {
        if (!Companion.isResolvable()) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Resolving this BuildableArtifact can only done during task execution.");
        }
        if (this.fileCollection == null) {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "BuildableArtifact has not been initialized.");
        }
    }

    @NotNull
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    @NotNull
    public Set<File> getFiles() {
        this.checkResolvable();
        FileCollection fileCollection = this.fileCollection;
        if (fileCollection == null) {
            Intrinsics.throwNpe();
        }
        Set<File> set = Collections.unmodifiableSet(fileCollection.getFiles());
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.unmodifiable\u2026t(fileCollection!!.files)");
        return set;
    }

    public boolean isEmpty() {
        this.checkResolvable();
        FileCollection fileCollection = this.fileCollection;
        if (fileCollection == null) {
            Intrinsics.throwNpe();
        }
        return fileCollection.isEmpty();
    }

    @NotNull
    public TaskDependency getBuildDependencies() {
        TaskDependency taskDependency;
        if (this.fileCollection != null) {
            FileCollection fileCollection = this.fileCollection;
            if (fileCollection == null) {
                Intrinsics.throwNpe();
            }
            TaskDependency taskDependency2 = fileCollection.getBuildDependencies();
            taskDependency = taskDependency2;
            Intrinsics.checkExpressionValueIsNotNull((Object)taskDependency2, (String)"fileCollection!!.buildDependencies");
        } else {
            this.dslScope.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Cannot get build dependencies before BuildableArtifact is initialized.");
            taskDependency = getBuildDependencies.1.INSTANCE;
        }
        return taskDependency;
    }

    @Nullable
    public final FileCollection getFileCollection$gradle_core() {
        return this.fileCollection;
    }

    public final void setFileCollection$gradle_core(@Nullable FileCollection fileCollection) {
        this.fileCollection = fileCollection;
    }

    public BuildableArtifactImpl(@Nullable FileCollection fileCollection, @NotNull DslScope dslScope) {
        Intrinsics.checkParameterIsNotNull((Object)dslScope, (String)"dslScope");
        this.fileCollection = fileCollection;
        this.dslScope = dslScope;
    }

    static {
        Companion = new Companion(null);
        resolvable = new AtomicBoolean(false);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/api/artifact/BuildableArtifactImpl$Companion;", "", "()V", "resolvable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getResolvable", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "disableResolution", "", "enableResolution", "isResolvable", "", "gradle-core"})
    public static final class Companion {
        private final AtomicBoolean getResolvable() {
            return resolvable;
        }

        public final boolean isResolvable() {
            return this.getResolvable().get();
        }

        public final void enableResolution() {
            this.getResolvable().set(true);
        }

        public final void disableResolution() {
            this.getResolvable().set(false);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

