/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.feature.BundleFeatureClasses;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.res.LinkApplicationAndroidResourcesTask;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.ApplicationId;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclaration;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIds;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitPackageIdsWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.FeatureVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class FeatureTaskManager
extends TaskManager {
    public FeatureTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)variantScope.getGlobalScope().getExtension().getCompileSdkVersion());
        if (androidVersion == null || androidVersion.getApiLevel() < 26) {
            String message = "Feature modules require compileSdkVersion set to 26 or higher.";
            if (androidVersion != null) {
                message = message + " compileSdkVersion is set to " + androidVersion.getApiString();
            }
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, message);
        }
        if (AaptGeneration.fromProjectOptions(this.projectOptions) == AaptGeneration.AAPT_V1 && !this.extension.getBaseFeature().booleanValue()) {
            this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Non-base feature modules require AAPTv2 to build.");
        }
        BaseVariantData variantData = variantScope.getVariantData();
        assert (variantData instanceof FeatureVariantData);
        if (this.extension.getDataBinding().isEnabled() && !this.extension.getBaseFeature().booleanValue()) {
            if (this.projectOptions.get(BooleanOption.ENABLE_EXPERIMENTAL_FEATURE_DATABINDING)) {
                this.androidBuilder.getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, "Data binding support for non-base features is experimental and is not supported.");
            } else {
                this.androidBuilder.getIssueReporter().reportError(EvalIssueReporter.Type.GENERIC, "Currently, data binding does not work for non-base features. Move data binding code to the base feature module.\nSee https://issuetracker.google.com/63814741.\nTo enable data binding with non-base features, set the android.enableExperimentalFeatureDatabinding property to true.");
            }
        }
        this.createAnchorTasks(variantScope);
        this.createCheckManifestTask(variantScope);
        this.createDependencyStreams(variantScope);
        this.taskFactory.create(new MainApkListPersistence.ConfigAction(variantScope));
        if (variantScope.isBaseFeature()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_BASE_TASKS, this.project.getPath(), variantScope.getFullVariantName(), () -> {
                this.createFeatureApplicationIdWriterTask(variantScope);
                this.createFeatureIdsWriterTask(variantScope);
            });
        } else {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_NON_BASE_TASKS, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createFeatureDeclarationTasks(variantScope));
        }
        this.createFeatureTransitiveDepsTask(variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeApkManifestsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createGenerateResValuesTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createRenderscriptTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeResourcesTask(variantScope, true));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_SHADER_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createShaderTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAssetsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createBuildConfigTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_PROCESS_RES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createProcessResTask(variantScope, FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"symbols", variantScope.getVariantData().getVariantConfiguration().getDirName()}), variantScope.getProcessResourcePackageOutputDirectory(), InternalArtifactType.FEATURE_RESOURCE_PKG, TaskManager.MergeType.MERGE, variantScope.getGlobalScope().getProjectBaseName());
            this.createProcessJavaResTask(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_AIDL_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAidlTask(variantScope));
        if (!this.isComponentModelPlugin()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_NDK_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createNdkTasks(variantScope));
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeJniLibFoldersTasks(variantScope));
        this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.MERGE);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_COMPILE_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createCompileTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_STRIP_NATIVE_LIBRARY_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> FeatureTaskManager.createStripNativeLibraryTask(this.taskFactory, variantScope));
        if (variantScope.getVariantData().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS)) {
            if (this.extension.getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_SPLIT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createSplitTasks(variantScope));
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.FEATURE_TASK_MANAGER_CREATE_PACKAGING_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createPackagingTask(variantScope, null));
    }

    private void createFeatureDeclarationTasks(VariantScope variantScope) {
        File featureSplitDeclarationOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "declaration", variantScope.getVariantConfiguration().getDirName()});
        FeatureSplitDeclarationWriterTask featureSplitWriterTaskAndroidTask = this.taskFactory.create(new FeatureSplitDeclarationWriterTask.ConfigAction(variantScope, featureSplitDeclarationOutputDirectory));
        variantScope.addTaskOutput(InternalArtifactType.METADATA_FEATURE_DECLARATION, FeatureSplitDeclaration.getOutputFile(featureSplitDeclarationOutputDirectory), featureSplitWriterTaskAndroidTask.getName());
    }

    private void createFeatureApplicationIdWriterTask(VariantScope variantScope) {
        File applicationIdOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "applicationId", variantScope.getVariantConfiguration().getDirName()});
        ApplicationIdWriterTask writeTask = this.taskFactory.create(new ApplicationIdWriterTask.BaseFeatureConfigAction(variantScope, applicationIdOutputDirectory));
        variantScope.addTaskOutput(InternalArtifactType.FEATURE_APPLICATION_ID_DECLARATION, ApplicationId.getOutputFile(applicationIdOutputDirectory), writeTask.getName());
    }

    private void createFeatureIdsWriterTask(VariantScope variantScope) {
        File featureIdsOutputDirectory = FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "ids", variantScope.getVariantConfiguration().getDirName()});
        FeatureSplitPackageIdsWriterTask writeTask = this.taskFactory.create(new FeatureSplitPackageIdsWriterTask.ConfigAction(variantScope, featureIdsOutputDirectory));
        variantScope.addTaskOutput(InternalArtifactType.FEATURE_IDS_DECLARATION, FeatureSplitPackageIds.getOutputFile(featureIdsOutputDirectory), writeTask.getName());
    }

    private void createFeatureTransitiveDepsTask(VariantScope scope) {
        File textFile = new File(FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "transitive-deps", scope.getVariantConfiguration().getDirName()}), "deps.txt");
        FeatureSplitTransitiveDepsWriterTask task = this.taskFactory.create(new FeatureSplitTransitiveDepsWriterTask.ConfigAction(scope, textFile));
        scope.addTaskOutput(InternalArtifactType.FEATURE_TRANSITIVE_DEPS, textFile, task.getName());
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        File classesJar = new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"intermediates", "classes-jar", scope.getVariantConfiguration().getDirName(), "classes.jar"}));
        BundleFeatureClasses task = this.taskFactory.create(new BundleFeatureClasses.ConfigAction(scope, classesJar));
        scope.addTaskOutput(InternalArtifactType.FEATURE_CLASSES, classesJar, task.getName());
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    @Override
    protected TaskConfigAction<LinkApplicationAndroidResourcesTask> createProcessAndroidResourcesConfigAction(VariantScope scope, Supplier<File> symbolLocation, File symbolsWithPackageName, File resPackageOutputFolder, boolean useAaptToGenerateLegacyMultidexMainDexProguardRules, TaskManager.MergeType sourceArtifactType, String baseName) {
        if (scope.isBaseFeature()) {
            return super.createProcessAndroidResourcesConfigAction(scope, symbolLocation, symbolsWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceArtifactType, baseName);
        }
        return new LinkApplicationAndroidResourcesTask.FeatureSplitConfigAction(scope, symbolLocation, symbolsWithPackageName, resPackageOutputFolder, useAaptToGenerateLegacyMultidexMainDexProguardRules, sourceArtifactType, baseName);
    }
}

