/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.FeatureTaskManager;
import com.android.build.gradle.internal.LibraryTaskManager;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.options.ProjectOptions;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class MultiTypeTaskManager
extends TaskManager {
    Map<VariantType, TaskManager> delegates;

    public MultiTypeTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
        this.delegates = ImmutableMap.of((Object)VariantType.FEATURE, (Object)new FeatureTaskManager(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder), (Object)VariantType.LIBRARY, (Object)new LibraryTaskManager(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder));
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        this.delegates.get(variantScope.getVariantData().getType()).createTasksForVariantScope(variantScope);
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        VariantType variantType = variantScope.getVariantData().getType();
        if (variantType.isForTesting()) {
            variantType = variantScope.getTestedVariantData().getType();
        }
        return this.delegates.get(variantType).getResMergingScopes(variantScope);
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
        ConfigurableFileCollection fileCollection = scope.createAnchorOutput(TaskOutputHolder.AnchorOutputType.ALL_CLASSES);
        fileCollection.from(new Object[]{scope.getBuildArtifactsHolder().getArtifactFiles(InternalArtifactType.JAVAC)});
        fileCollection.from(new Object[]{scope.getVariantData().getAllPreJavacGeneratedBytecode()});
        fileCollection.from(new Object[]{scope.getVariantData().getAllPostJavacGeneratedBytecode()});
    }
}

