/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.ProguardFiles;
import com.android.build.gradle.internal.InstantRunTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.PostprocessingFeatures;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.AndroidTestResourceArtifactCollection;
import com.android.build.gradle.internal.dependency.ArtifactCollectionWithExtraArtifact;
import com.android.build.gradle.internal.dependency.FilteredArtifactCollection;
import com.android.build.gradle.internal.dependency.SubtractingArtifactCollection;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.PostprocessingOptions;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.publishing.PublishingSpecs;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GenericVariantScopeImpl;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.MissingTaskOutputException;
import com.android.build.gradle.internal.scope.OutputScope;
import com.android.build.gradle.internal.scope.TaskOutputAlreadyRegisteredException;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportBuildInfoTask;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.DeploymentDevice;
import com.android.build.gradle.options.IntegerOption;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.BootClasspathBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.dexing.DexMergerTool;
import com.android.builder.dexing.DexerTool;
import com.android.builder.dexing.DexingType;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.model.BaseConfig;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.SelfResolvingDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.compile.JavaCompile;

public class VariantScopeImpl
extends GenericVariantScopeImpl
implements VariantScope {
    private static final ILogger LOGGER = LoggerWrapper.getLogger(VariantScopeImpl.class);
    private final PublishingSpecs.VariantSpec variantPublishingSpec;
    private final GlobalScope globalScope;
    private final BaseVariantData variantData;
    private final TransformManager transformManager;
    private Collection<Object> ndkBuildable;
    private Collection<File> ndkSoFolder;
    private File ndkObjFolder;
    private final Map<Abi, File> ndkDebuggableLibraryFolders = Maps.newHashMap();
    private File mergeResourceOutputDir;
    private DefaultTask assembleTask;
    private DefaultTask preBuildTask;
    private Task sourceGenTask;
    private Task resourceGenTask;
    private Task assetGenTask;
    private CheckManifest checkManifestTask;
    private RenderscriptCompile renderscriptCompileTask;
    private AidlCompile aidlCompileTask;
    private MergeSourceSetFolders mergeAssetsTask;
    private GenerateBuildConfig generateBuildConfigTask;
    private Sync processJavaResourcesTask;
    private TransformTask mergeJavaResourcesTask;
    private JavaCompile javacTask;
    private Task compileTask;
    private DefaultTask connectedTask;
    private GenerateApkDataTask microApkTask;
    private ExternalNativeBuildTask externalNativeBuild;
    private ExternalNativeJsonGenerator externalNativeJsonGenerator;
    private CodeShrinker defaultCodeShrinker;
    private BuildArtifactsHolder buildArtifactsHolder;
    private Task coverageReportTask;
    private File resourceOutputDir;
    private InstantRunTaskManager instantRunTaskManager;
    private ConfigurableFileCollection desugarTryWithResourcesRuntimeJar;
    private DataBindingExportBuildInfoTask dataBindingExportBuildInfoTask;
    private final InstantRunBuildContext instantRunBuildContext;
    ProcessAndroidResources processAndroidResourcesTask;

    public VariantScopeImpl(GlobalScope globalScope, TransformManager transformManager, BaseVariantData variantData) {
        this.globalScope = globalScope;
        this.transformManager = transformManager;
        this.variantData = variantData;
        this.variantPublishingSpec = PublishingSpecs.getVariantSpec(variantData.getType());
        ProjectOptions projectOptions = globalScope.getProjectOptions();
        this.instantRunBuildContext = new InstantRunBuildContext(variantData.getVariantConfiguration().isInstantRunBuild(globalScope), AaptGeneration.fromProjectOptions(projectOptions), DeploymentDevice.getDeploymentDeviceAndroidVersion(projectOptions), projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI), projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY), projectOptions.get(BooleanOption.ENABLE_SEPARATE_APK_RESOURCES));
        this.buildArtifactsHolder = new BuildArtifactsHolder(this.getProject(), this.getFullVariantName(), new File(globalScope.getIntermediatesDir(), "artifact_transform"), this.getVariantConfiguration().getDirName(), (List<? extends ArtifactType>)ImmutableList.of((Object)((Object)InternalArtifactType.COMPATIBLE_SCREEN_MANIFEST)), globalScope.getDslScope());
        this.validatePostprocessingOptions();
    }

    private void validatePostprocessingOptions() {
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions == null) {
            return;
        }
        if (postprocessingOptions.getCodeShrinkerEnum() == CodeShrinker.ANDROID_GRADLE) {
            if (postprocessingOptions.isObfuscate()) {
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "The 'android-gradle' code shrinker does not support obfuscating.");
            }
            if (postprocessingOptions.isOptimizeCode()) {
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "The 'android-gradle' code shrinker does not support optimizing code.");
            }
        }
    }

    @Override
    protected Project getProject() {
        return this.globalScope.getProject();
    }

    @Override
    public PublishingSpecs.VariantSpec getPublishingSpec() {
        return this.variantPublishingSpec;
    }

    @Override
    public ConfigurableFileCollection addTaskOutput(ArtifactType outputType, Object file, String taskName) {
        PublishingSpecs.OutputSpec taskSpec;
        ConfigurableFileCollection fileCollection;
        try {
            fileCollection = super.addTaskOutput(outputType, file, taskName);
        }
        catch (TaskOutputAlreadyRegisteredException e) {
            throw new RuntimeException(String.format("OutputType '%s' already registered for variant '%s'", e.getOutputType(), this.getFullVariantName()), e);
        }
        if (file instanceof File && (taskSpec = this.variantPublishingSpec.getSpec(outputType)) != null) {
            Preconditions.checkNotNull((Object)taskName);
            this.publishIntermediateArtifact(file, taskName, taskSpec.getArtifactType(), (Collection<AndroidArtifacts.PublishedConfigType>)taskSpec.getPublishedConfigTypes());
        }
        return fileCollection;
    }

    @Override
    public FileCollection getOutput(ArtifactType outputType) throws MissingTaskOutputException {
        try {
            return super.getOutput(outputType);
        }
        catch (MissingTaskOutputException e) {
            throw new RuntimeException(String.format("Variant '%1$s' in project '%2$s' has no output with type '%3$s'", this.getFullVariantName(), this.getProject().getPath(), e.getOutputType()), e);
        }
    }

    @Override
    public void publishIntermediateArtifact(BuildableArtifact artifact, AndroidArtifacts.ArtifactType artifactType, Collection<AndroidArtifacts.PublishedConfigType> configTypes) {
        Provider provider = this.getProject().provider(() -> (File)Iterables.getOnlyElement((Iterable)artifact.getFiles()));
        this.publishIntermediateArtifact(provider, artifact, artifactType, configTypes);
    }

    @Deprecated
    private void publishIntermediateArtifact(Object file, Object builtBy, AndroidArtifacts.ArtifactType artifactType, Collection<AndroidArtifacts.PublishedConfigType> configTypes) {
        Preconditions.checkState((!configTypes.isEmpty() ? 1 : 0) != 0);
        VariantDependencies variantDependency = this.getVariantData().getVariantDependency();
        if (configTypes.contains((Object)AndroidArtifacts.PublishedConfigType.API_ELEMENTS)) {
            Preconditions.checkNotNull((Object)variantDependency.getApiElements(), (Object)"Publishing to API Element with no ApiElements configuration object");
            VariantScopeImpl.publishArtifactToConfiguration(variantDependency.getApiElements(), file, builtBy, artifactType);
        }
        if (configTypes.contains((Object)AndroidArtifacts.PublishedConfigType.RUNTIME_ELEMENTS)) {
            Preconditions.checkNotNull((Object)variantDependency.getRuntimeElements(), (Object)"Publishing to Runtime Element with no RuntimeElements configuration object");
            VariantScopeImpl.publishArtifactToConfiguration(variantDependency.getRuntimeElements(), file, builtBy, artifactType);
        }
        if (configTypes.contains((Object)AndroidArtifacts.PublishedConfigType.METADATA_ELEMENTS)) {
            Preconditions.checkNotNull((Object)variantDependency.getMetadataElements(), (Object)"Publishing to Metadata Element with no MetaDataElements configuration object");
            VariantScopeImpl.publishArtifactToConfiguration(variantDependency.getMetadataElements(), file, builtBy, artifactType);
        }
        if (configTypes.contains((Object)AndroidArtifacts.PublishedConfigType.BUNDLE_ELEMENTS)) {
            Preconditions.checkNotNull((Object)variantDependency.getBundleElements(), (Object)"Publishing to Bundle Element with no BundleElements configuration object");
            VariantScopeImpl.publishArtifactToConfiguration(variantDependency.getBundleElements(), file, builtBy, artifactType);
        }
    }

    private static void publishArtifactToConfiguration(Configuration configuration, Object file, Object builtBy, AndroidArtifacts.ArtifactType artifactType) {
        String type = artifactType.getType();
        configuration.getOutgoing().variants(variants -> variants.create(type, variant -> variant.artifact(file, artifact -> {
            artifact.setType(type);
            artifact.builtBy(new Object[]{builtBy});
        })));
    }

    @Override
    public GlobalScope getGlobalScope() {
        return this.globalScope;
    }

    @Override
    public BaseVariantData getVariantData() {
        return this.variantData;
    }

    @Override
    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantData.getVariantConfiguration();
    }

    @Override
    public String getFullVariantName() {
        return this.getVariantConfiguration().getFullName();
    }

    private PostprocessingOptions getPostprocessingOptionsIfUsed() {
        BuildType dslBuildType;
        CoreBuildType coreBuildType = this.getCoreBuildType();
        if (coreBuildType instanceof BuildType && (dslBuildType = (BuildType)coreBuildType).getPostprocessingConfiguration() == BuildType.PostprocessingConfiguration.POSTPROCESSING_BLOCK) {
            return dslBuildType.getPostprocessing();
        }
        return null;
    }

    private CoreBuildType getCoreBuildType() {
        return (CoreBuildType)this.getVariantConfiguration().getBuildType();
    }

    @Override
    public boolean useResourceShrinker() {
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        boolean userEnabledShrinkResources = postprocessingOptions != null ? postprocessingOptions.isRemoveUnusedResources() : this.getCoreBuildType().isShrinkResources();
        if (!userEnabledShrinkResources) {
            return false;
        }
        if (this.variantData.getType() == VariantType.LIBRARY) {
            if (!this.getProject().getPlugins().hasPlugin("com.android.feature")) {
                this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Resource shrinker cannot be used for libraries.");
            }
            return false;
        }
        if (this.getCodeShrinker() == null) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Removing unused resources requires unused code shrinking to be turned on. See http://d.android.com/r/tools/shrink-resources.html for more information.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isCrunchPngs() {
        Boolean buildTypeOverride = ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isCrunchPngs();
        if (buildTypeOverride != null) {
            return buildTypeOverride;
        }
        Boolean globalOverride = this.globalScope.getExtension().getAaptOptions().getCruncherEnabledOverride();
        if (globalOverride != null) {
            return globalOverride;
        }
        return ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isCrunchPngsDefault();
    }

    @Override
    public CodeShrinker getCodeShrinker() {
        boolean isForTesting = this.getVariantConfiguration().getType().isForTesting();
        if (isForTesting && this.getTestedVariantData().getType() == VariantType.LIBRARY) {
            return null;
        }
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions == null) {
            CodeShrinker shrinkerForBuildType;
            CoreBuildType coreBuildType = this.getCoreBuildType();
            if (!coreBuildType.isMinifyEnabled()) {
                return null;
            }
            Boolean useProguard = coreBuildType.isUseProguard();
            if (useProguard == null) {
                shrinkerForBuildType = this.getDefaultCodeShrinker();
            } else {
                CodeShrinker codeShrinker = shrinkerForBuildType = useProguard != false ? CodeShrinker.PROGUARD : CodeShrinker.ANDROID_GRADLE;
            }
            if (!isForTesting) {
                return shrinkerForBuildType;
            }
            if (shrinkerForBuildType == CodeShrinker.PROGUARD) {
                return CodeShrinker.PROGUARD;
            }
            return null;
        }
        CodeShrinker chosenShrinker = postprocessingOptions.getCodeShrinkerEnum();
        if (chosenShrinker == null) {
            chosenShrinker = this.getDefaultCodeShrinker();
        }
        switch (chosenShrinker) {
            case PROGUARD: {
                if (!isForTesting) {
                    boolean somethingToDo = postprocessingOptions.isRemoveUnusedCode() || postprocessingOptions.isObfuscate() || postprocessingOptions.isOptimizeCode();
                    return somethingToDo ? CodeShrinker.PROGUARD : null;
                }
                return postprocessingOptions.isObfuscate() ? CodeShrinker.PROGUARD : null;
            }
            case ANDROID_GRADLE: {
                if (isForTesting) {
                    return null;
                }
                return postprocessingOptions.isRemoveUnusedCode() ? CodeShrinker.ANDROID_GRADLE : null;
            }
        }
        throw new AssertionError((Object)("Unknown value " + (Object)((Object)chosenShrinker)));
    }

    @Override
    public List<File> getProguardFiles() {
        List<File> result = this.gatherProguardFiles(PostprocessingOptions::getProguardFiles, BaseConfig::getProguardFiles);
        if (this.getPostprocessingOptionsIfUsed() == null && result.isEmpty()) {
            result.add(ProguardFiles.getDefaultProguardFile(ProguardFiles.ProguardFile.DONT_OPTIMIZE.fileName, this.getProject()));
        }
        return result;
    }

    @Override
    public List<File> getTestProguardFiles() {
        return this.gatherProguardFiles(PostprocessingOptions::getTestProguardFiles, BaseConfig::getTestProguardFiles);
    }

    @Override
    public List<File> getConsumerProguardFiles() {
        return this.gatherProguardFiles(PostprocessingOptions::getConsumerProguardFiles, BaseConfig::getConsumerProguardFiles);
    }

    private List<File> gatherProguardFiles(Function<PostprocessingOptions, List<File>> postprocessingGetter, Function<BaseConfig, Collection<File>> baseConfigGetter) {
        GradleVariantConfiguration variantConfiguration = this.getVariantConfiguration();
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(baseConfigGetter.apply((BaseConfig)variantConfiguration.getDefaultConfig()));
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions == null) {
            result.addAll(baseConfigGetter.apply((BaseConfig)variantConfiguration.getBuildType()));
        } else {
            result.addAll((Collection)postprocessingGetter.apply(postprocessingOptions));
        }
        for (CoreProductFlavor flavor : variantConfiguration.getProductFlavors()) {
            result.addAll(baseConfigGetter.apply((BaseConfig)flavor));
        }
        return result;
    }

    @Override
    public PostprocessingFeatures getPostprocessingFeatures() {
        PostprocessingOptions postprocessingOptions = this.getPostprocessingOptionsIfUsed();
        if (postprocessingOptions != null) {
            return new PostprocessingFeatures(postprocessingOptions.isRemoveUnusedCode(), postprocessingOptions.isObfuscate(), postprocessingOptions.isOptimizeCode());
        }
        return null;
    }

    private CodeShrinker getDefaultCodeShrinker() {
        if (this.defaultCodeShrinker == null) {
            if (this.getInstantRunBuildContext().isInInstantRunMode()) {
                String message = "Using the built-in class shrinker for an Instant Run build.";
                PostprocessingFeatures postprocessingFeatures = this.getPostprocessingFeatures();
                if (postprocessingFeatures == null || postprocessingFeatures.isObfuscate()) {
                    message = message + " Build won't be obfuscated.";
                }
                LOGGER.warning(message, new Object[0]);
                this.defaultCodeShrinker = CodeShrinker.ANDROID_GRADLE;
            } else {
                this.defaultCodeShrinker = CodeShrinker.PROGUARD;
            }
        }
        return this.defaultCodeShrinker;
    }

    @Override
    public boolean isTestOnly() {
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        Boolean isTestOnlyOverride = projectOptions.get(OptionalBooleanOption.IDE_TEST_ONLY);
        if (isTestOnlyOverride != null) {
            return isTestOnlyOverride;
        }
        return !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI)) || !Strings.isNullOrEmpty((String)projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY)) || projectOptions.get(IntegerOption.IDE_TARGET_DEVICE_API) != null || this.globalScope.getAndroidBuilder().isPreviewTarget() || this.getMinSdkVersion().getCodename() != null || this.getVariantConfiguration().getTargetSdkVersion().getCodename() != null;
    }

    @Override
    public boolean isBaseFeature() {
        return this.globalScope.getExtension().getBaseFeature();
    }

    @Override
    public DexingType getDexingType() {
        if (this.getInstantRunBuildContext().isInInstantRunMode()) {
            return DexingType.NATIVE_MULTIDEX;
        }
        return this.variantData.getVariantConfiguration().getDexingType();
    }

    @Override
    public AndroidVersion getMinSdkVersion() {
        return this.getVariantConfiguration().getMinSdkVersion();
    }

    @Override
    public String getDirName() {
        return this.variantData.getVariantConfiguration().getDirName();
    }

    @Override
    public Collection<String> getDirectorySegments() {
        return this.variantData.getVariantConfiguration().getDirectorySegments();
    }

    @Override
    public TransformManager getTransformManager() {
        return this.transformManager;
    }

    @Override
    public String getTaskName(String prefix) {
        return this.getTaskName(prefix, "");
    }

    @Override
    public String getTaskName(String prefix, String suffix) {
        return this.variantData.getTaskName(prefix, suffix);
    }

    @Override
    public Collection<Object> getNdkBuildable() {
        return this.ndkBuildable;
    }

    @Override
    public void setNdkBuildable(Collection<Object> ndkBuildable) {
        this.ndkBuildable = ndkBuildable;
    }

    @Override
    public Collection<File> getNdkSoFolder() {
        return this.ndkSoFolder;
    }

    @Override
    public void setNdkSoFolder(Collection<File> ndkSoFolder) {
        this.ndkSoFolder = ndkSoFolder;
    }

    @Override
    public File getNdkDebuggableLibraryFolders(Abi abi) {
        return this.ndkDebuggableLibraryFolders.get((Object)abi);
    }

    @Override
    public void addNdkDebuggableLibraryFolders(Abi abi, File searchPath) {
        this.ndkDebuggableLibraryFolders.put(abi, searchPath);
    }

    @Override
    public BaseVariantData getTestedVariantData() {
        return this.variantData instanceof TestVariantData ? (BaseVariantData)((Object)((TestVariantData)this.variantData).getTestedVariantData()) : null;
    }

    @Override
    public File getBuildInfoOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/build-info/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getReloadDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/reload-dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRestartDexOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/restart-dex/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunSplitApkOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/split-apk/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getDefaultInstantRunApkLocation() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"instant-run-apk"});
    }

    @Override
    public File getInstantRunPastIterationsFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/builds/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType) {
        return this.getJavaClasspath(configType, classesType, null);
    }

    @Override
    public FileCollection getJavaClasspath(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        FileCollection mainCollection = this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        mainCollection = mainCollection.plus(this.getVariantData().getGeneratedBytecode(generatedBytecodeKey));
        if (Boolean.TRUE.equals(this.globalScope.getExtension().getAaptOptions().getNamespaced())) {
            mainCollection = mainCollection.plus(this.getOutput(InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR));
            mainCollection = mainCollection.plus(this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR));
            mainCollection = mainCollection.plus(this.getArtifactFileCollection(configType, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.SHARED_CLASSES));
            BaseVariantData tested = this.getTestedVariantData();
            if (tested != null) {
                mainCollection = mainCollection.plus(tested.getScope().getOutput(InternalArtifactType.COMPILE_ONLY_NAMESPACED_R_CLASS_JAR));
            }
        } else {
            BaseVariantData tested;
            if (this.hasOutput(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)) {
                FileCollection rJar = this.getOutput(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR);
                mainCollection = mainCollection.plus(rJar);
            }
            if ((tested = this.getTestedVariantData()) != null && tested.getScope().hasOutput(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR)) {
                FileCollection rJar = tested.getScope().getOutput(InternalArtifactType.COMPILE_ONLY_NOT_NAMESPACED_R_CLASS_JAR);
                mainCollection = mainCollection.plus(rJar);
            }
        }
        return mainCollection;
    }

    @Override
    public ArtifactCollection getJavaClasspathArtifacts(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactType classesType, Object generatedBytecodeKey) {
        ArtifactCollection mainCollection = this.getArtifactCollection(configType, AndroidArtifacts.ArtifactScope.ALL, classesType);
        return ArtifactCollectionWithExtraArtifact.makeExtraCollection(mainCollection, this.getVariantData().getGeneratedBytecode(generatedBytecodeKey), this.getProject().getPath());
    }

    @Override
    public boolean keepDefaultBootstrap() {
        if (!JavaVersion.current().isJava8Compatible()) {
            return false;
        }
        VariantScope.Java8LangSupport java8LangSupport = this.getJava8LangSupportType();
        return java8LangSupport == VariantScope.Java8LangSupport.DESUGAR || java8LangSupport == VariantScope.Java8LangSupport.D8;
    }

    @Override
    public File getManifestCheckerDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/manifest-checker/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunMainApkResourcesDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/instant-run-main-apk-res/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getIncrementalRuntimeSupportJar() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-runtime-classes/" + this.variantData.getVariantConfiguration().getDirName() + "/instant-run.jar");
    }

    @Override
    public File getIncrementalApplicationSupportDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-classes/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getInstantRunResourcesFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"instant-run-resources", "resources-" + this.variantData.getVariantConfiguration().getDirName() + ".ir.ap_"});
    }

    @Override
    public File getIncrementalVerifierDir() {
        return new File(this.globalScope.getIntermediatesDir(), "/incremental-verifier/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public BuildArtifactsHolder getBuildArtifactsHolder() {
        return this.buildArtifactsHolder;
    }

    @Override
    public FileCollection getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        ArtifactCollection artifacts = this.computeArtifactCollection(configType, scope, artifactType);
        FileCollection fileCollection = configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.getVariantConfiguration().getType() == VariantType.FEATURE && artifactType != AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS ? new FilteredArtifactCollection(this.globalScope.getProject(), artifacts, this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS).getArtifactFiles()).getArtifactFiles() : artifacts.getArtifactFiles();
        if (configType.needsTestedComponents()) {
            return this.handleTestedComponent(fileCollection, configType, scope, artifactType, (mainCollection, testedCollection, unused) -> mainCollection.plus(testedCollection), (collection, artifactCollection) -> collection.minus(artifactCollection.getArtifactFiles()), (collection, artifactCollection) -> {
                throw new RuntimeException("Can't do smart subtraction on a file collection");
            });
        }
        return fileCollection;
    }

    @Override
    public ArtifactCollection getArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        ArtifactCollection artifacts = this.computeArtifactCollection(configType, scope, artifactType);
        if (configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && this.getVariantConfiguration().getType() == VariantType.FEATURE && artifactType != AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS) {
            artifacts = new FilteredArtifactCollection(this.globalScope.getProject(), artifacts, this.computeArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.MODULE, AndroidArtifacts.ArtifactType.FEATURE_TRANSITIVE_DEPS).getArtifactFiles());
        }
        if (configType.needsTestedComponents()) {
            return this.handleTestedComponent(artifacts, configType, scope, artifactType, (artifactResults, collection, variantName) -> ArtifactCollectionWithExtraArtifact.makeExtraCollectionForTest(artifactResults, collection, this.getProject().getPath(), variantName), SubtractingArtifactCollection::new, (testArtifact, testedArtifact) -> new AndroidTestResourceArtifactCollection((ArtifactCollection)testArtifact, (Collection<? extends Dependency>)this.getVariantData().getVariantDependency().getIncomingRuntimeDependencies(), this.getVariantData().getVariantDependency().getRuntimeClasspath().getIncoming()));
        }
        return artifacts;
    }

    private Configuration getConfiguration(AndroidArtifacts.ConsumedConfigType configType) {
        switch (configType) {
            case COMPILE_CLASSPATH: {
                return this.getVariantData().getVariantDependency().getCompileClasspath();
            }
            case RUNTIME_CLASSPATH: {
                return this.getVariantData().getVariantDependency().getRuntimeClasspath();
            }
            case ANNOTATION_PROCESSOR: {
                return this.getVariantData().getVariantDependency().getAnnotationProcessorConfiguration();
            }
            case METADATA_VALUES: {
                return (Configuration)Preconditions.checkNotNull((Object)this.getVariantData().getVariantDependency().getMetadataValuesConfiguration());
            }
        }
        throw new RuntimeException("unknown ConfigType value " + (Object)((Object)configType));
    }

    private ArtifactCollection computeArtifactCollection(AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope scope, AndroidArtifacts.ArtifactType artifactType) {
        Configuration configuration = this.getConfiguration(configType);
        Action attributes2 = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)artifactType.getType());
        Spec<ComponentIdentifier> filter = VariantScopeImpl.getComponentFilter(scope);
        boolean lenientMode = Boolean.TRUE.equals(this.globalScope.getProjectOptions().get(BooleanOption.IDE_BUILD_MODEL_ONLY));
        return configuration.getIncoming().artifactView(config -> {
            config.attributes(attributes2);
            if (filter != null) {
                config.componentFilter(filter);
            }
            config.lenient(lenientMode);
        }).getArtifacts();
    }

    private static Spec<ComponentIdentifier> getComponentFilter(AndroidArtifacts.ArtifactScope scope) {
        switch (scope) {
            case ALL: {
                return null;
            }
            case EXTERNAL: {
                return id -> !(id instanceof ProjectComponentIdentifier);
            }
            case MODULE: {
                return id -> id instanceof ProjectComponentIdentifier;
            }
        }
        throw new RuntimeException("unknown ArtifactScope value");
    }

    @Override
    public FileCollection getLocalPackagedJars() {
        Configuration configuration = this.getVariantData().getVariantDependency().getRuntimeClasspath();
        Callable<Collection> dependencies = () -> (ImmutableList)configuration.getAllDependencies().stream().filter(it -> it instanceof SelfResolvingDependency).filter(it -> !(it instanceof ProjectDependency)).map(it -> (SelfResolvingDependency)it).collect(ImmutableList.toImmutableList());
        return this.getGlobalScope().getProject().files(new Object[]{TaskInputHelper.bypassFileCallable(() -> {
            try {
                return ((Collection)dependencies.call()).stream().flatMap(it -> it.resolve().stream()).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })}).builtBy(new Object[]{dependencies});
    }

    @Override
    public FileCollection getProvidedOnlyClasspath() {
        FileCollection compile = this.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        FileCollection pkg = this.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.CLASSES);
        return compile.minus(pkg);
    }

    private File intermediate(String directoryName) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{directoryName, this.getVariantConfiguration().getDirName()});
    }

    private File intermediate(String directoryName, String fileName) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{directoryName, this.getVariantConfiguration().getDirName(), fileName});
    }

    @Override
    public File getIntermediateJarOutputFolder() {
        return new File(this.globalScope.getIntermediatesDir(), "/intermediate-jars/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getProguardComponentsJarFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/componentClasses.jar");
    }

    @Override
    public File getManifestKeepListProguardFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/manifest_keep.txt");
    }

    @Override
    public File getConsumerProguardFile() {
        return this.intermediate("publish-proguard", "proguard.txt");
    }

    @Override
    public File getMainDexListFile() {
        return new File(this.globalScope.getIntermediatesDir(), "multi-dex/" + this.getVariantConfiguration().getDirName() + "/maindexlist.txt");
    }

    @Override
    public File getRenderscriptSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/rs/" + this.variantData.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRenderscriptLibOutputDir() {
        return new File(this.globalScope.getIntermediatesDir(), "rs/" + this.variantData.getVariantConfiguration().getDirName() + "/lib");
    }

    @Override
    public void setResourceOutputDir(File resourceOutputDir) {
        this.resourceOutputDir = resourceOutputDir;
    }

    @Override
    public File getDefaultMergeResourcesOutputDir() {
        return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"res", "merged", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getCompiledResourcesOutputDir() {
        return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"res", "compiled", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getResourceBlameLogDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"blame", "res", this.getDirectorySegments()}));
    }

    @Override
    public File getMergeNativeLibsOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"/jniLibs/" + this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getMergeShadersOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"/shaders/" + this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getBuildConfigSourceOutputDir() {
        return new File(this.globalScope.getBuildDir() + "/" + "generated" + "/source/buildConfig/" + this.variantData.getVariantConfiguration().getDirName());
    }

    private File getGeneratedResourcesDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"res", name, this.getDirectorySegments()}));
    }

    @Override
    public File getGeneratedAssetsDir(String name) {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"assets", name, this.getDirectorySegments()}));
    }

    @Override
    public File getGeneratedResOutputDir() {
        return this.getGeneratedResourcesDir("resValues");
    }

    @Override
    public File getGeneratedPngsOutputDir() {
        return this.getGeneratedResourcesDir("pngs");
    }

    @Override
    public File getRenderscriptResOutputDir() {
        return this.getGeneratedResourcesDir("rs");
    }

    @Override
    public File getRenderscriptObjOutputDir() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (Iterable)StringHelper.toStrings((Object[])new Object[]{"rs", this.getDirectorySegments(), "obj"}));
    }

    @Override
    public File getSourceFoldersJavaResDestinationDir() {
        return new File(this.globalScope.getIntermediatesDir(), "sourceFolderJavaResources/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getRClassSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/r/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getAidlSourceOutputDir() {
        return new File(this.globalScope.getGeneratedDir(), "source/aidl/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getIncrementalDir(String name) {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"incremental", name});
    }

    @Override
    public File getAarClassesJar() {
        return this.intermediate("packaged-classes", "classes.jar");
    }

    @Override
    public File getAarLibsDirectory() {
        return this.intermediate("packaged-classes", "libs");
    }

    @Override
    public File getAnnotationZipFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"annotations", this.getVariantConfiguration().getDirName(), "annotations.zip"});
    }

    @Override
    public File getTypedefFile() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"extractedTypedefs", this.getVariantConfiguration().getDirName(), "typedefs.txt"});
    }

    @Override
    public File getCoverageReportDir() {
        return new File(this.globalScope.getReportsDir(), "coverage/" + this.getDirName());
    }

    @Override
    public File getClassOutputForDataBinding() {
        return new File(this.globalScope.getGeneratedDir(), "source/dataBinding/trigger/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getLayoutInfoOutputForDataBinding() {
        return this.dataBindingIntermediate("layout-info");
    }

    @Override
    public File getBuildFolderForDataBindingCompiler() {
        return this.dataBindingIntermediate("compiler");
    }

    @Override
    public File getGeneratedClassListOutputFileForDataBinding() {
        return new File(this.dataBindingIntermediate("class-list"), "_generated.txt");
    }

    @Override
    public File getBundleArtifactFolderForDataBinding() {
        return this.dataBindingIntermediate("bundle-bin");
    }

    private File dataBindingIntermediate(String name) {
        return this.intermediate("data-binding", name);
    }

    @Override
    public File getProcessAndroidResourcesProguardOutputFile() {
        return new File(this.globalScope.getIntermediatesDir(), "/proguard-rules/" + this.getVariantConfiguration().getDirName() + "/aapt_rules.txt");
    }

    @Override
    public File getGenerateSplitAbiResOutputDirectory() {
        return new File(this.globalScope.getIntermediatesDir(), FileUtils.join((String[])new String[]{"splits", "res", "abi", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getSplitSupportDirectory() {
        return new File(this.globalScope.getIntermediatesDir(), "splits-support/" + this.getVariantConfiguration().getDirName());
    }

    @Override
    public File getSplitDensityOrLanguagesPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "densityLanguage", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getSplitAbiPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "abi", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getFullApkPackagesOutputDirectory() {
        return new File(this.globalScope.getBuildDir(), FileUtils.join((String[])new String[]{"outputs", "splits", "full", this.getVariantConfiguration().getDirName()}));
    }

    @Override
    public File getAaptFriendlyManifestOutputDirectory() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "aapt", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getInstantRunManifestOutputDirectory() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "instant-run", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getInstantRunResourceApkFolder() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"resources", "instant-run", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getIntermediateDir(InternalArtifactType taskOutputType) {
        return this.intermediate(taskOutputType.name().toLowerCase(Locale.US));
    }

    @Override
    public File getMicroApkManifestFile() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"manifests", "microapk", this.getVariantConfiguration().getDirName(), "AndroidManifest.xml"});
    }

    @Override
    public File getMicroApkResDirectory() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"res", "microapk", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getCompatibleScreensManifestDirectory() {
        return FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"manifests", "density", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public File getManifestOutputDirectory() {
        switch (this.getVariantConfiguration().getType()) {
            case APK: 
            case FEATURE: 
            case LIBRARY: {
                return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"manifests", "full", this.getVariantConfiguration().getDirName()});
            }
            case ANDROID_TEST: {
                return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"manifest", this.getVariantConfiguration().getDirName()});
            }
        }
        throw new RuntimeException("getManifestOutputDirectory called for an unexpected variant.");
    }

    @Override
    public File getApkLocation() {
        String override = this.globalScope.getProjectOptions().get(StringOption.IDE_APK_LOCATION);
        File defaultLocation = this.getInstantRunBuildContext().isInInstantRunMode() ? this.getDefaultInstantRunApkLocation() : this.getDefaultApkLocation();
        File baseDirectory = override != null && this.variantData.getType() != VariantType.FEATURE ? this.globalScope.getProject().file((Object)override) : defaultLocation;
        return new File(baseDirectory, this.getVariantConfiguration().getDirName());
    }

    private File getDefaultApkLocation() {
        return FileUtils.join((File)this.globalScope.getBuildDir(), (String[])new String[]{"outputs", "apk"});
    }

    @Override
    public File getAarLocation() {
        return FileUtils.join((File)this.globalScope.getOutputsDir(), (String[])new String[]{"aar"});
    }

    @Override
    public File getAnnotationProcessorOutputDir() {
        return FileUtils.join((File)this.globalScope.getGeneratedDir(), (String[])new String[]{"source", "apt", this.getVariantConfiguration().getDirName()});
    }

    @Override
    public DefaultTask getAssembleTask() {
        return this.assembleTask;
    }

    @Override
    public void setAssembleTask(DefaultTask assembleTask) {
        this.assembleTask = assembleTask;
    }

    @Override
    public DefaultTask getPreBuildTask() {
        return this.preBuildTask;
    }

    @Override
    public void setPreBuildTask(DefaultTask preBuildTask) {
        this.preBuildTask = preBuildTask;
    }

    @Override
    public Task getSourceGenTask() {
        return this.sourceGenTask;
    }

    @Override
    public void setSourceGenTask(Task sourceGenTask) {
        this.sourceGenTask = sourceGenTask;
    }

    @Override
    public Task getResourceGenTask() {
        return this.resourceGenTask;
    }

    @Override
    public void setResourceGenTask(Task resourceGenTask) {
        this.resourceGenTask = resourceGenTask;
    }

    @Override
    public Task getAssetGenTask() {
        return this.assetGenTask;
    }

    @Override
    public void setAssetGenTask(Task assetGenTask) {
        this.assetGenTask = assetGenTask;
    }

    @Override
    public CheckManifest getCheckManifestTask() {
        return this.checkManifestTask;
    }

    @Override
    public void setCheckManifestTask(CheckManifest checkManifestTask) {
        this.checkManifestTask = checkManifestTask;
    }

    @Override
    public RenderscriptCompile getRenderscriptCompileTask() {
        return this.renderscriptCompileTask;
    }

    @Override
    public void setRenderscriptCompileTask(RenderscriptCompile renderscriptCompileTask) {
        this.renderscriptCompileTask = renderscriptCompileTask;
    }

    @Override
    public AidlCompile getAidlCompileTask() {
        return this.aidlCompileTask;
    }

    @Override
    public void setAidlCompileTask(AidlCompile aidlCompileTask) {
        this.aidlCompileTask = aidlCompileTask;
    }

    @Override
    public MergeSourceSetFolders getMergeAssetsTask() {
        return this.mergeAssetsTask;
    }

    @Override
    public void setMergeAssetsTask(MergeSourceSetFolders mergeAssetsTask) {
        this.mergeAssetsTask = mergeAssetsTask;
    }

    @Override
    public GenerateBuildConfig getGenerateBuildConfigTask() {
        return this.generateBuildConfigTask;
    }

    @Override
    public void setGenerateBuildConfigTask(GenerateBuildConfig generateBuildConfigTask) {
        this.generateBuildConfigTask = generateBuildConfigTask;
    }

    @Override
    public Sync getProcessJavaResourcesTask() {
        return this.processJavaResourcesTask;
    }

    @Override
    public void setProcessJavaResourcesTask(Sync processJavaResourcesTask) {
        this.processJavaResourcesTask = processJavaResourcesTask;
    }

    @Override
    public void setMergeJavaResourcesTask(TransformTask mergeJavaResourcesTask) {
        this.mergeJavaResourcesTask = mergeJavaResourcesTask;
    }

    @Override
    public JavaCompile getJavacTask() {
        return this.javacTask;
    }

    @Override
    public void setJavacTask(JavaCompile javacTask) {
        this.javacTask = javacTask;
    }

    @Override
    public Task getCompileTask() {
        return this.compileTask;
    }

    @Override
    public void setCompileTask(Task compileTask) {
        this.compileTask = compileTask;
    }

    @Override
    public DefaultTask getConnectedTask() {
        return this.connectedTask;
    }

    @Override
    public void setConnectedTask(DefaultTask connectedTask) {
        this.connectedTask = connectedTask;
    }

    @Override
    public GenerateApkDataTask getMicroApkTask() {
        return this.microApkTask;
    }

    @Override
    public void setMicroApkTask(GenerateApkDataTask microApkTask) {
        this.microApkTask = microApkTask;
    }

    @Override
    public Task getCoverageReportTask() {
        return this.coverageReportTask;
    }

    @Override
    public void setCoverageReportTask(Task coverageReportTask) {
        this.coverageReportTask = coverageReportTask;
    }

    @Override
    public InstantRunBuildContext getInstantRunBuildContext() {
        return this.instantRunBuildContext;
    }

    @Override
    public ImmutableList<File> getInstantRunBootClasspath() {
        SdkHandler sdkHandler = this.getGlobalScope().getSdkHandler();
        AndroidBuilder androidBuilder = this.globalScope.getAndroidBuilder();
        IAndroidTarget androidBuilderTarget = androidBuilder.getTarget();
        File annotationsJar = sdkHandler.getSdkLoader().getSdkInfo(LOGGER).getAnnotationsJar();
        AndroidVersion targetDeviceVersion = DeploymentDevice.getDeploymentDeviceAndroidVersion(this.getGlobalScope().getProjectOptions());
        if (targetDeviceVersion.equals((Object)androidBuilderTarget.getVersion())) {
            return BootClasspathBuilder.computeFullBootClasspath((IAndroidTarget)androidBuilderTarget, (File)annotationsJar);
        }
        IAndroidTarget targetToUse = VariantScopeImpl.getAndroidTarget(sdkHandler, AndroidTargetHash.getPlatformHashString((AndroidVersion)targetDeviceVersion));
        if (targetToUse == null) {
            throw new RuntimeException(String.format("In order to use Instant Run with this device running %1$S, you must install platform %1$S in your SDK", targetDeviceVersion.toString()));
        }
        return BootClasspathBuilder.computeFullBootClasspath((IAndroidTarget)targetToUse, (File)annotationsJar);
    }

    private static IAndroidTarget getAndroidTarget(SdkHandler sdkHandler, String targetHash) {
        File sdkLocation = sdkHandler.getSdkFolder();
        LoggerProgressIndicatorWrapper progressIndicator = new LoggerProgressIndicatorWrapper(LOGGER);
        IAndroidTarget target = AndroidSdkHandler.getInstance((File)sdkLocation).getAndroidTargetManager((ProgressIndicator)progressIndicator).getTargetFromHashString(targetHash, (ProgressIndicator)progressIndicator);
        if (target != null) {
            return target;
        }
        AndroidSdkHandler.resetInstance((File)sdkLocation);
        return AndroidSdkHandler.getInstance((File)sdkLocation).getAndroidTargetManager((ProgressIndicator)progressIndicator).getTargetFromHashString(targetHash, (ProgressIndicator)progressIndicator);
    }

    @Override
    public void setExternalNativeBuildTask(ExternalNativeBuildTask task) {
        this.externalNativeBuild = task;
    }

    @Override
    public ExternalNativeJsonGenerator getExternalNativeJsonGenerator() {
        return this.externalNativeJsonGenerator;
    }

    @Override
    public void setExternalNativeJsonGenerator(ExternalNativeJsonGenerator generator) {
        Preconditions.checkState((this.externalNativeJsonGenerator == null ? 1 : 0) != 0, (Object)"Unexpected overwrite of externalNativeJsonGenerator may result in information loss");
        this.externalNativeJsonGenerator = generator;
    }

    @Override
    public ExternalNativeBuildTask getExternalNativeBuildTask() {
        return this.externalNativeBuild;
    }

    @Override
    public InstantRunTaskManager getInstantRunTaskManager() {
        return this.instantRunTaskManager;
    }

    @Override
    public void setInstantRunTaskManager(InstantRunTaskManager instantRunTaskManager) {
        this.instantRunTaskManager = instantRunTaskManager;
    }

    @Override
    public TransformVariantScope getTransformVariantScope() {
        return this;
    }

    private <T> T handleTestedComponent(T collection, AndroidArtifacts.ConsumedConfigType configType, AndroidArtifacts.ArtifactScope artifactScope, AndroidArtifacts.ArtifactType artifactType, TriFunction<T, FileCollection, String, T> plusFunction, BiFunction<T, ArtifactCollection, T> minusFunction, BiFunction<T, ArtifactCollection, T> resourceMinusFunction) {
        VariantType variantType = this.getVariantConfiguration().getType();
        if (!variantType.isForTesting()) {
            return collection;
        }
        T result = collection;
        if (this.variantData instanceof TestVariantData) {
            ArtifactType taskOutputType;
            ImmutableList<AndroidArtifacts.PublishedConfigType> publishedConfigs;
            PublishingSpecs.VariantSpec testedSpec;
            PublishingSpecs.OutputSpec taskOutputSpec;
            TestedVariantData tested = ((TestVariantData)this.variantData).getTestedVariantData();
            VariantScope testedScope = tested.getScope();
            if ((artifactScope == AndroidArtifacts.ArtifactScope.MODULE || artifactScope == AndroidArtifacts.ArtifactScope.ALL) && (taskOutputSpec = (testedSpec = testedScope.getPublishingSpec().getTestingSpec(variantType)).getSpec(artifactType)) != null && (publishedConfigs = taskOutputSpec.getPublishedConfigTypes()).contains((Object)configType.getPublishedTo()) && testedScope.hasOutput(taskOutputType = taskOutputSpec.getOutputType())) {
                result = plusFunction.apply(result, testedScope.getOutput(taskOutputType), testedScope.getFullVariantName());
            }
            if (tested instanceof ApplicationVariantData && configType == AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH && variantType == VariantType.ANDROID_TEST) {
                result = artifactType == AndroidArtifacts.ArtifactType.ANDROID_RES ? resourceMinusFunction.apply(result, testedScope.getArtifactCollection(configType, artifactScope, artifactType)) : minusFunction.apply(result, testedScope.getArtifactCollection(configType, artifactScope, artifactType));
            }
        }
        return result;
    }

    @Override
    public File getProcessResourcePackageOutputDirectory() {
        return FileUtils.join((File)this.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"res", this.getDirName()});
    }

    @Override
    public void setProcessResourcesTask(ProcessAndroidResources processAndroidResourcesAndroidTask) {
        this.processAndroidResourcesTask = processAndroidResourcesAndroidTask;
    }

    @Override
    public ProcessAndroidResources getProcessResourcesTask() {
        return this.processAndroidResourcesTask;
    }

    @Override
    public void setDataBindingExportBuildInfoTask(DataBindingExportBuildInfoTask task) {
        this.dataBindingExportBuildInfoTask = task;
    }

    @Override
    public DataBindingExportBuildInfoTask getDataBindingExportBuildInfoTask() {
        return this.dataBindingExportBuildInfoTask;
    }

    @Override
    public OutputScope getOutputScope() {
        return this.variantData.getOutputScope();
    }

    @Override
    public VariantDependencies getVariantDependencies() {
        return this.variantData.getVariantDependency();
    }

    @Override
    public VariantScope.Java8LangSupport getJava8LangSupportType() {
        if (!this.getGlobalScope().getExtension().getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            return VariantScope.Java8LangSupport.UNUSED;
        }
        boolean isD8Desugaring = this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8_DESUGARING);
        if (isD8Desugaring && !this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Java 8 language support with D8 (as requested by '" + BooleanOption.ENABLE_D8_DESUGARING.getPropertyName() + " = true' in your gradle.properties file) is only supported when D8 dex compilation is enabled ('" + BooleanOption.ENABLE_D8.getPropertyName() + " = true').", this.getVariantConfiguration().getFullName());
            return VariantScope.Java8LangSupport.INVALID;
        }
        if (isD8Desugaring && !this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DEX_ARCHIVE)) {
            this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Java 8 language support with D8 (as requested by '" + BooleanOption.ENABLE_D8_DESUGARING.getPropertyName() + " = true' in your gradle.properties file) is not supported when dex archive is disabled ('" + BooleanOption.ENABLE_DEX_ARCHIVE.getPropertyName() + " = false').", this.getVariantConfiguration().getFullName());
            return VariantScope.Java8LangSupport.INVALID;
        }
        if (this.globalScope.getProject().getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            return VariantScope.Java8LangSupport.RETROLAMBDA;
        }
        if (isD8Desugaring) {
            return VariantScope.Java8LangSupport.D8;
        }
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_DESUGAR)) {
            return VariantScope.Java8LangSupport.DESUGAR;
        }
        this.globalScope.getErrorHandler().reportError(EvalIssueReporter.Type.GENERIC, "Please add 'android.enableD8.desugaring=true' to your gradle.properties file to enable Java 8 language support.", this.getVariantConfiguration().getFullName());
        return VariantScope.Java8LangSupport.INVALID;
    }

    @Override
    public ConfigurableFileCollection getTryWithResourceRuntimeSupportJar() {
        if (this.desugarTryWithResourcesRuntimeJar == null) {
            this.desugarTryWithResourcesRuntimeJar = this.getProject().files(new Object[]{FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"processing-tools", "runtime-deps", this.variantData.getVariantConfiguration().getDirName(), "desugar_try_with_resources.jar"})});
        }
        return this.desugarTryWithResourcesRuntimeJar;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.getFullVariantName()).toString();
    }

    @Override
    public DexerTool getDexer() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexerTool.D8;
        }
        return DexerTool.DX;
    }

    @Override
    public DexMergerTool getDexMerger() {
        if (this.globalScope.getProjectOptions().get(BooleanOption.ENABLE_D8)) {
            return DexMergerTool.D8;
        }
        return DexMergerTool.DX;
    }

    @FunctionalInterface
    public static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

