/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.ndk.Stl;
import com.android.build.gradle.internal.ndk.StlSpecification;
import com.android.build.gradle.internal.ndk.StlSpecificationFactory;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultStlSpecificationFactory
implements StlSpecificationFactory {
    @Override
    public StlSpecification create(Stl stl, String stlVersion, Abi abi) {
        switch (stl) {
            case SYSTEM: {
                return DefaultStlSpecificationFactory.createSpec(abi, (List<String>)ImmutableList.of((Object)"system/include"), "", (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of());
            }
            case STLPORT_SHARED: {
                return DefaultStlSpecificationFactory.createSpec(abi, (List<String>)ImmutableList.of((Object)"stlport/stlport", (Object)"gabi++/include"), "stlport", (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"libstlport_shared.so"));
            }
            case STLPORT_STATIC: {
                return DefaultStlSpecificationFactory.createSpec(abi, (List<String>)ImmutableList.of((Object)"stlport/stlport", (Object)"../gabi++/include"), "stlport", (List<String>)ImmutableList.of((Object)"libstlport_static.a"), (List<String>)ImmutableList.of());
            }
            case GNUSTL_SHARED: {
                return DefaultStlSpecificationFactory.createSpec(abi, (List<String>)ImmutableList.of((Object)("gnu-libstdc++/" + stlVersion + "/include"), (Object)("gnu-libstdc++/" + stlVersion + "/libs/" + abi.getName() + "/include"), (Object)("gnu-libstdc++/" + stlVersion + "/include/backward")), "gnu-libstdc++/" + stlVersion, (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"libgnustl_shared.so"));
            }
            case GNUSTL_STATIC: {
                return DefaultStlSpecificationFactory.createSpec(abi, (List<String>)ImmutableList.of((Object)("gnu-libstdc++/" + stlVersion + "/include"), (Object)("gnu-libstdc++/" + stlVersion + "/libs/" + abi.getName() + "/include"), (Object)("gnu-libstdc++/" + stlVersion + "/include/backward")), "gnu-libstdc++/" + stlVersion, (List<String>)ImmutableList.of((Object)"libgnustl_static.a"), (List<String>)ImmutableList.of());
            }
            case GABIPP_SHARED: {
                return DefaultStlSpecificationFactory.createSpec(abi, (List<String>)ImmutableList.of((Object)"gabi++/include"), "gabi++", (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"libgabi++_shared.so"));
            }
            case GABIPP_STATIC: {
                return DefaultStlSpecificationFactory.createSpec(abi, (List<String>)ImmutableList.of((Object)"gabi++/include"), "gabi++", (List<String>)ImmutableList.of((Object)"libgabi++_static.a"), (List<String>)ImmutableList.of());
            }
            case CPP_SHARED: {
                return DefaultStlSpecificationFactory.createSpec(abi, this.getLibcxxIncludes(abi), "llvm-libc++", this.getLibcxxStaticLibs(abi, false), (List<String>)ImmutableList.of((Object)"libc++_shared.so"));
            }
            case CPP_STATIC: {
                return DefaultStlSpecificationFactory.createSpec(abi, this.getLibcxxIncludes(abi), "llvm-libc++", this.getLibcxxStaticLibs(abi, true), (List<String>)ImmutableList.of());
            }
        }
        throw new RuntimeException("Unreachable.  Unknown STL: " + (Object)((Object)stl) + ".");
    }

    protected static StlSpecification createSpec(Abi abi, List<String> includes, String libPath, List<String> staticLibs, List<String> sharedLibs) {
        String base = "sources/cxx-stl";
        return new StlSpecification(includes.stream().map(include -> FileUtils.join((String[])new String[]{base, include})).collect(Collectors.toList()), staticLibs.stream().map(lib -> FileUtils.join((String[])new String[]{base, libPath, "libs", abi.getName(), lib})).collect(Collectors.toList()), sharedLibs.stream().map(lib -> FileUtils.join((String[])new String[]{base, libPath, "libs", abi.getName(), lib})).collect(Collectors.toList()));
    }

    protected List<String> getLibcxxIncludes(Abi abi) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"llvm-libc++/libcxx/include");
        if (abi == Abi.ARMEABI || abi == Abi.ARMEABI_V7A || abi == Abi.ARM64_V8A) {
            builder.add((Object)"llvm-libc++abi/libcxxabi/include");
        } else {
            builder.add((Object)"gabi++/include");
        }
        builder.add((Object)"../android/support/include");
        return builder.build();
    }

    protected List<String> getLibcxxStaticLibs(Abi abi, boolean staticStl) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (staticStl) {
            builder.add((Object)"libc++_static.a");
        }
        if (abi == Abi.ARMEABI) {
            builder.add((Object)"libatomic.a");
        }
        return builder.build();
    }
}

