/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactImpl;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.scope.CodeShrinker;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantFactory;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.CheckTestedAppObfuscation;
import com.android.build.gradle.tasks.ManifestProcessorTask;
import com.android.build.gradle.tasks.ProcessTestManifest;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.profile.Recorder;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class TestApplicationTaskManager
extends ApplicationTaskManager {
    private FileCollection mTargetManifestConfiguration = null;

    public TestApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        super.createTasksForVariantScope(variantScope);
        Configuration testedApksConfig = this.project.getConfigurations().getByName(TestVariantFactory.getTestedApksConfigurationName(variantScope.getFullVariantName()));
        FileCollection testingApk = variantScope.getOutput(InternalArtifactType.APK);
        FileCollection testedApks = testedApksConfig.getIncoming().artifactView(config2 -> {
            ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType()));
        }).getFiles();
        FileCollection testedManifestMetadata = this.getTestedManifestMetadata(variantScope.getVariantData());
        TestApplicationTestData testData = new TestApplicationTestData(variantScope.getVariantConfiguration(), variantScope.getVariantData().getApplicationId(), testingApk, testedApks);
        this.configureTestData(testData);
        DeviceProviderInstrumentTestTask instrumentTestTask = this.taskFactory.create(new DeviceProviderInstrumentTestTask.ConfigAction(variantScope, (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.extension.getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.getLogger())), testData, testedManifestMetadata){

            @Override
            public String getName() {
                return super.getName() + "AndroidTest";
            }
        });
        Task connectedAndroidTest = this.taskFactory.findByName("connectedAndroidTest");
        if (connectedAndroidTest != null) {
            connectedAndroidTest.dependsOn(new Object[]{instrumentTestTask.getName()});
        }
    }

    @Override
    protected void postJavacCreation(VariantScope scope) {
    }

    @Override
    public void createLintTasks(VariantScope scope) {
    }

    @Override
    public void createGlobalLintTask() {
    }

    @Override
    public void configureGlobalLintTask(Collection<VariantScope> variants) {
    }

    @Override
    protected boolean isTestedAppObfuscated(VariantScope variantScope) {
        return variantScope.getCodeShrinker() == CodeShrinker.PROGUARD || variantScope.getCodeShrinker() == CodeShrinker.R8;
    }

    @Override
    protected CodeShrinker maybeCreateJavaCodeShrinkerTransform(VariantScope variantScope) {
        if (this.isTestedAppObfuscated(variantScope)) {
            return this.doCreateJavaCodeShrinkerTransform(variantScope, Objects.requireNonNull(variantScope.getCodeShrinker()), variantScope.getArtifactFileCollection(AndroidArtifacts.ConsumedConfigType.COMPILE_CLASSPATH, AndroidArtifacts.ArtifactScope.ALL, AndroidArtifacts.ArtifactType.APK_MAPPING));
        }
        CheckTestedAppObfuscation checkObfuscation = this.taskFactory.create(new CheckTestedAppObfuscation.ConfigAction(variantScope));
        Preconditions.checkNotNull((Object)variantScope.getJavacTask());
        variantScope.getJavacTask().dependsOn(new Object[]{checkObfuscation});
        return null;
    }

    private FileCollection getTestedManifestMetadata(BaseVariantData variantData) {
        if (this.mTargetManifestConfiguration == null) {
            this.mTargetManifestConfiguration = variantData.getVariantDependency().getCompileClasspath().getIncoming().artifactView(config2 -> {
                ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.MANIFEST_METADATA.getType()));
            }).getFiles();
        }
        return this.mTargetManifestConfiguration;
    }

    @Override
    protected ManifestProcessorTask createMergeManifestTask(VariantScope variantScope) {
        return this.taskFactory.create(new ProcessTestManifest.ConfigAction(variantScope, new BuildableArtifactImpl(this.getTestedManifestMetadata(variantScope.getVariantData()), variantScope.getGlobalScope().getDslScope())));
    }

    @Override
    protected DefaultTask createVariantPreBuildTask(VariantScope scope) {
        return this.createDefaultPreBuildTask(scope);
    }
}

