/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.res.namespaced;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.namespaced.DependenciesGraph;
import com.android.build.gradle.internal.res.namespaced.NamespaceRewriter;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidBuilderTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010$\u001a\u00020%H\u0007J\b\u0010&\u001a\u00020%H\u0007J\b\u0010\u001e\u001a\u00020%H\u0007J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0(2\u0006\u0010)\u001a\u00020*H\u0002J0\u0010+\u001a\u00020,2\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010-\u001a\u00020\u0017H\u0007J\u0018\u0010.\u001a\u00020,2\u0006\u0010/\u001a\u00020*2\u0006\u0010-\u001a\u00020\u0017H\u0002J\b\u00100\u001a\u00020,H\u0007J\u0018\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u001702*\u00020\nH\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR&\u0010\u0010\u001a\u0004\u0018\u00010\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u00178\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\r\"\u0004\b\u001f\u0010\u000fR*\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"0!j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\"`#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/AutoNamespaceDependenciesTask;", "Lcom/android/build/gradle/internal/tasks/AndroidBuilderTask;", "()V", "<set-?>", "Lorg/gradle/api/artifacts/ResolvableDependencies;", "dependencies", "getDependencies", "()Lorg/gradle/api/artifacts/ResolvableDependencies;", "setDependencies", "(Lorg/gradle/api/artifacts/ResolvableDependencies;)V", "Lorg/gradle/api/artifacts/ArtifactCollection;", "jarFiles", "getJarFiles", "()Lorg/gradle/api/artifacts/ArtifactCollection;", "setJarFiles", "(Lorg/gradle/api/artifacts/ArtifactCollection;)V", "log", "Lorg/gradle/api/logging/Logger;", "log$annotations", "getLog", "()Lorg/gradle/api/logging/Logger;", "setLog", "(Lorg/gradle/api/logging/Logger;)V", "Ljava/io/File;", "outputRewrittenClasses", "getOutputRewrittenClasses", "()Ljava/io/File;", "setOutputRewrittenClasses", "(Ljava/io/File;)V", "rFiles", "getRFiles", "setRFiles", "symbolTablesCache", "Ljava/util/HashMap;", "Lcom/android/ide/common/symbols/SymbolTable;", "Lkotlin/collections/HashMap;", "getClassesJarFiles", "Lorg/gradle/api/file/FileCollection;", "getDependenciesFiles", "getSymbolTables", "Lcom/google/common/collect/ImmutableList;", "node", "Lcom/android/build/gradle/internal/res/namespaced/DependenciesGraph$Node;", "namespaceDependencies", "", "outputDirectory", "namespaceDependency", "dependency", "taskAction", "toMap", "Lcom/google/common/collect/ImmutableMap;", "", "ConfigAction", "gradle-core"})
public class AutoNamespaceDependenciesTask
extends AndroidBuilderTask {
    @NotNull
    private ArtifactCollection rFiles;
    @NotNull
    private ArtifactCollection jarFiles;
    @NotNull
    private ResolvableDependencies dependencies;
    @Nullable
    private Logger log;
    private HashMap<File, SymbolTable> symbolTablesCache = new HashMap();
    @NotNull
    private File outputRewrittenClasses;

    @NotNull
    public final ArtifactCollection getRFiles() {
        ArtifactCollection artifactCollection = this.rFiles;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rFiles");
        }
        return artifactCollection;
    }

    private final void setRFiles(ArtifactCollection artifactCollection) {
        this.rFiles = artifactCollection;
    }

    @NotNull
    public final ArtifactCollection getJarFiles() {
        ArtifactCollection artifactCollection = this.jarFiles;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jarFiles");
        }
        return artifactCollection;
    }

    private final void setJarFiles(ArtifactCollection artifactCollection) {
        this.jarFiles = artifactCollection;
    }

    @NotNull
    public final ResolvableDependencies getDependencies() {
        ResolvableDependencies resolvableDependencies = this.dependencies;
        if (resolvableDependencies == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        }
        return resolvableDependencies;
    }

    private final void setDependencies(ResolvableDependencies resolvableDependencies) {
        this.dependencies = resolvableDependencies;
    }

    @InputFiles
    @NotNull
    public final FileCollection getRFiles() {
        ArtifactCollection artifactCollection = this.rFiles;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rFiles");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"rFiles.artifactFiles");
        return fileCollection;
    }

    @InputFiles
    @NotNull
    public final FileCollection getClassesJarFiles() {
        ArtifactCollection artifactCollection = this.jarFiles;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jarFiles");
        }
        FileCollection fileCollection = artifactCollection.getArtifactFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"jarFiles.artifactFiles");
        return fileCollection;
    }

    @InputFiles
    @NotNull
    public final FileCollection getDependenciesFiles() {
        ResolvableDependencies resolvableDependencies = this.dependencies;
        if (resolvableDependencies == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        }
        FileCollection fileCollection = resolvableDependencies.getFiles();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"dependencies.files");
        return fileCollection;
    }

    public static /* synthetic */ void log$annotations() {
    }

    @Nullable
    public final Logger getLog() {
        return this.log;
    }

    public final void setLog(@Nullable Logger logger) {
        this.log = logger;
    }

    @OutputDirectory
    @NotNull
    public final File getOutputRewrittenClasses() {
        File file = this.outputRewrittenClasses;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputRewrittenClasses");
        }
        return file;
    }

    private final void setOutputRewrittenClasses(File file) {
        this.outputRewrittenClasses = file;
    }

    @TaskAction
    public final void taskAction() {
        AutoNamespaceDependenciesTask.namespaceDependencies$default(this, null, null, null, null, 15, null);
    }

    public final void namespaceDependencies(@NotNull ResolvableDependencies dependencies, @NotNull ArtifactCollection rFiles, @NotNull ArtifactCollection jarFiles, @NotNull File outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
        Intrinsics.checkParameterIsNotNull((Object)rFiles, (String)"rFiles");
        Intrinsics.checkParameterIsNotNull((Object)jarFiles, (String)"jarFiles");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        ImmutableMap immutableMap = ImmutableMap.of((Object)((Object)AndroidArtifacts.ArtifactType.DEFINED_ONLY_SYMBOL_LIST), this.toMap(rFiles), (Object)((Object)AndroidArtifacts.ArtifactType.NON_NAMESPACED_CLASSES), this.toMap(jarFiles));
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.of(\n       \u2026toMap()\n                )");
        DependenciesGraph graph = DependenciesGraph.Companion.create(dependencies, (Map)immutableMap);
        UnmodifiableIterator unmodifiableIterator = graph.getAllNodes().iterator();
        while (unmodifiableIterator.hasNext()) {
            DependenciesGraph.Node dependency;
            DependenciesGraph.Node node = dependency = (DependenciesGraph.Node)unmodifiableIterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)node, (String)"dependency");
            this.namespaceDependency(node, outputDirectory);
        }
        this.symbolTablesCache.clear();
    }

    public static /* bridge */ /* synthetic */ void namespaceDependencies$default(AutoNamespaceDependenciesTask autoNamespaceDependenciesTask, ResolvableDependencies resolvableDependencies, ArtifactCollection artifactCollection, ArtifactCollection artifactCollection2, File file, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: namespaceDependencies");
        }
        if ((n & 1) != 0) {
            ResolvableDependencies resolvableDependencies2 = autoNamespaceDependenciesTask.dependencies;
            if (resolvableDependencies2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
            }
            resolvableDependencies = resolvableDependencies2;
        }
        if ((n & 2) != 0) {
            ArtifactCollection artifactCollection3 = autoNamespaceDependenciesTask.rFiles;
            if (artifactCollection3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"rFiles");
            }
            artifactCollection = artifactCollection3;
        }
        if ((n & 4) != 0) {
            ArtifactCollection artifactCollection4 = autoNamespaceDependenciesTask.jarFiles;
            if (artifactCollection4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"jarFiles");
            }
            artifactCollection2 = artifactCollection4;
        }
        if ((n & 8) != 0) {
            File file2 = autoNamespaceDependenciesTask.outputRewrittenClasses;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputRewrittenClasses");
            }
            file = file2;
        }
        autoNamespaceDependenciesTask.namespaceDependencies(resolvableDependencies, artifactCollection, artifactCollection2, file);
    }

    private final void namespaceDependency(DependenciesGraph.Node dependency, File outputDirectory) {
        File input = dependency.getFile(AndroidArtifacts.ArtifactType.NON_NAMESPACED_CLASSES);
        if (!(dependency.getId() instanceof ProjectComponentIdentifier) && input != null) {
            File out = new File(outputDirectory, "namespaced-" + dependency.getId().getDisplayName() + '-' + input.getName());
            ImmutableList<SymbolTable> symbolTables = this.getSymbolTables(dependency);
            Logger logger = this.log;
            if (logger == null) {
                Logger logger2 = this.getLogger();
                logger = logger2;
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
            }
            new NamespaceRewriter(symbolTables, logger).rewriteJar(input, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ImmutableList<SymbolTable> getSymbolTables(DependenciesGraph.Node node) {
        HashMap<File, SymbolTable> hashMap = this.symbolTablesCache;
        synchronized (hashMap) {
            ImmutableList.Builder builder = ImmutableList.builder();
            UnmodifiableIterator unmodifiableIterator = node.getTransitiveFiles(AndroidArtifacts.ArtifactType.DEFINED_ONLY_SYMBOL_LIST).iterator();
            while (unmodifiableIterator.hasNext()) {
                Map map = this.symbolTablesCache;
                Map map2 = map;
                File rFile = (File)unmodifiableIterator.next();
                if (!map2.containsKey(rFile)) {
                    SymbolTable table = SymbolIo.readTableWithPackage((File)rFile);
                    this.symbolTablesCache.put(rFile, table);
                }
                SymbolTable symbolTable = this.symbolTablesCache.get(rFile);
                if (symbolTable == null) {
                    Intrinsics.throwNpe();
                }
                builder.add((Object)symbolTable);
            }
            ImmutableList immutableList = builder.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)immutableList, (String)"builder.build()");
            ImmutableList immutableList2 = immutableList;
            return immutableList2;
        }
    }

    private final ImmutableMap<String, File> toMap(@NotNull ArtifactCollection $receiver) {
        ImmutableMap.Builder builder;
        ImmutableMap.Builder $receiver2 = builder = ImmutableMap.builder();
        Iterator iterator = $receiver.getArtifacts().iterator();
        while (iterator.hasNext()) {
            ResolvedArtifactResult artifact;
            ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentIdentifier, (String)"artifact.id.componentIdentifier");
            $receiver2.put((Object)componentIdentifier.getDisplayName(), (Object)artifact.getFile());
        }
        ImmutableMap immutableMap = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)immutableMap, (String)"ImmutableMap.builder<Str\u2026      }\n        }.build()");
        return immutableMap;
    }

    @NotNull
    public static final /* synthetic */ ArtifactCollection access$getRFiles$p(AutoNamespaceDependenciesTask $this) {
        ArtifactCollection artifactCollection = $this.rFiles;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rFiles");
        }
        return artifactCollection;
    }

    @NotNull
    public static final /* synthetic */ ArtifactCollection access$getJarFiles$p(AutoNamespaceDependenciesTask $this) {
        ArtifactCollection artifactCollection = $this.jarFiles;
        if (artifactCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"jarFiles");
        }
        return artifactCollection;
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputRewrittenClasses$p(AutoNamespaceDependenciesTask $this) {
        File file = $this.outputRewrittenClasses;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputRewrittenClasses");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ ResolvableDependencies access$getDependencies$p(AutoNamespaceDependenciesTask $this) {
        ResolvableDependencies resolvableDependencies = $this.dependencies;
        if (resolvableDependencies == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dependencies");
        }
        return resolvableDependencies;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/res/namespaced/AutoNamespaceDependenciesTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/res/namespaced/AutoNamespaceDependenciesTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle-core"})
    public static final class ConfigAction
    implements TaskConfigAction<AutoNamespaceDependenciesTask> {
        private final VariantScope variantScope;

        @Override
        @NotNull
        public String getName() {
            String string = this.variantScope.getTaskName("AutoNamespace", "Dependencies");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variantScope.getTaskName\u2026mespace\", \"Dependencies\")");
            return string;
        }

        @Override
        @NotNull
        public Class<AutoNamespaceDependenciesTask> getType() {
            return AutoNamespaceDependenciesTask.class;
        }

        @Override
        public void execute(@NotNull AutoNamespaceDependenciesTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            ArtifactCollection artifactCollection = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.DEFINED_ONLY_SYMBOL_LIST);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"variantScope.getArtifact\u2026SYMBOL_LIST\n            )");
            task.rFiles = artifactCollection;
            ArtifactCollection artifactCollection2 = this.variantScope.getArtifactCollection(AndroidArtifacts.ConsumedConfigType.RUNTIME_CLASSPATH, AndroidArtifacts.ArtifactScope.EXTERNAL, AndroidArtifacts.ArtifactType.NON_NAMESPACED_CLASSES);
            Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection2, (String)"variantScope.getArtifact\u2026CED_CLASSES\n            )");
            task.jarFiles = artifactCollection2;
            GlobalScope globalScope = this.variantScope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"variantScope.globalScope");
            File file = globalScope.getIntermediatesDir();
            String[] stringArray = new String[2];
            stringArray[0] = "namespaced-classes-jars";
            GradleVariantConfiguration gradleVariantConfiguration = this.variantScope.getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            stringArray[1] = gradleVariantConfiguration.getDirName();
            File file2 = FileUtils.join((File)file, (String[])stringArray);
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"FileUtils.join(\n        \u2026ion.dirName\n            )");
            task.outputRewrittenClasses = file2;
            BaseVariantData baseVariantData = this.variantScope.getVariantData();
            Intrinsics.checkExpressionValueIsNotNull((Object)baseVariantData, (String)"variantScope.variantData");
            VariantDependencies variantDependencies = baseVariantData.getVariantDependency();
            Intrinsics.checkExpressionValueIsNotNull((Object)variantDependencies, (String)"variantScope.variantData.variantDependency");
            Configuration configuration = variantDependencies.getRuntimeClasspath();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"variantScope.variantData\u2026pendency.runtimeClasspath");
            ResolvableDependencies resolvableDependencies = configuration.getIncoming();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"variantScope.variantData\u2026runtimeClasspath.incoming");
            task.dependencies = resolvableDependencies;
        }

        public ConfigAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            this.variantScope = variantScope;
        }
    }
}

