/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.transforms.LibraryBaseTransform;
import com.android.builder.packaging.JarMerger;
import com.android.builder.packaging.TypedefRemover;
import com.android.builder.packaging.ZipEntryFilter;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class LibraryIntermediateJarsTransform
extends LibraryBaseTransform {
    private static final Pattern CLASS_PATTERN = Pattern.compile(".*\\.class$");
    private static final Pattern META_INF_PATTERN = Pattern.compile("^META-INF/.*$");
    private final File resJarLocation;

    public LibraryIntermediateJarsTransform(File mainClassLocation, File resJarLocation, BuildableArtifact typedefRecipe, String packageName, boolean packageBuildConfig) {
        super(mainClassLocation, null, typedefRecipe, packageName, packageBuildConfig);
        this.resJarLocation = resJarLocation;
    }

    public String getName() {
        return "prepareIntermediateJars";
    }

    public Collection<File> getSecondaryFileOutputs() {
        return ImmutableList.of((Object)this.mainClassLocation, (Object)this.resJarLocation);
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(TransformInvocation invocation) throws TransformException, InterruptedException, IOException {
        if (this.typedefRecipe != null && !((File)Iterables.getOnlyElement((Iterable)this.typedefRecipe)).exists()) {
            throw new IllegalStateException("Type def recipe not found: " + this.typedefRecipe);
        }
        boolean incrementalDisabled = !invocation.isIncremental();
        List<Pattern> excludePatterns = this.computeExcludeList();
        boolean mainClassInputChanged = incrementalDisabled;
        ArrayList<Object> mainClassInputs = new ArrayList<Object>();
        boolean resJarInputChanged = incrementalDisabled;
        ArrayList<Object> resJarInputs = new ArrayList<Object>();
        for (TransformInput input : invocation.getReferencedInputs()) {
            boolean changed;
            for (JarInput jarInput : input.getJarInputs()) {
                boolean bl = changed = jarInput.getStatus() != Status.NOTCHANGED;
                if (jarInput.getContentTypes().contains(QualifiedContent.DefaultContentType.RESOURCES)) {
                    resJarInputs.add(jarInput);
                    resJarInputChanged |= changed;
                }
                if (!jarInput.getContentTypes().contains(QualifiedContent.DefaultContentType.CLASSES)) continue;
                mainClassInputs.add(jarInput);
                mainClassInputChanged |= changed;
            }
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                boolean bl = changed = !dirInput.getChangedFiles().isEmpty();
                if (dirInput.getContentTypes().contains(QualifiedContent.DefaultContentType.RESOURCES)) {
                    resJarInputs.add(dirInput);
                    resJarInputChanged |= changed;
                }
                if (!dirInput.getContentTypes().contains(QualifiedContent.DefaultContentType.CLASSES)) continue;
                mainClassInputs.add(dirInput);
                mainClassInputChanged |= changed;
            }
        }
        WaitableExecutor executor = WaitableExecutor.useGlobalSharedThreadPool();
        if (mainClassInputChanged) {
            executor.execute(() -> {
                this.handleMainClass(mainClassInputs, excludePatterns);
                return null;
            });
        }
        if (resJarInputChanged) {
            executor.execute(() -> {
                this.handleMainRes(resJarInputs);
                return null;
            });
        }
        executor.waitForTasksWithQuickFail(true);
    }

    private void handleMainClass(List<QualifiedContent> mainClassInputs, List<Pattern> excludePatterns) throws IOException {
        FileUtils.deleteIfExists((File)this.mainClassLocation);
        FileUtils.mkdirs((File)this.mainClassLocation.getParentFile());
        ZipEntryFilter filter = archivePath -> (CLASS_PATTERN.matcher(archivePath).matches() || META_INF_PATTERN.matcher(archivePath).matches()) && LibraryIntermediateJarsTransform.checkEntry(excludePatterns, archivePath);
        TypedefRemover typedefRemover = this.typedefRecipe != null ? new TypedefRemover().setTypedefFile((File)Iterables.getOnlyElement((Iterable)this.typedefRecipe)) : null;
        LibraryIntermediateJarsTransform.handleJarOutput(mainClassInputs, this.mainClassLocation, filter, typedefRemover);
    }

    private void handleMainRes(List<QualifiedContent> resJarInputs) throws IOException {
        FileUtils.deleteIfExists((File)this.resJarLocation);
        FileUtils.mkdirs((File)this.resJarLocation.getParentFile());
        ZipEntryFilter filter = archivePath -> !CLASS_PATTERN.matcher(archivePath).matches();
        LibraryIntermediateJarsTransform.handleJarOutput(resJarInputs, this.resJarLocation, filter, null);
    }

    private static void handleJarOutput(List<QualifiedContent> inputs, File toFile, ZipEntryFilter filter, TypedefRemover typedefRemover) throws IOException {
        if (inputs.size() == 1) {
            QualifiedContent content2 = inputs.get(0);
            if (content2 instanceof JarInput) {
                LibraryIntermediateJarsTransform.copyJarWithContentFilter(content2.getFile(), toFile, filter);
            } else {
                LibraryIntermediateJarsTransform.jarFolderToLocation(content2.getFile(), toFile, filter, (JarMerger.Transformer)typedefRemover);
            }
        } else {
            LibraryIntermediateJarsTransform.mergeInputsToLocation(inputs, toFile, true, filter, (JarMerger.Transformer)typedefRemover);
        }
    }
}

