/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.aapt.AaptGeneration;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.DslAdaptersKt;
import com.android.build.gradle.internal.incremental.BuildInfoWriterTask;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.publishing.AndroidArtifacts;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TaskOutputHolder;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AppPreBuildTask;
import com.android.build.gradle.internal.tasks.ApplicationIdWriterTask;
import com.android.build.gradle.internal.tasks.BundleTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.TestPreBuildTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureApplicationIdsTask;
import com.android.build.gradle.internal.tasks.databinding.DataBindingExportFeatureInfoTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadataWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitDeclarationWriterTask;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSplitTransitiveDepsWriterTask;
import com.android.build.gradle.internal.transforms.InstantRunDependenciesApkBuilder;
import com.android.build.gradle.internal.transforms.InstantRunSliceSplitApkBuilder;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.options.OptionalBooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.tasks.MainApkListPersistence;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.profile.Recorder;
import com.android.ide.common.build.ApkInfo;
import com.android.utils.FileUtils;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import java.io.File;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class ApplicationTaskManager
extends TaskManager {
    public ApplicationTaskManager(GlobalScope globalScope, Project project, ProjectOptions projectOptions, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, ToolingModelBuilderRegistry toolingRegistry, Recorder recorder) {
        super(globalScope, project, projectOptions, androidBuilder, dataBindingBuilder, extension, sdkHandler, toolingRegistry, recorder);
    }

    @Override
    public void createTasksForVariantScope(VariantScope variantScope) {
        BaseVariantData variantData = variantScope.getVariantData();
        this.createAnchorTasks(variantScope);
        this.createCheckManifestTask(variantScope);
        this.handleMicroApp(variantScope);
        this.createDependencyStreams(variantScope);
        this.createApplicationIdWriterTask(variantScope);
        this.taskFactory.create(new MainApkListPersistence.ConfigAction(variantScope));
        this.createBuildArtifactReportTask(variantScope);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_MANIFEST_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeApkManifestsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_GENERATE_RES_VALUES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createGenerateResValuesTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_CREATE_RENDERSCRIPT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createRenderscriptTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_RESOURCES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeResourcesTask(variantScope, true));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SHADER_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createShaderTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_ASSETS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeAssetsTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_BUILD_CONFIG_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createBuildConfigTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PROCESS_RES_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createApkProcessResTask(variantScope);
            this.createProcessJavaResTask(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_AIDL_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createAidlTask(variantScope));
        if (!this.isComponentModelPlugin()) {
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_NDK_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createNdkTasks(variantScope));
        } else if (variantData.compileTask != null) {
            variantData.compileTask.dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        } else {
            variantScope.getCompileTask().dependsOn(new Object[]{this.getNdkBuildable(variantData)});
        }
        variantScope.setNdkBuildable(this.getNdkBuildable(variantData));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_EXTERNAL_NATIVE_BUILD_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            this.createExternalNativeBuildJsonGenerators(variantScope);
            this.createExternalNativeBuildTasks(variantScope);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_MERGE_JNILIBS_FOLDERS_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createMergeJniLibFoldersTasks(variantScope));
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.create(new FeatureSetMetadataWriterTask.ConfigAction(variantScope));
            if (this.extension.getDataBinding().isEnabled()) {
                this.taskFactory.create(new DataBindingExportFeatureApplicationIdsTask.ConfigAction(variantScope));
            }
        } else {
            this.taskFactory.create(new FeatureSplitDeclarationWriterTask.ConfigAction(variantScope));
            if (this.extension.getDataBinding().isEnabled()) {
                this.taskFactory.create(new DataBindingExportFeatureInfoTask.ConfigAction(variantScope));
            }
        }
        this.createDataBindingTasksIfNecessary(variantScope, TaskManager.MergeType.MERGE);
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_COMPILE_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createCompileTask(variantScope));
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_STRIP_NATIVE_LIBRARY_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> ApplicationTaskManager.createStripNativeLibraryTask(this.taskFactory, variantScope));
        if (variantScope.getVariantData().getMultiOutputPolicy().equals((Object)MultiOutputPolicy.SPLITS)) {
            if (this.extension.getBuildToolsRevision().getMajor() < 21) {
                throw new RuntimeException("Pure splits can only be used with buildtools 21 and later");
            }
            this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_SPLIT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createSplitTasks(variantScope));
        }
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_PACKAGING_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> {
            BuildInfoWriterTask buildInfoWriterTask = this.createInstantRunPackagingTasks(variantScope);
            this.createPackagingTask(variantScope, buildInfoWriterTask);
        });
        this.recorder.record(GradleBuildProfileSpan.ExecutionType.APP_TASK_MANAGER_CREATE_LINT_TASK, this.project.getPath(), variantScope.getFullVariantName(), () -> this.createLintTasks(variantScope));
        this.createTransitiveDepsTask(variantScope);
        this.createDynamicBundleTask(variantScope);
    }

    private BuildInfoWriterTask createInstantRunPackagingTasks(VariantScope variantScope) {
        if (!variantScope.getInstantRunBuildContext().isInInstantRunMode() || variantScope.getInstantRunTaskManager() == null) {
            return null;
        }
        BuildInfoWriterTask buildInfoGeneratorTask = this.taskFactory.create(new BuildInfoWriterTask.ConfigAction(variantScope, this.getLogger()));
        variantScope.getInstantRunTaskManager().configureBuildInfoWriterTask(buildInfoGeneratorTask, new Task[0]);
        InternalArtifactType resourcesWithMainManifest = variantScope.getInstantRunBuildContext().useSeparateApkForResources() ? InternalArtifactType.INSTANT_RUN_MAIN_APK_RESOURCES : InternalArtifactType.PROCESSED_RES;
        InstantRunDependenciesApkBuilder dependenciesApkBuilder = new InstantRunDependenciesApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), Aapt2MavenUtils.getAapt2FromMavenIfEnabled(this.globalScope), variantScope.getVariantConfiguration().getApplicationId(), variantScope.getVariantConfiguration().getSigningConfig(), AaptGeneration.fromProjectOptions(this.projectOptions), DslAdaptersKt.convert(this.globalScope.getExtension().getAaptOptions()), new File(variantScope.getInstantRunSplitApkOutputFolder(), "dep"), new File(variantScope.getIncrementalDir("ir_dep"), variantScope.getDirName()), new File(ApplicationTaskManager.getIncrementalFolder(variantScope, "InstantRunDependenciesApkBuilder"), "aapt-temp"), variantScope.getOutput(InternalArtifactType.PROCESSED_RES), variantScope.getOutput(resourcesWithMainManifest), variantScope.getOutput(InternalArtifactType.APK_LIST), (ApkInfo)variantScope.getOutputScope().getMainSplit());
        Optional<TransformTask> dependenciesApkBuilderTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, dependenciesApkBuilder);
        dependenciesApkBuilderTask.ifPresent(task -> task.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)}));
        InstantRunSliceSplitApkBuilder slicesApkBuilder = new InstantRunSliceSplitApkBuilder(this.getLogger(), this.project, variantScope.getInstantRunBuildContext(), variantScope.getGlobalScope().getAndroidBuilder(), Aapt2MavenUtils.getAapt2FromMavenIfEnabled(this.globalScope), variantScope.getVariantConfiguration().getApplicationId(), variantScope.getVariantConfiguration().getSigningConfig(), AaptGeneration.fromProjectOptions(this.projectOptions), DslAdaptersKt.convert(this.globalScope.getExtension().getAaptOptions()), new File(variantScope.getInstantRunSplitApkOutputFolder(), "slices"), ApplicationTaskManager.getIncrementalFolder(variantScope, "ir_slices"), new File(ApplicationTaskManager.getIncrementalFolder(variantScope, "InstantRunSliceSplitApkBuilder"), "aapt-temp"), this.globalScope.getProjectOptions().get(OptionalBooleanOption.SERIAL_AAPT2), variantScope.getOutput(InternalArtifactType.PROCESSED_RES), variantScope.getOutput(resourcesWithMainManifest), variantScope.getOutput(InternalArtifactType.APK_LIST), (ApkInfo)variantScope.getOutputScope().getMainSplit());
        Optional<TransformTask> transformTaskAndroidTask = variantScope.getTransformManager().addTransform(this.taskFactory, variantScope, slicesApkBuilder);
        if (transformTaskAndroidTask.isPresent()) {
            TransformTask splitApk = transformTaskAndroidTask.get();
            splitApk.dependsOn(new Object[]{this.getValidateSigningTask(variantScope)});
            variantScope.getAssembleTask().dependsOn(new Object[]{splitApk});
            buildInfoGeneratorTask.mustRunAfter(new Object[]{splitApk.getName()});
        }
        variantScope.getAssembleTask().dependsOn(new Object[]{buildInfoGeneratorTask});
        return buildInfoGeneratorTask;
    }

    @Override
    protected void postJavacCreation(final VariantScope scope) {
        final BuildableArtifact javacOutput = scope.getBuildArtifactsHolder().getArtifactFiles(InternalArtifactType.JAVAC);
        final FileCollection preJavacGeneratedBytecode = scope.getVariantData().getAllPreJavacGeneratedBytecode();
        final FileCollection postJavacGeneratedBytecode = scope.getVariantData().getAllPostJavacGeneratedBytecode();
        this.taskFactory.create(new TaskConfigAction<Jar>(){

            @Override
            public String getName() {
                return scope.getTaskName("bundleAppClasses");
            }

            @Override
            public Class<Jar> getType() {
                return Jar.class;
            }

            @Override
            public void execute(Jar task) {
                File outputFile = scope.getBuildArtifactsHolder().appendArtifact((ArtifactType)InternalArtifactType.APP_CLASSES, (Task)task, "classes.jar");
                task.from(new Object[]{javacOutput});
                task.from(new Object[]{preJavacGeneratedBytecode});
                task.from(new Object[]{postJavacGeneratedBytecode});
                task.setDestinationDir(outputFile.getParentFile());
                task.setArchiveName(outputFile.getName());
            }
        });
        ConfigurableFileCollection fileCollection = scope.createAnchorOutput(TaskOutputHolder.AnchorOutputType.ALL_CLASSES);
        fileCollection.from(new Object[]{javacOutput});
        fileCollection.from(new Object[]{preJavacGeneratedBytecode});
        fileCollection.from(new Object[]{postJavacGeneratedBytecode});
    }

    @Override
    protected DefaultTask createVariantPreBuildTask(VariantScope scope) {
        VariantType variantType = scope.getVariantConfiguration().getType();
        if (variantType.isApk()) {
            if (variantType.isTestComponent()) {
                return this.taskFactory.create(new TestPreBuildTask.ConfigAction(scope));
            }
            return this.taskFactory.create(new AppPreBuildTask.ConfigAction(scope));
        }
        return super.createVariantPreBuildTask(scope);
    }

    @Override
    protected Set<? super QualifiedContent.Scope> getResMergingScopes(VariantScope variantScope) {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    private void handleMicroApp(VariantScope scope) {
        BaseVariantData variantData = scope.getVariantData();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        VariantType variantType = variantConfiguration.getType();
        if (!variantType.isHybrid() && variantType.isBaseModule()) {
            Boolean unbundledWearApp = variantConfiguration.getMergedFlavor().getWearAppUnbundled();
            if (!Boolean.TRUE.equals(unbundledWearApp) && ((CoreBuildType)variantConfiguration.getBuildType()).isEmbedMicroApp()) {
                Configuration wearApp = variantData.getVariantDependency().getWearAppConfiguration();
                assert (wearApp != null) : "Wear app with no wearApp configuration";
                if (!wearApp.getAllDependencies().isEmpty()) {
                    Action setApkArtifact = container -> container.attribute(AndroidArtifacts.ARTIFACT_TYPE, (Object)AndroidArtifacts.ArtifactType.APK.getType());
                    FileCollection files = wearApp.getIncoming().artifactView(config2 -> {
                        ArtifactView.ViewConfiguration cfr_ignored_0 = (ArtifactView.ViewConfiguration)config2.attributes(setApkArtifact);
                    }).getFiles();
                    this.createGenerateMicroApkDataTask(scope, files);
                }
            } else if (Boolean.TRUE.equals(unbundledWearApp)) {
                this.createGenerateMicroApkDataTask(scope, null);
            }
        }
    }

    private void createApplicationIdWriterTask(VariantScope variantScope) {
        if (variantScope.getType().isBaseModule()) {
            this.taskFactory.create(new ApplicationIdWriterTask.ConfigAction(variantScope));
        }
    }

    private static File getIncrementalFolder(VariantScope variantScope, String taskName) {
        return new File(variantScope.getIncrementalDir(taskName), variantScope.getDirName());
    }

    private void createTransitiveDepsTask(VariantScope scope) {
        File textFile = new File(FileUtils.join((File)this.globalScope.getIntermediatesDir(), (String[])new String[]{"feature-split", "transitive-deps", scope.getVariantConfiguration().getDirName()}), "deps.txt");
        FeatureSplitTransitiveDepsWriterTask task = this.taskFactory.create(new FeatureSplitTransitiveDepsWriterTask.ConfigAction(scope, textFile));
        scope.addTaskOutput(InternalArtifactType.FEATURE_TRANSITIVE_DEPS, textFile, task.getName());
    }

    private void createDynamicBundleTask(VariantScope scope) {
        if (Boolean.TRUE.equals(scope.getGlobalScope().getExtension().getAaptOptions().getNamespaced())) {
            return;
        }
        if (!scope.getType().isHybrid()) {
            this.taskFactory.create(new PerModuleBundleTask.ConfigAction(scope));
            if (scope.getType().isBaseModule()) {
                this.taskFactory.create(new BundleTask.ConfigAction(scope));
            }
        }
    }
}

