/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.build.OutputFile;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.dsl.SplitOptions;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class AbiSplitOptions
extends SplitOptions {
    private boolean universalApk = false;

    @Override
    protected Set<String> getDefaultValues() {
        HashSet values = Sets.newHashSet();
        for (Abi abi : NdkHandler.getDefaultAbiList()) {
            values.add(abi.getName());
        }
        return values;
    }

    @Override
    protected ImmutableSet<String> getAllowedValues() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Abi abi : NdkHandler.getAbiList()) {
            builder.add((Object)abi.getName());
        }
        return builder.build();
    }

    public boolean isUniversalApk() {
        return this.universalApk;
    }

    public void setUniversalApk(boolean universalApk) {
        this.universalApk = universalApk;
    }

    public static ImmutableSet<String> getAbiFilters(Set<String> allFilters) {
        ImmutableSet.Builder filters = ImmutableSet.builder();
        for (String abi : allFilters) {
            if (abi == OutputFile.NO_FILTER) continue;
            filters.add((Object)abi);
        }
        return filters.build();
    }
}

