/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.process;

import com.android.build.gradle.internal.process.GradleProcessResult;
import com.android.build.gradle.internal.process.OutputHandlerFailedGradleProcessResult;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;

public class GradleProcessExecutor
implements ProcessExecutor {
    private final Project project;

    public GradleProcessExecutor(Project project) {
        this.project = project;
    }

    public ListenableFuture<ProcessResult> submit(final ProcessInfo processInfo, final ProcessOutputHandler processOutputHandler2) {
        final SettableFuture res = SettableFuture.create();
        new Thread(){

            @Override
            public void run() {
                try {
                    ProcessResult result = GradleProcessExecutor.this.execute(processInfo, processOutputHandler2);
                    res.set((Object)result);
                }
                catch (Throwable e) {
                    res.setException(e);
                }
            }
        }.start();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult execute(ProcessInfo processInfo, ProcessOutputHandler processOutputHandler2) {
        ExecResult result;
        ProcessOutput output2 = processOutputHandler2.createOutput();
        try {
            result = this.project.exec((Action)new ExecAction(processInfo, output2));
        }
        finally {
            try {
                output2.close();
            }
            catch (IOException e) {
                this.project.getLogger().warn("Exception while closing sub process streams", (Throwable)e);
            }
        }
        try {
            processOutputHandler2.handleOutput(output2);
        }
        catch (ProcessException e) {
            return new OutputHandlerFailedGradleProcessResult(e);
        }
        return new GradleProcessResult(result, processInfo);
    }

    private static class ExecAction
    implements Action<ExecSpec> {
        private final ProcessInfo processInfo;
        private final ProcessOutput processOutput;

        ExecAction(ProcessInfo processInfo, ProcessOutput processOutput) {
            this.processInfo = processInfo;
            this.processOutput = processOutput;
        }

        public void execute(ExecSpec execSpec) {
            List args = this.processInfo.getArgs().stream().map(a -> a.isEmpty() ? "\"\"" : a).collect(Collectors.toList());
            execSpec.setExecutable(this.processInfo.getExecutable());
            execSpec.args(args);
            execSpec.environment(this.processInfo.getEnvironment());
            execSpec.setStandardOutput(this.processOutput.getStandardOutput());
            execSpec.setErrorOutput(this.processOutput.getErrorOutput());
            execSpec.setIgnoreExitValue(true);
        }
    }
}

