/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.scope.BuildArtifactsHolder;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AbiFilter;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.PerModuleBundleTask;
import com.android.build.gradle.internal.tasks.Relocator;
import com.android.build.gradle.internal.tasks.ResRelocator;
import com.android.build.gradle.internal.tasks.featuresplit.FeatureSetMetadata;
import com.android.builder.packaging.JarMerger;
import com.android.builder.packaging.ZipEntryFilter;
import com.android.utils.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010/\u001a\u0004\u0018\u000100H\u0002J\b\u00101\u001a\u00020)H\u0007R6\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR&\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0014\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000e\"\u0004\b\u001b\u0010\u0010R&\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010R&\u0010 \u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u001f8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R&\u0010%\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u000b8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000e\"\u0004\b'\u0010\u0010\u00a8\u00063"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "()V", "<set-?>", "", "", "abiFilters", "getAbiFilters", "()Ljava/util/Set;", "setAbiFilters", "(Ljava/util/Set;)V", "Lorg/gradle/api/file/FileCollection;", "assetsFiles", "getAssetsFiles", "()Lorg/gradle/api/file/FileCollection;", "setAssetsFiles", "(Lorg/gradle/api/file/FileCollection;)V", "dexFiles", "getDexFiles", "setDexFiles", "fileName", "getFileName", "()Ljava/lang/String;", "fileNameSupplier", "Ljava/util/function/Supplier;", "javaResFiles", "getJavaResFiles", "setJavaResFiles", "nativeLibsFiles", "getNativeLibsFiles", "setNativeLibsFiles", "Ljava/io/File;", "outputDir", "getOutputDir", "()Ljava/io/File;", "setOutputDir", "(Ljava/io/File;)V", "resFiles", "getResFiles", "setResFiles", "addHybridFolder", "", "jarMerger", "Lcom/android/builder/packaging/JarMerger;", "files", "relocator", "Lcom/android/build/gradle/internal/tasks/Relocator;", "fileFilter", "Lcom/android/builder/packaging/ZipEntryFilter;", "zip", "ConfigAction", "gradle-core"})
public class PerModuleBundleTask
extends AndroidVariantTask {
    @NotNull
    private File outputDir;
    @NotNull
    private FileCollection dexFiles;
    @NotNull
    private FileCollection resFiles;
    @NotNull
    private FileCollection javaResFiles;
    @NotNull
    private FileCollection assetsFiles;
    @NotNull
    private FileCollection nativeLibsFiles;
    @Nullable
    private Set<String> abiFilters;
    private Supplier<String> fileNameSupplier;

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final File getOutputDir() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    private final void setOutputDir(File file) {
        this.outputDir = file;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getDexFiles() {
        FileCollection fileCollection = this.dexFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dexFiles");
        }
        return fileCollection;
    }

    private final void setDexFiles(FileCollection fileCollection) {
        this.dexFiles = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getResFiles() {
        FileCollection fileCollection = this.resFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resFiles");
        }
        return fileCollection;
    }

    private final void setResFiles(FileCollection fileCollection) {
        this.resFiles = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getJavaResFiles() {
        FileCollection fileCollection = this.javaResFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaResFiles");
        }
        return fileCollection;
    }

    private final void setJavaResFiles(FileCollection fileCollection) {
        this.javaResFiles = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getAssetsFiles() {
        FileCollection fileCollection = this.assetsFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetsFiles");
        }
        return fileCollection;
    }

    private final void setAssetsFiles(FileCollection fileCollection) {
        this.assetsFiles = fileCollection;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final FileCollection getNativeLibsFiles() {
        FileCollection fileCollection = this.nativeLibsFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeLibsFiles");
        }
        return fileCollection;
    }

    private final void setNativeLibsFiles(FileCollection fileCollection) {
        this.nativeLibsFiles = fileCollection;
    }

    @Input
    @Optional
    @Nullable
    public final Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    private final void setAbiFilters(Set<String> set) {
        this.abiFilters = set;
    }

    @Input
    @NotNull
    public final String getFileName() {
        Supplier<String> supplier = this.fileNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileNameSupplier");
        }
        String string = supplier.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileNameSupplier.get()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void zip() {
        File file = this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        FileUtils.cleanOutputDir((File)file);
        File file2 = this.outputDir;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        JarMerger jarMerger = new JarMerger(new File(file2, this.getFileName()).toPath());
        Set<String> filters = this.abiFilters;
        AbiFilter abiFilter = filters != null ? new AbiFilter(filters) : null;
        Closeable closeable = (Closeable)jarMerger;
        Throwable throwable = null;
        try {
            JarMerger it = (JarMerger)closeable;
            FileCollection fileCollection = this.assetsFiles;
            if (fileCollection == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"assetsFiles");
            }
            it.addDirectory(fileCollection.getSingleFile().toPath(), null, null, (JarMerger.Relocator)new Relocator("assets"));
            FileCollection fileCollection2 = this.resFiles;
            if (fileCollection2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resFiles");
            }
            it.addJar(fileCollection2.getSingleFile().toPath(), null, (JarMerger.Relocator)new ResRelocator());
            FileCollection fileCollection3 = this.dexFiles;
            if (fileCollection3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dexFiles");
            }
            Set set = fileCollection3.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"dexFiles.files");
            PerModuleBundleTask.addHybridFolder$default(this, it, set, new Relocator("dex"), null, 8, null);
            FileCollection fileCollection4 = this.javaResFiles;
            if (fileCollection4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"javaResFiles");
            }
            Set set2 = fileCollection4.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"javaResFiles.files");
            this.addHybridFolder(it, set2, new Relocator("root"), ZipEntryFilter.EXCLUDE_CLASSES);
            FileCollection fileCollection5 = this.nativeLibsFiles;
            if (fileCollection5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"nativeLibsFiles");
            }
            Set set3 = fileCollection5.getFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"nativeLibsFiles.files");
            PerModuleBundleTask.addHybridFolder$default(this, it, set3, null, abiFilter, 4, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void addHybridFolder(JarMerger jarMerger, Set<? extends File> files, Relocator relocator, ZipEntryFilter fileFilter) {
        for (File file : files) {
            if (file.isFile()) {
                String string = file.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
                if (StringsKt.endsWith$default((String)string, (String)".jar", (boolean)false, (int)2, null)) {
                    jarMerger.addJar(file.toPath(), fileFilter, (JarMerger.Relocator)relocator);
                    continue;
                }
                if (fileFilter != null && !fileFilter.checkEntry(file.getName())) continue;
                if (relocator != null) {
                    String string2 = file.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.name");
                    jarMerger.addFile(relocator.relocate(string2), file.toPath());
                    continue;
                }
                jarMerger.addFile(file.getName(), file.toPath());
                continue;
            }
            jarMerger.addDirectory(file.toPath(), fileFilter, null, (JarMerger.Relocator)relocator);
        }
    }

    static /* bridge */ /* synthetic */ void addHybridFolder$default(PerModuleBundleTask perModuleBundleTask, JarMerger jarMerger, Set set, Relocator relocator, ZipEntryFilter zipEntryFilter, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addHybridFolder");
        }
        if ((n & 4) != 0) {
            relocator = null;
        }
        if ((n & 8) != 0) {
            zipEntryFilter = null;
        }
        perModuleBundleTask.addHybridFolder(jarMerger, set, relocator, zipEntryFilter);
    }

    @NotNull
    public static final /* synthetic */ Supplier access$getFileNameSupplier$p(PerModuleBundleTask $this) {
        Supplier<String> supplier = $this.fileNameSupplier;
        if (supplier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fileNameSupplier");
        }
        return supplier;
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputDir$p(PerModuleBundleTask $this) {
        File file = $this.outputDir;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDir");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getAssetsFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.assetsFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetsFiles");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getResFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.resFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resFiles");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getDexFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.dexFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dexFiles");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getJavaResFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.javaResFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaResFiles");
        }
        return fileCollection;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getNativeLibsFiles$p(PerModuleBundleTask $this) {
        FileCollection fileCollection = $this.nativeLibsFiles;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"nativeLibsFiles");
        }
        return fileCollection;
    }

    @Nullable
    public static final /* synthetic */ Set access$getAbiFilters$p(PerModuleBundleTask $this) {
        return $this.abiFilters;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/PerModuleBundleTask;", "variantScope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle-core"})
    public static final class ConfigAction
    implements TaskConfigAction<PerModuleBundleTask> {
        private final VariantScope variantScope;

        @Override
        @NotNull
        public String getName() {
            return this.variantScope.getTaskName("build", "PreBundle");
        }

        @Override
        @NotNull
        public Class<PerModuleBundleTask> getType() {
            return PerModuleBundleTask.class;
        }

        @Override
        public void execute(@NotNull PerModuleBundleTask task) {
            Supplier supplier;
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.variantScope.getFullVariantName());
            if (this.variantScope.getType().isBaseModule()) {
                supplier = execute.1.INSTANCE;
            } else {
                Supplier<String> supplier2 = FeatureSetMetadata.getInstance().getFeatureNameSupplierForTask(this.variantScope, (Task)task);
                Intrinsics.checkExpressionValueIsNotNull(supplier2, (String)"FeatureSetMetadata.getIn\u2026rTask(variantScope, task)");
                Supplier<String> featureName = supplier2;
                supplier = new Supplier<String>(featureName){
                    final /* synthetic */ Supplier $featureName;

                    @NotNull
                    public final String get() {
                        return "" + (String)this.$featureName.get() + ".zip";
                    }
                    {
                        this.$featureName = supplier;
                    }
                };
            }
            task.fileNameSupplier = supplier;
            task.outputDir = BuildArtifactsHolder.appendArtifact$default(this.variantScope.getArtifacts(), InternalArtifactType.MODULE_BUNDLE, (Task)task, null, 4, null);
            FileCollection fileCollection = this.variantScope.getOutput(InternalArtifactType.MERGED_ASSETS);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"variantScope.getOutput(I\u2026tifactType.MERGED_ASSETS)");
            task.assetsFiles = fileCollection;
            FileCollection fileCollection2 = this.variantScope.getOutput(InternalArtifactType.LINKED_RES_FOR_BUNDLE);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection2, (String)"variantScope.getOutput(I\u2026pe.LINKED_RES_FOR_BUNDLE)");
            task.resFiles = fileCollection2;
            FileCollection fileCollection3 = this.variantScope.getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.DEX);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection3, (String)"variantScope.transformMa\u2026        StreamFilter.DEX)");
            task.dexFiles = fileCollection3;
            FileCollection fileCollection4 = this.variantScope.getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.RESOURCES);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection4, (String)"variantScope.transformMa\u2026  StreamFilter.RESOURCES)");
            task.javaResFiles = fileCollection4;
            FileCollection fileCollection5 = this.variantScope.getTransformManager().getPipelineOutputAsFileCollection(StreamFilter.NATIVE_LIBS);
            Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection5, (String)"variantScope.transformMa\u2026StreamFilter.NATIVE_LIBS)");
            task.nativeLibsFiles = fileCollection5;
            GradleVariantConfiguration gradleVariantConfiguration = this.variantScope.getVariantConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradleVariantConfiguration, (String)"variantScope.variantConfiguration");
            task.abiFilters = gradleVariantConfiguration.getSupportedAbis();
        }

        public ConfigAction(@NotNull VariantScope variantScope) {
            Intrinsics.checkParameterIsNotNull((Object)variantScope, (String)"variantScope");
            this.variantScope = variantScope;
        }
    }
}

