/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.BuildOutput;
import com.android.build.gradle.internal.scope.ExistingBuildElements;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.ide.common.build.ApkInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class GenerateTestConfig
extends DefaultTask {
    FileCollection resourcesDirectory;
    BuildableArtifact assets;
    Path sdkHome;
    File generatedJavaResourcesDirectory;
    ApkInfo mainApkInfo;
    BuildableArtifact manifests;
    String packageForR;

    @Input
    ApkInfo getMainApkInfo() {
        return this.mainApkInfo;
    }

    @InputFiles
    BuildableArtifact getManifests() {
        return this.manifests;
    }

    @TaskAction
    public void generateTestConfig() throws IOException {
        Preconditions.checkNotNull((Object)this.resourcesDirectory);
        Preconditions.checkNotNull((Object)this.assets);
        Preconditions.checkNotNull((Object)this.sdkHome);
        BuildOutput output2 = ExistingBuildElements.from((ArtifactType)InternalArtifactType.MERGED_MANIFESTS, this.manifests).element(this.mainApkInfo);
        GenerateTestConfig.generateTestConfigForOutput(((File)Iterables.getOnlyElement((Iterable)this.assets)).toPath().toAbsolutePath(), this.resourcesDirectory.getSingleFile().toPath().toAbsolutePath(), this.sdkHome, this.packageForR, ((BuildOutput)Preconditions.checkNotNull((Object)output2, (Object)"Unable to find manifest output")).getOutputFile().toPath(), this.generatedJavaResourcesDirectory.toPath().toAbsolutePath());
    }

    static void generateTestConfigForOutput(Path assetsDir, Path resDir, Path sdkHome, String packageForR, Path manifest, Path outputDir) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("android_sdk_home", sdkHome.toAbsolutePath().toString());
        properties.setProperty("android_merged_resources", resDir.toAbsolutePath().toString());
        properties.setProperty("android_merged_assets", assetsDir.toAbsolutePath().toString());
        properties.setProperty("android_merged_manifest", manifest.toAbsolutePath().toString());
        properties.setProperty("android_custom_package", packageForR);
        Path output2 = outputDir.resolve("com").resolve("android").resolve("tools").resolve("test_config.properties");
        Files.createDirectories(output2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(output2, new OpenOption[0]);){
            properties.store(writer, "# Generated by the Android Gradle Plugin");
        }
    }

    @Input
    public String getResourcesDirectory() {
        return this.resourcesDirectory.getSingleFile().getPath();
    }

    @Input
    public String getAssets() {
        return ((File)Iterables.getOnlyElement((Iterable)this.assets)).getPath();
    }

    @Input
    public String getSdkHome() {
        return this.sdkHome.toString();
    }

    @OutputDirectory
    public File getOutputFile() {
        return this.generatedJavaResourcesDirectory;
    }

    @Input
    public String getPackageForR() {
        return this.packageForR;
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateTestConfig> {
        private final VariantScope scope;
        private final VariantScope testedScope;
        private final File outputDirectory;

        public ConfigAction(VariantScope scope, File outputDirectory) {
            this.scope = scope;
            this.testedScope = ((BaseVariantData)Preconditions.checkNotNull((Object)scope.getTestedVariantData(), (Object)"Not a unit test variant.")).getScope();
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "Config");
        }

        @Override
        public Class<GenerateTestConfig> getType() {
            return GenerateTestConfig.class;
        }

        @Override
        public void execute(GenerateTestConfig task) {
            task.resourcesDirectory = this.testedScope.getOutput(InternalArtifactType.MERGED_NOT_COMPILED_RES);
            task.dependsOn(new Object[]{task.resourcesDirectory});
            task.manifests = this.testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_MANIFESTS);
            task.assets = this.testedScope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.MERGED_ASSETS);
            task.dependsOn(new Object[]{task.assets});
            task.mainApkInfo = this.testedScope.getOutputScope().getMainSplit();
            task.sdkHome = Paths.get(this.scope.getGlobalScope().getAndroidBuilder().getTarget().getLocation(), new String[0]);
            task.generatedJavaResourcesDirectory = this.outputDirectory;
            task.packageForR = this.testedScope.getVariantConfiguration().getOriginalApplicationId();
        }
    }
}

