/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.coverage;

import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.scope.AnchorOutputType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.TaskInputHelper;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.builder.model.Version;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.MultiReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class JacocoReportTask
extends DefaultTask {
    private FileCollection jacocoClasspath;
    private Supplier<File> coverageDirectory;
    private BuildableArtifact classFileCollection;
    private Supplier<Collection<File>> sourceFolders;
    private File coverageFile;
    private File reportDir;
    private String reportName;
    private int tabWidth = 4;
    private WorkerExecutor executor;

    @Inject
    public JacocoReportTask(WorkerExecutor executor) {
        this.executor = executor;
    }

    @InputFile
    @Optional
    public File getCoverageFile() {
        return this.coverageFile;
    }

    public void setCoverageFile(File coverageFile) {
        this.coverageFile = coverageFile;
    }

    @InputDirectory
    @Optional
    public File getCoverageDirectory() {
        return this.coverageDirectory.get();
    }

    @OutputDirectory
    public File getReportDir() {
        return this.reportDir;
    }

    public void setReportDir(File reportDir) {
        this.reportDir = reportDir;
    }

    @InputFiles
    public BuildableArtifact getClassFileCollection() {
        return this.classFileCollection;
    }

    @InputFiles
    public Collection<File> getSourceFolders() {
        return this.sourceFolders.get();
    }

    public String getReportName() {
        return this.reportName;
    }

    @Input
    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    @InputFiles
    public FileCollection getJacocoClasspath() {
        return this.jacocoClasspath;
    }

    public void setJacocoClasspath(FileCollection jacocoClasspath) {
        this.jacocoClasspath = jacocoClasspath;
    }

    @Input
    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @TaskAction
    public void generateReport() throws IOException {
        File coverageFile = this.getCoverageFile();
        File coverageDir = this.coverageDirectory.get();
        ArrayList coverageFiles = Lists.newArrayList();
        if (coverageFile != null) {
            coverageFiles.add(coverageFile);
        }
        if (coverageDir != null) {
            Files.fileTreeTraverser().breadthFirstTraversal((Object)coverageDir).filter(File::isFile).copyInto((Collection)coverageFiles);
        }
        if (coverageFiles.isEmpty()) {
            if (coverageDir == null) {
                throw new IOException("No input file or directory specified.");
            }
            throw new IOException(String.format("No coverage data to process in directory '%1$s'", coverageDir));
        }
        this.executor.submit(JacocoReportWorkerAction.class, workerConfiguration -> {
            workerConfiguration.setIsolationMode(IsolationMode.CLASSLOADER);
            workerConfiguration.classpath((Iterable)this.jacocoClasspath.getFiles());
            workerConfiguration.setParams(new Object[]{coverageFiles, this.getReportDir(), this.getClassFileCollection().getFiles(), this.getSourceFolders(), this.getTabWidth(), this.getReportName()});
        });
    }

    static class JacocoReportWorkerAction
    implements Runnable {
        private static Logger logger = Logging.getLogger(JacocoReportWorkerAction.class);
        private List<File> coverageFiles;
        private File reportDir;
        private Collection<File> classFolders;
        private Collection<File> sourceFolders;
        private int tabWidth;
        String reportName;

        @Inject
        public JacocoReportWorkerAction(List<File> coverageFiles, File reportDir, Collection<File> classFolders, Collection<File> sourceFolders, int tabWidth, String reportName) {
            this.coverageFiles = coverageFiles;
            this.reportDir = reportDir;
            this.classFolders = classFolders;
            this.sourceFolders = sourceFolders;
            this.tabWidth = tabWidth;
            this.reportName = reportName;
        }

        @Override
        public void run() {
            try {
                JacocoReportWorkerAction.generateReport(this.coverageFiles, this.reportDir, this.classFolders, this.sourceFolders, this.tabWidth, this.reportName);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to generate Jacoco report", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void generateReport(List<File> coverageFiles, File reportDir, Collection<File> classFolders, Collection<File> sourceFolders, int tabWidth, String reportName) throws IOException {
            ExecFileLoader loader = new ExecFileLoader();
            for (File coverageFile : coverageFiles) {
                loader.load(coverageFile);
            }
            SessionInfoStore sessionInfoStore = loader.getSessionInfoStore();
            ExecutionDataStore executionDataStore = loader.getExecutionDataStore();
            HTMLFormatter htmlFormatter = new HTMLFormatter();
            htmlFormatter.setOutputEncoding("UTF-8");
            htmlFormatter.setLocale(Locale.US);
            htmlFormatter.setFooterText("Generated by the Android Gradle plugin " + Version.ANDROID_GRADLE_PLUGIN_VERSION);
            FileMultiReportOutput output2 = new FileMultiReportOutput(reportDir);
            IReportVisitor htmlReport = htmlFormatter.createVisitor((IMultiReportOutput)output2);
            XMLFormatter xmlFormatter = new XMLFormatter();
            xmlFormatter.setOutputEncoding("UTF-8");
            OutputStream xmlReportOutput = output2.createFile("report.xml");
            try {
                IReportVisitor xmlReport = xmlFormatter.createVisitor(xmlReportOutput);
                MultiReportVisitor visitor = new MultiReportVisitor((List)ImmutableList.of((Object)htmlReport, (Object)xmlReport));
                visitor.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
                CoverageBuilder builder = new CoverageBuilder();
                Analyzer analyzer = new Analyzer(executionDataStore, (ICoverageVisitor)builder);
                JacocoReportWorkerAction.analyzeAll(analyzer, classFolders);
                MultiSourceFileLocator locator = new MultiSourceFileLocator(0);
                for (File folder : sourceFolders) {
                    locator.add((ISourceFileLocator)new DirectorySourceFileLocator(folder, "UTF-8", tabWidth));
                }
                IBundleCoverage bundle = builder.getBundle(reportName);
                visitor.visitBundle(bundle, (ISourceFileLocator)locator);
                visitor.visitEnd();
            }
            finally {
                try {
                    xmlReportOutput.close();
                }
                catch (IOException e) {
                    logger.error("Could not close xml report file", (Throwable)e);
                }
            }
        }

        private static void analyzeAll(Analyzer analyzer, Collection<File> classFolders) throws IOException {
            for (File folder : classFolders) {
                JacocoReportWorkerAction.analyze(analyzer, folder, classFolders);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void analyze(Analyzer analyzer, File file, Collection<File> originalClassFolders) throws IOException {
            block6: {
                block5: {
                    if (!file.isDirectory()) break block5;
                    File[] files = file.listFiles();
                    if (files == null) break block6;
                    for (File f : files) {
                        if (originalClassFolders.contains(f)) continue;
                        JacocoReportWorkerAction.analyze(analyzer, f, originalClassFolders);
                    }
                    break block6;
                }
                String name = file.getName();
                if (!name.endsWith(".class") || name.equals("R.class") || name.startsWith("R$") || name.equals("Manifest.class") || name.startsWith("Manifest$") || name.equals("BuildConfig.class")) {
                    return;
                }
                FileInputStream in = new FileInputStream(file);
                try {
                    analyzer.analyzeClass((InputStream)in, file.getAbsolutePath());
                }
                finally {
                    Closeables.closeQuietly((InputStream)in);
                }
            }
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<JacocoReportTask> {
        private VariantScope scope;
        private final Configuration jacocoAntConfiguration;

        public ConfigAction(VariantScope scope, Configuration jacocoAntConfiguration) {
            this.scope = scope;
            this.jacocoAntConfiguration = jacocoAntConfiguration;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("create", "CoverageReport");
        }

        @Override
        public Class<JacocoReportTask> getType() {
            return JacocoReportTask.class;
        }

        @Override
        public void execute(JacocoReportTask task) {
            task.setDescription("Creates JaCoCo test coverage report from data gathered on the device.");
            task.setReportName(this.scope.getVariantConfiguration().getFullName());
            Project project = this.scope.getGlobalScope().getProject();
            Preconditions.checkNotNull((Object)this.scope.getTestedVariantData());
            VariantScope testedScope = this.scope.getTestedVariantData().getScope();
            task.jacocoClasspath = (FileCollection)this.jacocoAntConfiguration;
            task.coverageDirectory = TaskInputHelper.memoize(() -> ((TestVariantData)this.scope.getVariantData()).connectedTestTask.getCoverageDir());
            task.classFileCollection = testedScope.getArtifacts().getFinalArtifactFiles(AnchorOutputType.ALL_CLASSES);
            task.sourceFolders = TaskInputHelper.bypassFileSupplier(() -> testedScope.getVariantData().getJavaSourceFoldersForCoverage());
            task.setReportDir(testedScope.getCoverageReportDir());
        }
    }
}

