/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.AsmClassNode;
import com.android.build.gradle.internal.incremental.AsmInterfaceNode;
import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.build.gradle.internal.incremental.Constructor;
import com.android.build.gradle.internal.incremental.ConstructorBuilder;
import com.android.build.gradle.internal.incremental.ConstructorRedirection;
import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.InstantRunMethodVerifier;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.android.build.gradle.internal.incremental.MethodRedirection;
import com.android.build.gradle.internal.incremental.Redirection;
import com.android.build.gradle.internal.incremental.StringSwitch;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class IncrementalSupportVisitor
extends IncrementalVisitor {
    private boolean disableRedirectionForClass = false;
    private boolean isInterface = false;
    private boolean classInitializerAdded = false;
    public static final IncrementalVisitor.VisitorBuilder VISITOR_BUILDER = new VisitorBuilder();

    public IncrementalSupportVisitor(AsmClassNode classNode, ClassVisitor classVisitor, ILogger logger) {
        super(classNode, classVisitor, logger);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int fieldAccess;
        this.visitedClassName = name;
        this.visitedSuperName = superName;
        this.isInterface = (access & 0x200) != 0;
        int n = fieldAccess = this.isInterface ? 4121 : 4297;
        if (this.isInterface) {
            super.visitField(fieldAccess, "$change", IncrementalSupportVisitor.getRuntimeTypeName(Type.getType(AtomicReference.class)), null, null);
        } else {
            super.visitField(fieldAccess, "$change", IncrementalSupportVisitor.getRuntimeTypeName(CHANGE_TYPE), null, null);
        }
        access = IncrementalSupportVisitor.transformClassAccessForInstantRun(access);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        int newAccess = access & 0xFFFFFFF9 | 1;
        super.visitInnerClass(name, outerName, innerName, newAccess);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals(DISABLE_ANNOTATION_TYPE.getDescriptor())) {
            this.disableRedirectionForClass = true;
        }
        return super.visitAnnotation(desc, visible);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        access = IncrementalSupportVisitor.transformAccessForInstantRun(access);
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        ISAbstractMethodVisitor mv;
        boolean isStatic;
        boolean hasIncompatibleChange;
        access = IncrementalSupportVisitor.transformAccessForInstantRun(access);
        MethodVisitor defaultVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        defaultVisitor = new JSRInlinerAdapter(defaultVisitor, access, name, desc, signature, exceptions);
        MethodNode method = (MethodNode)Preconditions.checkNotNull((Object)IncrementalSupportVisitor.getMethodByNameInClass(name, desc, this.classAndInterfaceNode), (Object)"Method found by visitor but not in the pre-parsed class node.");
        boolean bl = hasIncompatibleChange = InstantRunMethodVerifier.verifyMethod(method) != InstantRunVerifierStatus.COMPATIBLE;
        if (hasIncompatibleChange || this.disableRedirectionForClass || !IncrementalSupportVisitor.isAccessCompatibleWithInstantRun(access)) {
            return defaultVisitor;
        }
        if (name.equals("<clinit>")) {
            this.classInitializerAdded = true;
            return this.isInterface ? new ISInterfaceStaticInitializerMethodVisitor(defaultVisitor, access, name, desc) : defaultVisitor;
        }
        ArrayList<Type> args = new ArrayList<Type>(Arrays.asList(Type.getArgumentTypes((String)desc)));
        boolean bl2 = isStatic = (access & 8) != 0;
        if (!isStatic) {
            args.add(0, Type.getType(Object.class));
        }
        ISAbstractMethodVisitor iSAbstractMethodVisitor = mv = this.isInterface ? new ISDefaultMethodVisitor(defaultVisitor, access, name, desc) : new ISMethodVisitor(defaultVisitor, access, name, desc);
        if (name.equals("<init>")) {
            if ((access & 0x1000) != 0 || ByteCodeUtils.isAnnotatedWith(method, "Lkotlin/jvm/JvmOverloads;")) {
                return defaultVisitor;
            }
            Constructor constructor2 = ConstructorBuilder.build(this.visitedClassName, method);
            LabelNode start = new LabelNode();
            method.instructions.insert((AbstractInsnNode)constructor2.loadThis, (AbstractInsnNode)start);
            if (constructor2.lineForLoad != -1) {
                method.instructions.insert((AbstractInsnNode)constructor2.loadThis, (AbstractInsnNode)new LineNumberNode(constructor2.lineForLoad, start));
            }
            mv.addRedirection(new ConstructorRedirection(start, constructor2, args));
        } else {
            mv.addRedirection(new MethodRedirection(new LabelNode(mv.getStartLabel()), name + "." + desc, args, Type.getReturnType((String)desc)));
        }
        method.accept((MethodVisitor)mv);
        return null;
    }

    private static int transformClassAccessForInstantRun(int access) {
        IncrementalVisitor.AccessRight accessRight = IncrementalVisitor.AccessRight.fromNodeAccess(access);
        return accessRight == IncrementalVisitor.AccessRight.PACKAGE_PRIVATE ? access | 1 : access;
    }

    private static int transformAccessForInstantRun(int access) {
        IncrementalVisitor.AccessRight accessRight = IncrementalVisitor.AccessRight.fromNodeAccess(access);
        if (accessRight != IncrementalVisitor.AccessRight.PRIVATE) {
            access &= 0xFFFFFFFB;
            return (access &= 0xFFFFFFFD) | 1;
        }
        return access;
    }

    private void createAccessSuper() {
        int access = 4233;
        Method m = new Method("access$super", "(L" + this.visitedClassName + ";Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;");
        MethodVisitor visitor = super.visitMethod(access, m.getName(), m.getDescriptor(), null, null);
        final GeneratorAdapter mv = new GeneratorAdapter(access, m, visitor);
        final HashMap<String, MethodReference> uniqueMethods = new HashMap<String, MethodReference>();
        if (this.classAndInterfaceNode.hasParent()) {
            this.addAllNewMethods(this.classAndInterfaceNode.getClassNode(), this.classAndInterfaceNode.getParent(), uniqueMethods);
        } else {
            this.addAllNewMethods(this.classAndInterfaceNode.getClassNode(), this.classAndInterfaceNode.getClassNode(), uniqueMethods);
        }
        for (AsmInterfaceNode implementedInterface : this.classAndInterfaceNode.getInterfaces()) {
            this.addDefaultMethods(this.classAndInterfaceNode.getClassNode(), implementedInterface, uniqueMethods);
            implementedInterface.onAll(interfaceNode -> {
                this.addAllNewMethods(this.classAndInterfaceNode.getClassNode(), (ClassNode)interfaceNode, (Map<String, MethodReference>)uniqueMethods);
                return null;
            });
        }
        new StringSwitch(){

            @Override
            void visitString() {
                mv.visitVarInsn(25, 1);
            }

            @Override
            void visitCase(String methodName) {
                MethodReference methodRef = (MethodReference)uniqueMethods.get(methodName);
                mv.visitVarInsn(25, 0);
                Type[] args = Type.getArgumentTypes((String)methodRef.method.desc);
                int argc = 0;
                for (Type t : args) {
                    mv.visitVarInsn(25, 2);
                    mv.push(argc);
                    mv.visitInsn(50);
                    ByteCodeUtils.unbox(mv, t);
                    ++argc;
                }
                if (IncrementalVisitor.TRACING_ENABLED) {
                    IncrementalVisitor.trace(mv, "super selected ", methodRef.owner.name, methodRef.method.name, methodRef.method.desc);
                }
                String parentName = IncrementalSupportVisitor.this.findParentClassForMethod(methodRef);
                IncrementalSupportVisitor.this.logger.verbose("Generating access$super for %1$s recev %2$s", new Object[]{methodRef.method.name, parentName});
                mv.visitMethodInsn(183, parentName, methodRef.method.name, methodRef.method.desc, false);
                Type ret = Type.getReturnType((String)methodRef.method.desc);
                if (ret.getSort() == 0) {
                    mv.visitInsn(1);
                } else {
                    mv.box(ret);
                }
                mv.visitInsn(176);
            }

            @Override
            void visitDefault() {
                this.writeMissingMessageWithHash(mv, IncrementalSupportVisitor.this.visitedClassName);
            }
        }.visit(mv, uniqueMethods.keySet());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void createDispatchingThis() {
        final HashMap<String, MethodNode> uniqueMethods = new HashMap<String, MethodNode>();
        this.addAllNewConstructors(uniqueMethods, this.classAndInterfaceNode.getClassNode(), true);
        this.classAndInterfaceNode.onParents(parentClassNode -> {
            this.addAllNewConstructors((Map<String, MethodNode>)uniqueMethods, (ClassNode)parentClassNode, false);
            return null;
        });
        int access = 4097;
        Method m = new Method("<init>", ConstructorRedirection.DISPATCHING_THIS_SIGNATURE);
        MethodVisitor visitor = super.visitMethod(0, m.getName(), m.getDescriptor(), null, null);
        final GeneratorAdapter mv = new GeneratorAdapter(access, m, visitor);
        mv.visitCode();
        Label label = new Label();
        mv.visitLineNumber(0, label);
        mv.visitVarInsn(25, 1);
        mv.push(1);
        mv.visitInsn(50);
        mv.unbox(Type.getType((String)"Ljava/lang/String;"));
        final int constructorCanonicalName = mv.newLocal(Type.getType((String)"Ljava/lang/String;"));
        mv.storeLocal(constructorCanonicalName);
        new StringSwitch(){

            @Override
            void visitString() {
                mv.loadLocal(constructorCanonicalName);
            }

            @Override
            void visitCase(String canonicalName) {
                MethodNode methodNode = (MethodNode)uniqueMethods.get(canonicalName);
                String owner = canonicalName.split("\\.")[0];
                mv.visitVarInsn(25, 0);
                Type[] args = Type.getArgumentTypes((String)methodNode.desc);
                int argc = 1;
                for (Type t : args) {
                    mv.visitVarInsn(25, 1);
                    mv.push(argc + 1);
                    mv.visitInsn(50);
                    ByteCodeUtils.unbox(mv, t);
                    ++argc;
                }
                mv.visitMethodInsn(183, owner, "<init>", methodNode.desc, false);
                mv.visitInsn(177);
            }

            @Override
            void visitDefault() {
                this.writeMissingMessageWithHash(mv, IncrementalSupportVisitor.this.visitedClassName);
            }
        }.visit(mv, uniqueMethods.keySet());
        mv.visitMaxs(1, 3);
        mv.visitEnd();
    }

    private void addInterfaceClassInitializer() {
        if (this.classInitializerAdded) {
            return;
        }
        MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        this.addInterfaceClassInitializerCode(mv);
        mv.visitInsn(177);
        mv.visitMaxs(3, 0);
        mv.visitEnd();
    }

    private void addInterfaceClassInitializerCode(MethodVisitor mv) {
        mv.visitTypeInsn(187, "java/util/concurrent/atomic/AtomicReference");
        mv.visitInsn(89);
        mv.visitInsn(1);
        mv.visitMethodInsn(183, "java/util/concurrent/atomic/AtomicReference", "<init>", "(Ljava/lang/Object;)V", false);
        mv.visitFieldInsn(179, this.visitedClassName, "$change", "Ljava/util/concurrent/atomic/AtomicReference;");
    }

    public void visitEnd() {
        this.createAccessSuper();
        if (this.isInterface) {
            this.addInterfaceClassInitializer();
        } else {
            this.createDispatchingThis();
        }
        super.visitEnd();
    }

    String findParentClassForMethod(MethodReference methodReference) {
        this.logger.verbose("MethodRef %1$s access(%2$s) -> owner %3$s access(%4$s)", new Object[]{methodReference.method.name, methodReference.method.access, methodReference.owner.name, methodReference.owner.access});
        if (IncrementalSupportVisitor.isParentClassVisible(methodReference.owner, this.classAndInterfaceNode.getClassNode())) {
            return methodReference.owner.name;
        }
        this.logger.verbose("Found an inaccessible methodReference %1$s", new Object[]{methodReference.method.name});
        if (this.classAndInterfaceNode.hasParent()) {
            String selectedParent;
            AsmClassNode asmClassNode = this.classAndInterfaceNode.getParent();
            while (!asmClassNode.getClassNode().name.equals(methodReference.owner.name) && asmClassNode.hasParent()) {
                asmClassNode = asmClassNode.getParent();
            }
            if (asmClassNode.hasParent() && (selectedParent = asmClassNode.onParents(parentClassNode -> {
                if (IncrementalSupportVisitor.isParentClassVisible(parentClassNode, this.classAndInterfaceNode.getClassNode())) {
                    for (MethodNode methodNode : parentClassNode.methods) {
                        if (!methodNode.name.equals(methodReference.method.name) || !methodNode.desc.equals(methodReference.method.desc) || (methodNode.access & 0x440) != 0) continue;
                        this.logger.verbose("Using class %1$s for dispatching %2$s:%3$s", new Object[]{parentClassNode.name, methodReference.method.name, methodReference.method.desc});
                        return parentClassNode.name;
                    }
                }
                return null;
            })) != null) {
                return selectedParent;
            }
        }
        this.logger.verbose("Using immediate parent for dispatching %1$s", new Object[]{methodReference.method.desc});
        return this.classAndInterfaceNode.getClassNode().superName;
    }

    private static boolean isParentClassVisible(ClassNode parent, ClassNode child) {
        return (parent.access & 5) != 0 || Objects.equal(ByteCodeUtils.getPackageName(parent.name), ByteCodeUtils.getPackageName(child.name));
    }

    private void addAllNewMethods(ClassNode instrumentedClass, AsmClassNode superClass, Map<String, MethodReference> methods) {
        superClass.onAll(classNode -> {
            this.addAllNewMethods(instrumentedClass, (ClassNode)classNode, methods);
            return null;
        });
    }

    private List<MethodReference> addAllNewMethods(ClassNode instrumentedClass, ClassNode superClass, Map<String, MethodReference> methods) {
        ImmutableList.Builder methodRefs = ImmutableList.builder();
        for (MethodNode method : superClass.methods) {
            MethodReference methodRef = IncrementalSupportVisitor.addNewMethod(instrumentedClass, superClass, method, methods);
            if (methodRef == null) continue;
            methodRefs.add((Object)methodRef);
        }
        return methodRefs.build();
    }

    private Void addDefaultMethods(ClassNode instrumentedClass, AsmInterfaceNode implementedInterface, Map<String, MethodReference> methods) {
        HashMap visitedInterfaceMethods = new HashMap();
        implementedInterface.onAll(interfaceNode -> {
            this.addAllNewMethods(instrumentedClass, (ClassNode)interfaceNode, methods).forEach(methodRef -> visitedInterfaceMethods.put(((MethodReference)methodRef).getDefautlDispatchName(), methodRef));
            return null;
        });
        for (MethodNode methodNode : implementedInterface.getClassNode().methods) {
            visitedInterfaceMethods.remove(MethodReference.getDefaultDispatchName(methodNode));
        }
        for (MethodReference methodReference : visitedInterfaceMethods.values()) {
            IncrementalSupportVisitor.addNewMethod(implementedInterface.getClassNode().name + "." + methodReference.getDefautlDispatchName(), instrumentedClass, implementedInterface.getClassNode(), methodReference.method, methods);
        }
        return null;
    }

    private static MethodReference addNewMethod(ClassNode instrumentedClass, ClassNode superClass, MethodNode method, Map<String, MethodReference> methods) {
        if (method.name.equals("<init>") || method.name.equals("<clinit>")) {
            return null;
        }
        String name = MethodReference.getDefaultDispatchName(method);
        if ((superClass.access & 0x200) != 0 && IncrementalSupportVisitor.isParentClassVisible(superClass, instrumentedClass)) {
            name = superClass.name + "." + name;
        }
        return IncrementalSupportVisitor.addNewMethod(name, instrumentedClass, superClass, method, methods);
    }

    private static MethodReference addNewMethod(String name, ClassNode instrumentedClass, ClassNode superClass, MethodNode method, Map<String, MethodReference> methods) {
        if (IncrementalSupportVisitor.isAccessCompatibleWithInstantRun(method.access) && !methods.containsKey(name) && (method.access & 8) == 0 && IncrementalSupportVisitor.isCallableFromSubclass(method, superClass, instrumentedClass)) {
            MethodReference methodReference = new MethodReference(method, superClass);
            methods.put(name, methodReference);
            return methodReference;
        }
        return null;
    }

    private static boolean isCallableFromSubclass(MethodNode method, ClassNode superClass, ClassNode subclass) {
        if ((method.access & 2) != 0) {
            return false;
        }
        if ((method.access & 5) != 0) {
            return true;
        }
        return Objects.equal(ByteCodeUtils.getPackageName(superClass.name), ByteCodeUtils.getPackageName(subclass.name));
    }

    private void addAllNewConstructors(Map<String, MethodNode> methods, ClassNode classNode, boolean keepPrivateConstructors) {
        for (MethodNode method : classNode.methods) {
            String key;
            if (!method.name.equals("<init>") || !IncrementalSupportVisitor.isAccessCompatibleWithInstantRun(method.access) || !keepPrivateConstructors && (method.access & 2) != 0 || !classNode.name.equals(this.visitedClassName) && !classNode.name.equals(this.visitedSuperName) || methods.containsKey(key = classNode.name + "." + method.desc)) continue;
            methods.put(key, method);
        }
    }

    private static class MethodReference {
        final MethodNode method;
        final ClassNode owner;

        private MethodReference(MethodNode method, ClassNode owner) {
            this.method = method;
            this.owner = owner;
        }

        private String getDefautlDispatchName() {
            return MethodReference.getDefaultDispatchName(this.method);
        }

        private static String getDefaultDispatchName(MethodNode method) {
            return method.name + "." + method.desc;
        }
    }

    private class ISInterfaceStaticInitializerMethodVisitor
    extends GeneratorAdapter {
        public ISInterfaceStaticInitializerMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
        }

        public void visitCode() {
            IncrementalSupportVisitor.this.addInterfaceClassInitializerCode((MethodVisitor)this);
            super.visitCode();
        }
    }

    private class ISDefaultMethodVisitor
    extends ISAbstractMethodVisitor {
        public ISDefaultMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(mv, access, name, desc);
        }

        @Override
        protected void visitChangeField() {
            this.visitFieldInsn(178, IncrementalSupportVisitor.this.visitedClassName, "$change", IncrementalVisitor.getRuntimeTypeName(Type.getType(AtomicReference.class)));
            this.mv.visitMethodInsn(182, "java/util/concurrent/atomic/AtomicReference", "get", "()Ljava/lang/Object;", false);
        }
    }

    private class ISMethodVisitor
    extends ISAbstractMethodVisitor {
        public ISMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(mv, access, name, desc);
        }

        @Override
        protected void visitChangeField() {
            this.visitFieldInsn(178, IncrementalSupportVisitor.this.visitedClassName, "$change", IncrementalVisitor.getRuntimeTypeName(IncrementalVisitor.CHANGE_TYPE));
        }
    }

    private static abstract class ISAbstractMethodVisitor
    extends GeneratorAdapter {
        protected boolean disableRedirection = false;
        protected int change = -1;
        protected final List<Type> args;
        protected final List<Redirection> redirections = new ArrayList<Redirection>();
        protected final Map<Label, Redirection> resolvedRedirections = new HashMap<Label, Redirection>();
        protected final Label start;

        public ISAbstractMethodVisitor(MethodVisitor mv, int access, String name, String desc) {
            super(327680, mv, access, name, desc);
            boolean isStatic;
            this.args = new ArrayList<Type>(Arrays.asList(Type.getArgumentTypes((String)desc)));
            this.start = new Label();
            boolean bl = isStatic = (access & 8) != 0;
            if (!isStatic) {
                this.args.add(0, Type.getType(Object.class));
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(IncrementalVisitor.DISABLE_ANNOTATION_TYPE.getDescriptor())) {
                this.disableRedirection = true;
            }
            return super.visitAnnotation(desc, visible);
        }

        public void visitCode() {
            if (!this.disableRedirection) {
                for (Redirection redirection : this.redirections) {
                    this.resolvedRedirections.put(redirection.getPosition().getLabel(), redirection);
                }
                super.visitLabel(this.start);
                this.change = this.newLocal(IncrementalVisitor.CHANGE_TYPE);
                this.visitChangeField();
                this.storeLocal(this.change);
                this.redirectAt(this.start);
            }
            super.visitCode();
        }

        protected abstract void visitChangeField();

        public void visitLabel(Label label) {
            super.visitLabel(label);
            this.redirectAt(label);
        }

        protected void redirectAt(Label label) {
            if (this.disableRedirection) {
                return;
            }
            Redirection redirection = this.resolvedRedirections.get(label);
            if (redirection != null) {
                super.visitLineNumber(0, label);
                redirection.redirect(this, this.change);
            }
        }

        public void addRedirection(Redirection redirection) {
            this.redirections.add(redirection);
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (!this.disableRedirection && index < this.args.size()) {
                start = this.start;
            }
            super.visitLocalVariable(name, desc, signature, start, end, index);
        }

        public Label getStartLabel() {
            return this.start;
        }
    }

    private static final class VisitorBuilder
    implements IncrementalVisitor.VisitorBuilder {
        private VisitorBuilder() {
        }

        @Override
        public IncrementalVisitor build(AsmClassNode classNode, ClassVisitor classVisitor, ILogger logger) {
            return new IncrementalSupportVisitor(classNode, classVisitor, logger);
        }

        @Override
        public String getMangledRelativeClassFilePath(String originalClassFilePath) {
            return originalClassFilePath;
        }

        @Override
        public IncrementalVisitor.OutputType getOutputType() {
            return IncrementalVisitor.OutputType.INSTRUMENT;
        }
    }
}

