/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.SdkConstants;
import com.android.build.api.artifact.ArtifactType;
import com.android.build.api.artifact.BuildableArtifact;
import com.android.build.gradle.internal.api.artifact.BuildableArtifactUtil;
import com.android.build.gradle.internal.res.Aapt2MavenUtils;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.InternalArtifactType;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.tasks.WorkerExecutorAdapter;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.model.Aapt2Command;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0018\u001a\u00020\u0019H\u0007R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR&\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128\u0007@BX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask;", "Lcom/android/build/gradle/internal/tasks/AndroidVariantTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "<set-?>", "Lorg/gradle/api/file/FileCollection;", "aapt2FromMaven", "getAapt2FromMaven", "()Lorg/gradle/api/file/FileCollection;", "setAapt2FromMaven", "(Lorg/gradle/api/file/FileCollection;)V", "Lcom/android/build/api/artifact/BuildableArtifact;", "bundle", "getBundle", "()Lcom/android/build/api/artifact/BuildableArtifact;", "setBundle", "(Lcom/android/build/api/artifact/BuildableArtifact;)V", "Ljava/io/File;", "outputFile", "getOutputFile", "()Ljava/io/File;", "setOutputFile", "(Ljava/io/File;)V", "generateApk", "", "BundleToolRunnable", "ConfigAction", "Params", "gradle-core"})
public class BundleToApkTask
extends AndroidVariantTask {
    @NotNull
    private BuildableArtifact bundle;
    @NotNull
    private FileCollection aapt2FromMaven;
    @NotNull
    private File outputFile;
    private final WorkerExecutor workerExecutor;

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final BuildableArtifact getBundle() {
        BuildableArtifact buildableArtifact = this.bundle;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return buildableArtifact;
    }

    private final void setBundle(BuildableArtifact buildableArtifact) {
        this.bundle = buildableArtifact;
    }

    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public final FileCollection getAapt2FromMaven() {
        FileCollection fileCollection = this.aapt2FromMaven;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aapt2FromMaven");
        }
        return fileCollection;
    }

    private final void setAapt2FromMaven(FileCollection fileCollection) {
        this.aapt2FromMaven = fileCollection;
    }

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        File file = this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    private final void setOutputFile(File file) {
        this.outputFile = file;
    }

    @TaskAction
    public final void generateApk() {
        WorkerExecutorAdapter<Serializable> adapter = new WorkerExecutorAdapter<Serializable>(this.workerExecutor, BundleToolRunnable.class);
        BuildableArtifact buildableArtifact = this.bundle;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        File file = BuildableArtifactUtil.singleFile(buildableArtifact);
        FileCollection fileCollection = this.aapt2FromMaven;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aapt2FromMaven");
        }
        File file2 = new File(fileCollection.getSingleFile(), SdkConstants.FN_AAPT2);
        File file3 = this.outputFile;
        if (file3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        adapter.submit(new Params(file, file2, file3));
        adapter.taskActionDone();
    }

    @Inject
    public BundleToApkTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }

    @NotNull
    public static final /* synthetic */ File access$getOutputFile$p(BundleToApkTask $this) {
        File file = $this.outputFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputFile");
        }
        return file;
    }

    @NotNull
    public static final /* synthetic */ BuildableArtifact access$getBundle$p(BundleToApkTask $this) {
        BuildableArtifact buildableArtifact = $this.bundle;
        if (buildableArtifact == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bundle");
        }
        return buildableArtifact;
    }

    @NotNull
    public static final /* synthetic */ FileCollection access$getAapt2FromMaven$p(BundleToApkTask $this) {
        FileCollection fileCollection = $this.aapt2FromMaven;
        if (fileCollection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aapt2FromMaven");
        }
        return fileCollection;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;", "Ljava/io/Serializable;", "bundleFile", "Ljava/io/File;", "aapt2File", "outputFile", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getAapt2File", "()Ljava/io/File;", "getBundleFile", "getOutputFile", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "gradle-core"})
    private static final class Params
    implements Serializable {
        @NotNull
        private final File bundleFile;
        @NotNull
        private final File aapt2File;
        @NotNull
        private final File outputFile;

        @NotNull
        public final File getBundleFile() {
            return this.bundleFile;
        }

        @NotNull
        public final File getAapt2File() {
            return this.aapt2File;
        }

        @NotNull
        public final File getOutputFile() {
            return this.outputFile;
        }

        public Params(@NotNull File bundleFile, @NotNull File aapt2File, @NotNull File outputFile) {
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            Intrinsics.checkParameterIsNotNull((Object)aapt2File, (String)"aapt2File");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            this.bundleFile = bundleFile;
            this.aapt2File = aapt2File;
            this.outputFile = outputFile;
        }

        @NotNull
        public final File component1() {
            return this.bundleFile;
        }

        @NotNull
        public final File component2() {
            return this.aapt2File;
        }

        @NotNull
        public final File component3() {
            return this.outputFile;
        }

        @NotNull
        public final Params copy(@NotNull File bundleFile, @NotNull File aapt2File, @NotNull File outputFile) {
            Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
            Intrinsics.checkParameterIsNotNull((Object)aapt2File, (String)"aapt2File");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            return new Params(bundleFile, aapt2File, outputFile);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Params copy$default(Params params, File file, File file2, File file3, int n, Object object) {
            if ((n & 1) != 0) {
                file = params.bundleFile;
            }
            if ((n & 2) != 0) {
                file2 = params.aapt2File;
            }
            if ((n & 4) != 0) {
                file3 = params.outputFile;
            }
            return params.copy(file, file2, file3);
        }

        public String toString() {
            return "Params(bundleFile=" + this.bundleFile + ", aapt2File=" + this.aapt2File + ", outputFile=" + this.outputFile + ")";
        }

        public int hashCode() {
            File file = this.bundleFile;
            File file2 = this.aapt2File;
            File file3 = this.outputFile;
            return ((file != null ? ((Object)file).hashCode() : 0) * 31 + (file2 != null ? ((Object)file2).hashCode() : 0)) * 31 + (file3 != null ? ((Object)file3).hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Params)) break block3;
                    Params params = (Params)object;
                    if (!Intrinsics.areEqual((Object)this.bundleFile, (Object)params.bundleFile) || !Intrinsics.areEqual((Object)this.aapt2File, (Object)params.aapt2File) || !Intrinsics.areEqual((Object)this.outputFile, (Object)params.outputFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$BundleToolRunnable;", "Ljava/lang/Runnable;", "params", "Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;", "(Lcom/android/build/gradle/internal/tasks/BundleToApkTask$Params;)V", "run", "", "gradle-core"})
    private static final class BundleToolRunnable
    implements Runnable {
        private final Params params;

        @Override
        public void run() {
            FileUtils.deleteIfExists((File)this.params.getOutputFile());
            BuildApksCommand.Builder command = BuildApksCommand.builder().setBundlePath(this.params.getBundleFile().toPath()).setOutputFile(this.params.getOutputFile().toPath()).setAapt2Command(Aapt2Command.createFromExecutablePath((Path)this.params.getAapt2File().toPath()));
            command.build().execute();
        }

        @Inject
        public BundleToolRunnable(@NotNull Params params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.params = params;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/build/gradle/internal/tasks/BundleToApkTask$ConfigAction;", "Lcom/android/build/gradle/internal/scope/TaskConfigAction;", "Lcom/android/build/gradle/internal/tasks/BundleToApkTask;", "scope", "Lcom/android/build/gradle/internal/scope/VariantScope;", "(Lcom/android/build/gradle/internal/scope/VariantScope;)V", "execute", "", "task", "getName", "", "getType", "Ljava/lang/Class;", "gradle-core"})
    public static final class ConfigAction
    implements TaskConfigAction<BundleToApkTask> {
        private final VariantScope scope;

        @Override
        @NotNull
        public String getName() {
            return this.scope.getTaskName("makeApkFromBundleFor");
        }

        @Override
        @NotNull
        public Class<BundleToApkTask> getType() {
            return BundleToApkTask.class;
        }

        @Override
        public void execute(@NotNull BundleToApkTask task) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            task.setVariantName(this.scope.getFullVariantName());
            task.outputFile = this.scope.getArtifacts().appendArtifact((ArtifactType)InternalArtifactType.APKS_FROM_BUNDLE, (Task)task, "bundle.apks");
            task.bundle = this.scope.getArtifacts().getFinalArtifactFiles(InternalArtifactType.BUNDLE);
            GlobalScope globalScope = this.scope.getGlobalScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalScope, (String)"scope.globalScope");
            task.aapt2FromMaven = Aapt2MavenUtils.getAapt2FromMaven(globalScope);
        }

        public ConfigAction(@NotNull VariantScope scope) {
            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
            this.scope = scope;
        }
    }
}

