/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.maven.MavenDeployer;
import org.gradle.api.plugins.MavenPlugin;
import org.gradle.api.tasks.Upload;

public class VariantHelper {
    public static void setupArchivesConfig(Project project, Configuration configuration) {
        Configuration archivesConfig = project.getConfigurations().getAt("archives");
        archivesConfig.setExtendsFrom(Collections.singleton(configuration));
        Set<Configuration> flattenedConfigs = VariantHelper.flattenConfigurations(configuration);
        project.getPlugins().withType(MavenPlugin.class, mavenPlugin -> project.getTasks().withType(Upload.class, upload -> upload.getRepositories().withType(MavenDeployer.class, mavenDeployer -> {
            for (Configuration config2 : flattenedConfigs) {
                mavenDeployer.getPom().getScopeMappings().addMapping(300, project.getConfigurations().getByName(config2.getName()), "compile");
            }
        })));
    }

    private static Set<Configuration> flattenConfigurations(Configuration configuration) {
        HashSet configs = Sets.newHashSet();
        configs.add(configuration);
        for (Configuration extend : configuration.getExtendsFrom()) {
            configs.addAll(VariantHelper.flattenConfigurations(extend));
        }
        return configs;
    }
}

